% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{pathling_search_to_column}
\alias{pathling_search_to_column}
\title{Convert a FHIR search expression to a Spark Column}
\usage{
pathling_search_to_column(pc, resource_type, search_expression)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{resource_type}{A string containing the FHIR resource type code (e.g., "Patient",
"Observation").}

\item{search_expression}{A FHIR search query string in URL query format (e.g.,
"gender=male&birthdate=ge1990-01-01"). An empty string matches all resources.}
}
\value{
A Spark Column object (\code{spark_jobj}) representing the boolean filter condition.
}
\description{
Converts a FHIR search query string into a Spark Column representing a boolean filter condition.
The returned Column can be used with sparklyr DataFrame operations such as \code{sdf_filter} to
filter resources matching the search criteria.
}
\examples{
\dontrun{
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))
patients <- data_source \%>\% ds_read("Patient")

# Filter patients by gender.
gender_filter <- pathling_search_to_column(pc, "Patient", "gender=male")
filtered <- sparklyr::spark_dataframe(patients) \%>\%
  sparklyr::j_invoke("filter", gender_filter) \%>\%
  sparklyr::sdf_register()

# Multiple search parameters (AND).
combined_filter <- pathling_search_to_column(pc, "Patient", "gender=male&active=true")

pathling_disconnect(pc)
}
}
\seealso{
Other context functions: 
\code{\link{pathling_fhirpath_to_column}()},
\code{\link{pathling_filter}()},
\code{\link{pathling_with_column}()}
}
\concept{context functions}
