% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{remove_vel_anomalies}
\alias{remove_vel_anomalies}
\title{Remove any rows which show sharp shifts in velocity that are likely due to
tracking errors}
\usage{
remove_vel_anomalies(
  obj_name,
  target = "velocity",
  method = "gesd",
  alpha = 0.05,
  max_anoms = 0.2
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{target}{The column to target; defaults to "velocity"}

\item{method}{The anomaly detection method; see anomalize::anomalize()}

\item{alpha}{The width of the "normal" range; see anomalize::anomalize()}

\item{max_anoms}{The max proportion of anomalies; see anomalize::anomalize()}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps}. Rows in which large anomalies were detected have
been removed. No additional columns are created.
}
\description{
Remove any rows which show sharp shifts in velocity that are likely due to
tracking errors
}
\details{
This function runs anomalize::anomalize() on a per-trajectory basis.
The separate_trajectories() and get_full_trajectories() must be run prior
to use.
}
\seealso{
Other utility functions: 
\code{\link{clean_by_span}()},
\code{\link{insert_treatments}()},
\code{\link{remove_duplicate_frames}()},
\code{\link{set_traj_frametime}()}
}
\author{
Vikram B. Baliga
}
\concept{utility functions}
