% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_poll_for_task}
\alias{datapipeline_poll_for_task}
\title{Task runners call PollForTask to receive a task to perform from AWS Data
Pipeline}
\usage{
datapipeline_poll_for_task(
  workerGroup,
  hostname = NULL,
  instanceIdentity = NULL
)
}
\arguments{
\item{workerGroup}{[required] The type of task the task runner is configured to accept and process.
The worker group is set as a field on objects in the pipeline when they
are created. You can only specify a single value for \code{workerGroup} in
the call to \code{\link[=datapipeline_poll_for_task]{poll_for_task}}. There are no
wildcard values permitted in \code{workerGroup}; the string must be an exact,
case-sensitive, match.}

\item{hostname}{The public DNS name of the calling task runner.}

\item{instanceIdentity}{Identity information for the EC2 instance that is hosting the task
runner. You can get this value from the instance using
\verb{http://169.254.169.254/latest/meta-data/instance-id}. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance Metadata}
in the \emph{Amazon Elastic Compute Cloud User Guide.} Passing in this value
proves that your task runner is running on an EC2 instance, and ensures
the proper AWS Data Pipeline service charges are applied to your
pipeline.}
}
\description{
Task runners call \code{\link[=datapipeline_poll_for_task]{poll_for_task}} to receive a task to perform from AWS Data Pipeline. The task runner specifies which tasks it can perform by setting a value for the \code{workerGroup} parameter. The task returned can come from any of the pipelines that match the \code{workerGroup} value passed in by the task runner and that was launched using the IAM user credentials specified by the task runner.

See \url{https://www.paws-r-sdk.com/docs/datapipeline_poll_for_task/} for full documentation.
}
\keyword{internal}
