# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lambda_service.R
NULL

#' Adds permissions to the resource-based policy of a version of an Lambda
#' layer
#'
#' @description
#' Adds permissions to the resource-based policy of a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html). Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_add_layer_version_permission/](https://www.paws-r-sdk.com/docs/lambda_add_layer_version_permission/) for full documentation.
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#' @param StatementId &#91;required&#93; An identifier that distinguishes the policy from others on the same
#' layer version.
#' @param Action &#91;required&#93; The API action that grants access to the layer. For example,
#' `lambda:GetLayerVersion`.
#' @param Principal &#91;required&#93; An account ID, or `*` to grant layer usage permission to all accounts in
#' an organization, or all Amazon Web Services accounts (if
#' `organizationId` is not specified). For the last case, make sure that
#' you really do want all Amazon Web Services accounts to have usage
#' permission to this layer.
#' @param OrganizationId With the principal set to `*`, grant permission to all accounts in the
#' specified organization.
#' @param RevisionId Only update the policy if the revision ID matches the ID specified. Use
#' this option to avoid modifying a policy that has changed since you last
#' read it.
#'
#' @keywords internal
#'
#' @rdname lambda_add_layer_version_permission
lambda_add_layer_version_permission <- function(LayerName, VersionNumber, StatementId, Action, Principal, OrganizationId = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "AddLayerVersionPermission",
    http_method = "POST",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$add_layer_version_permission_input(LayerName = LayerName, VersionNumber = VersionNumber, StatementId = StatementId, Action = Action, Principal = Principal, OrganizationId = OrganizationId, RevisionId = RevisionId)
  output <- .lambda$add_layer_version_permission_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$add_layer_version_permission <- lambda_add_layer_version_permission

#' Grants a principal permission to use a function
#'
#' @description
#' Grants a [principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying) permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding policies to version $LATEST.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_add_permission/](https://www.paws-r-sdk.com/docs/lambda_add_permission/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param StatementId &#91;required&#93; A statement identifier that differentiates the statement from others in
#' the same policy.
#' @param Action &#91;required&#93; The action that the principal can use on the function. For example,
#' `lambda:InvokeFunction` or `lambda:GetFunction`.
#' @param Principal &#91;required&#93; The Amazon Web Services service, Amazon Web Services account, IAM user,
#' or IAM role that invokes the function. If you specify a service, use
#' `SourceArn` or `SourceAccount` to limit who can invoke the function
#' through that service.
#' @param SourceArn For Amazon Web Services services, the ARN of the Amazon Web Services
#' resource that invokes the function. For example, an Amazon S3 bucket or
#' Amazon SNS topic.
#' 
#' Note that Lambda configures the comparison using the `StringLike`
#' operator.
#' @param SourceAccount For Amazon Web Services service, the ID of the Amazon Web Services
#' account that owns the resource. Use this together with `SourceArn` to
#' ensure that the specified account owns the resource. It is possible for
#' an Amazon S3 bucket to be deleted by its owner and recreated by another
#' account.
#' @param EventSourceToken For Alexa Smart Home functions, a token that the invoker must supply.
#' @param Qualifier Specify a version or alias to add permissions to a published version of
#' the function.
#' @param RevisionId Update the policy only if the revision ID matches the ID that's
#' specified. Use this option to avoid modifying a policy that has changed
#' since you last read it.
#' @param PrincipalOrgID The identifier for your organization in Organizations. Use this to grant
#' permissions to all the Amazon Web Services accounts under this
#' organization.
#' @param FunctionUrlAuthType The type of authentication that your function URL uses. Set to `AWS_IAM`
#' if you want to restrict access to authenticated users only. Set to
#' `NONE` if you want to bypass IAM authentication to create a public
#' endpoint. For more information, see [Security and auth model for Lambda
#' function
#' URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
#'
#' @keywords internal
#'
#' @rdname lambda_add_permission
lambda_add_permission <- function(FunctionName, StatementId, Action, Principal, SourceArn = NULL, SourceAccount = NULL, EventSourceToken = NULL, Qualifier = NULL, RevisionId = NULL, PrincipalOrgID = NULL, FunctionUrlAuthType = NULL) {
  op <- new_operation(
    name = "AddPermission",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$add_permission_input(FunctionName = FunctionName, StatementId = StatementId, Action = Action, Principal = Principal, SourceArn = SourceArn, SourceAccount = SourceAccount, EventSourceToken = EventSourceToken, Qualifier = Qualifier, RevisionId = RevisionId, PrincipalOrgID = PrincipalOrgID, FunctionUrlAuthType = FunctionUrlAuthType)
  output <- .lambda$add_permission_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$add_permission <- lambda_add_permission

#' Creates an alias for a Lambda function version
#'
#' @description
#' Creates an [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html) for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_create_alias/](https://www.paws-r-sdk.com/docs/lambda_create_alias/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#' @param FunctionVersion &#91;required&#93; The function version that the alias invokes.
#' @param Description A description of the alias.
#' @param RoutingConfig The [routing
#' configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing)
#' of the alias.
#'
#' @keywords internal
#'
#' @rdname lambda_create_alias
lambda_create_alias <- function(FunctionName, Name, FunctionVersion, Description = NULL, RoutingConfig = NULL) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$create_alias_input(FunctionName = FunctionName, Name = Name, FunctionVersion = FunctionVersion, Description = Description, RoutingConfig = RoutingConfig)
  output <- .lambda$create_alias_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_alias <- lambda_create_alias

#' Creates a code signing configuration
#'
#' @description
#' Creates a code signing configuration. A [code signing configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html) defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_create_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_create_code_signing_config/) for full documentation.
#'
#' @param Description Descriptive name for this code signing configuration.
#' @param AllowedPublishers &#91;required&#93; Signing profiles for this code signing configuration.
#' @param CodeSigningPolicies The code signing policies define the actions to take if the validation
#' checks fail.
#' @param Tags A list of tags to add to the code signing configuration.
#'
#' @keywords internal
#'
#' @rdname lambda_create_code_signing_config
lambda_create_code_signing_config <- function(Description = NULL, AllowedPublishers, CodeSigningPolicies = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCodeSigningConfig",
    http_method = "POST",
    http_path = "/2020-04-22/code-signing-configs/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$create_code_signing_config_input(Description = Description, AllowedPublishers = AllowedPublishers, CodeSigningPolicies = CodeSigningPolicies, Tags = Tags)
  output <- .lambda$create_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_code_signing_config <- lambda_create_code_signing_config

#' Creates a mapping between an event source and an Lambda function
#'
#' @description
#' Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and invokes the function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_create_event_source_mapping/](https://www.paws-r-sdk.com/docs/lambda_create_event_source_mapping/) for full documentation.
#'
#' @param EventSourceArn The Amazon Resource Name (ARN) of the event source.
#' 
#' -   **Amazon Kinesis** – The ARN of the data stream or a stream
#'     consumer.
#' 
#' -   **Amazon DynamoDB Streams** – The ARN of the stream.
#' 
#' -   **Amazon Simple Queue Service** – The ARN of the queue.
#' 
#' -   **Amazon Managed Streaming for Apache Kafka** – The ARN of the
#'     cluster or the ARN of the VPC connection (for [cross-account event
#'     source
#'     mappings](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc)).
#' 
#' -   **Amazon MQ** – The ARN of the broker.
#' 
#' -   **Amazon DocumentDB** – The ARN of the DocumentDB change stream.
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `MyFunction`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Version or Alias ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
#' 
#' -   **Partial ARN** – `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it's limited to 64 characters in length.
#' @param Enabled When true, the event source mapping is active. When false, Lambda pauses
#' polling and invocation.
#' 
#' Default: True
#' @param BatchSize The maximum number of records in each batch that Lambda pulls from your
#' stream or queue and sends to your function. Lambda passes all of the
#' records in the batch to the function in a single call, up to the payload
#' limit for synchronous invocation (6 MB).
#' 
#' -   **Amazon Kinesis** – Default 100. Max 10,000.
#' 
#' -   **Amazon DynamoDB Streams** – Default 100. Max 10,000.
#' 
#' -   **Amazon Simple Queue Service** – Default 10. For standard queues
#'     the max is 10,000. For FIFO queues the max is 10.
#' 
#' -   **Amazon Managed Streaming for Apache Kafka** – Default 100. Max
#'     10,000.
#' 
#' -   **Self-managed Apache Kafka** – Default 100. Max 10,000.
#' 
#' -   **Amazon MQ (ActiveMQ and RabbitMQ)** – Default 100. Max 10,000.
#' 
#' -   **DocumentDB** – Default 100. Max 10,000.
#' @param FilterCriteria An object that defines the filter criteria that determine whether Lambda
#' should process an event. For more information, see [Lambda event
#' filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
#' @param MaximumBatchingWindowInSeconds The maximum amount of time, in seconds, that Lambda spends gathering
#' records before invoking the function. You can configure
#' `MaximumBatchingWindowInSeconds` to any value from 0 seconds to 300
#' seconds in increments of seconds.
#' 
#' For Kinesis, DynamoDB, and Amazon SQS event sources, the default
#' batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka,
#' Amazon MQ, and DocumentDB event sources, the default batching window is
#' 500 ms. Note that because you can only change
#' `MaximumBatchingWindowInSeconds` in increments of seconds, you cannot
#' revert back to the 500 ms default batching window after you have changed
#' it. To restore the default batching window, you must create a new event
#' source mapping.
#' 
#' Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources,
#' when you set `BatchSize` to a value greater than 10, you must set
#' `MaximumBatchingWindowInSeconds` to at least 1.
#' @param ParallelizationFactor (Kinesis and DynamoDB Streams only) The number of batches to process
#' from each shard concurrently.
#' @param StartingPosition The position in a stream from which to start reading. Required for
#' Amazon Kinesis and Amazon DynamoDB Stream event sources. `AT_TIMESTAMP`
#' is supported only for Amazon Kinesis streams, Amazon DocumentDB, Amazon
#' MSK, and self-managed Apache Kafka.
#' @param StartingPositionTimestamp With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to
#' start reading. `StartingPositionTimestamp` cannot be in the future.
#' @param DestinationConfig (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A
#' configuration object that specifies the destination of an event after
#' Lambda processes it.
#' @param MaximumRecordAgeInSeconds (Kinesis and DynamoDB Streams only) Discard records older than the
#' specified age. The default value is infinite (-1).
#' @param BisectBatchOnFunctionError (Kinesis and DynamoDB Streams only) If the function returns an error,
#' split the batch in two and retry.
#' @param MaximumRetryAttempts (Kinesis and DynamoDB Streams only) Discard records after the specified
#' number of retries. The default value is infinite (-1). When set to
#' infinite (-1), failed records are retried until the record expires.
#' @param Tags A list of tags to apply to the event source mapping.
#' @param TumblingWindowInSeconds (Kinesis and DynamoDB Streams only) The duration in seconds of a
#' processing window for DynamoDB and Kinesis Streams event sources. A
#' value of 0 seconds indicates no tumbling window.
#' @param Topics The name of the Kafka topic.
#' @param Queues (MQ) The name of the Amazon MQ broker destination queue to consume.
#' @param SourceAccessConfigurations An array of authentication protocols or VPC components required to
#' secure your event source.
#' @param SelfManagedEventSource The self-managed Apache Kafka cluster to receive records from.
#' @param FunctionResponseTypes (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response
#' type enums applied to the event source mapping.
#' @param AmazonManagedKafkaEventSourceConfig Specific configuration settings for an Amazon Managed Streaming for
#' Apache Kafka (Amazon MSK) event source.
#' @param SelfManagedKafkaEventSourceConfig Specific configuration settings for a self-managed Apache Kafka event
#' source.
#' @param ScalingConfig (Amazon SQS only) The scaling configuration for the event source. For
#' more information, see [Configuring maximum concurrency for Amazon SQS
#' event
#' sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
#' @param DocumentDBEventSourceConfig Specific configuration settings for a DocumentDB event source.
#' @param KMSKeyArn The ARN of the Key Management Service (KMS) customer managed key that
#' Lambda uses to encrypt your function's [filter
#' criteria](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics).
#' By default, Lambda does not encrypt your filter criteria object. Specify
#' this property to encrypt data using your own customer managed key.
#' @param MetricsConfig The metrics configuration for your event source. For more information,
#' see [Event source mapping
#' metrics](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics).
#' @param ProvisionedPollerConfig (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode
#' configuration for the event source. For more information, see
#' [Provisioned
#' Mode](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode).
#'
#' @keywords internal
#'
#' @rdname lambda_create_event_source_mapping
lambda_create_event_source_mapping <- function(EventSourceArn = NULL, FunctionName, Enabled = NULL, BatchSize = NULL, FilterCriteria = NULL, MaximumBatchingWindowInSeconds = NULL, ParallelizationFactor = NULL, StartingPosition = NULL, StartingPositionTimestamp = NULL, DestinationConfig = NULL, MaximumRecordAgeInSeconds = NULL, BisectBatchOnFunctionError = NULL, MaximumRetryAttempts = NULL, Tags = NULL, TumblingWindowInSeconds = NULL, Topics = NULL, Queues = NULL, SourceAccessConfigurations = NULL, SelfManagedEventSource = NULL, FunctionResponseTypes = NULL, AmazonManagedKafkaEventSourceConfig = NULL, SelfManagedKafkaEventSourceConfig = NULL, ScalingConfig = NULL, DocumentDBEventSourceConfig = NULL, KMSKeyArn = NULL, MetricsConfig = NULL, ProvisionedPollerConfig = NULL) {
  op <- new_operation(
    name = "CreateEventSourceMapping",
    http_method = "POST",
    http_path = "/2015-03-31/event-source-mappings/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$create_event_source_mapping_input(EventSourceArn = EventSourceArn, FunctionName = FunctionName, Enabled = Enabled, BatchSize = BatchSize, FilterCriteria = FilterCriteria, MaximumBatchingWindowInSeconds = MaximumBatchingWindowInSeconds, ParallelizationFactor = ParallelizationFactor, StartingPosition = StartingPosition, StartingPositionTimestamp = StartingPositionTimestamp, DestinationConfig = DestinationConfig, MaximumRecordAgeInSeconds = MaximumRecordAgeInSeconds, BisectBatchOnFunctionError = BisectBatchOnFunctionError, MaximumRetryAttempts = MaximumRetryAttempts, Tags = Tags, TumblingWindowInSeconds = TumblingWindowInSeconds, Topics = Topics, Queues = Queues, SourceAccessConfigurations = SourceAccessConfigurations, SelfManagedEventSource = SelfManagedEventSource, FunctionResponseTypes = FunctionResponseTypes, AmazonManagedKafkaEventSourceConfig = AmazonManagedKafkaEventSourceConfig, SelfManagedKafkaEventSourceConfig = SelfManagedKafkaEventSourceConfig, ScalingConfig = ScalingConfig, DocumentDBEventSourceConfig = DocumentDBEventSourceConfig, KMSKeyArn = KMSKeyArn, MetricsConfig = MetricsConfig, ProvisionedPollerConfig = ProvisionedPollerConfig)
  output <- .lambda$create_event_source_mapping_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_event_source_mapping <- lambda_create_event_source_mapping

#' Creates a Lambda function
#'
#' @description
#' Creates a Lambda function. To create a function, you need a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-zip.html) and an [execution role](https://docs.aws.amazon.com/lambda/latest/dg/lambda-permissions.html#lambda-intro-execution-role). The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_create_function/](https://www.paws-r-sdk.com/docs/lambda_create_function/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Runtime The identifier of the function's
#' [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
#' Runtime is required if the deployment package is a .zip file archive.
#' Specifying a runtime results in an error if you're deploying a function
#' using a container image.
#' 
#' The following list includes deprecated runtimes. Lambda blocks creating
#' new functions and updating existing functions shortly after each runtime
#' is deprecated. For more information, see [Runtime use after
#' deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
#' 
#' For a list of all currently supported runtimes, see [Supported
#' runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
#' @param Role &#91;required&#93; The Amazon Resource Name (ARN) of the function's execution role.
#' @param Handler The name of the method within your code that Lambda calls to run your
#' function. Handler is required if the deployment package is a .zip file
#' archive. The format includes the file name. It can also include
#' namespaces and other qualifiers, depending on the runtime. For more
#' information, see [Lambda programming
#' model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
#' @param Code &#91;required&#93; The code for the function.
#' @param Description A description of the function.
#' @param Timeout The amount of time (in seconds) that Lambda allows a function to run
#' before stopping it. The default is 3 seconds. The maximum allowed value
#' is 900 seconds. For more information, see [Lambda execution
#' environment](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtime-environment.html).
#' @param MemorySize The amount of [memory available to the
#' function](https://docs.aws.amazon.com/lambda/latest/dg/lambda-functions.html#configuration-memory-console)
#' at runtime. Increasing the function memory also increases its CPU
#' allocation. The default value is 128 MB. The value can be any multiple
#' of 1 MB.
#' @param Publish Set to true to publish the first version of the function during
#' creation.
#' @param VpcConfig For network connectivity to Amazon Web Services resources in a VPC,
#' specify a list of security groups and subnets in the VPC. When you
#' connect a function to a VPC, it can access resources and the internet
#' only through that VPC. For more information, see [Configuring a Lambda
#' function to access resources in a
#' VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
#' @param PackageType The type of deployment package. Set to `Image` for container image and
#' set to `Zip` for .zip file archive.
#' @param DeadLetterConfig A dead-letter queue configuration that specifies the queue or topic
#' where Lambda sends asynchronous events when they fail processing. For
#' more information, see [Dead-letter
#' queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
#' @param Environment Environment variables that are accessible from function code during
#' execution.
#' @param KMSKeyArn The ARN of the Key Management Service (KMS) customer managed key that's
#' used to encrypt the following resources:
#' 
#' -   The function's [environment
#'     variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption).
#' 
#' -   The function's [Lambda
#'     SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html)
#'     snapshots.
#' 
#' -   When used with `SourceKMSKeyArn`, the unzipped version of the .zip
#'     deployment package that's used for function invocations. For more
#'     information, see [Specifying a customer managed key for
#'     Lambda](https://docs.aws.amazon.com/lambda/latest/dg/encrypt-zip-package.html#enable-zip-custom-encryption).
#' 
#' -   The optimized version of the container image that's used for
#'     function invocations. Note that this is not the same key that's used
#'     to protect your container image in the Amazon Elastic Container
#'     Registry (Amazon ECR). For more information, see [Function
#'     lifecycle](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-lifecycle).
#' 
#' If you don't provide a customer managed key, Lambda uses an [Amazon Web
#' Services owned
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk)
#' or an [Amazon Web Services managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' @param TracingConfig Set `Mode` to `Active` to sample and trace a subset of incoming requests
#' with
#' [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html)
#' to apply to the function.
#' @param Layers A list of [function
#' layers](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html)
#' to add to the function's execution environment. Specify each layer by
#' its ARN, including the version.
#' @param FileSystemConfigs Connection settings for an Amazon EFS file system.
#' @param ImageConfig Container image [configuration
#' values](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms)
#' that override the values in the container image Dockerfile.
#' @param CodeSigningConfigArn To enable code signing for this function, specify the ARN of a
#' code-signing configuration. A code-signing configuration includes a set
#' of signing profiles, which define the trusted publishers for this
#' function.
#' @param Architectures The instruction set architecture that the function supports. Enter a
#' string array with one of the valid values (arm64 or x86_64). The default
#' value is `x86_64`.
#' @param EphemeralStorage The size of the function's `/tmp` directory in MB. The default value is
#' 512, but can be any whole number between 512 and 10,240 MB. For more
#' information, see [Configuring ephemeral storage
#' (console)](https://docs.aws.amazon.com/lambda/latest/dg/lambda-functions.html#configuration-ephemeral-storage).
#' @param SnapStart The function's
#' [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html)
#' setting.
#' @param LoggingConfig The function's Amazon CloudWatch Logs configuration settings.
#'
#' @keywords internal
#'
#' @rdname lambda_create_function
lambda_create_function <- function(FunctionName, Runtime = NULL, Role, Handler = NULL, Code, Description = NULL, Timeout = NULL, MemorySize = NULL, Publish = NULL, VpcConfig = NULL, PackageType = NULL, DeadLetterConfig = NULL, Environment = NULL, KMSKeyArn = NULL, TracingConfig = NULL, Tags = NULL, Layers = NULL, FileSystemConfigs = NULL, ImageConfig = NULL, CodeSigningConfigArn = NULL, Architectures = NULL, EphemeralStorage = NULL, SnapStart = NULL, LoggingConfig = NULL) {
  op <- new_operation(
    name = "CreateFunction",
    http_method = "POST",
    http_path = "/2015-03-31/functions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$create_function_input(FunctionName = FunctionName, Runtime = Runtime, Role = Role, Handler = Handler, Code = Code, Description = Description, Timeout = Timeout, MemorySize = MemorySize, Publish = Publish, VpcConfig = VpcConfig, PackageType = PackageType, DeadLetterConfig = DeadLetterConfig, Environment = Environment, KMSKeyArn = KMSKeyArn, TracingConfig = TracingConfig, Tags = Tags, Layers = Layers, FileSystemConfigs = FileSystemConfigs, ImageConfig = ImageConfig, CodeSigningConfigArn = CodeSigningConfigArn, Architectures = Architectures, EphemeralStorage = EphemeralStorage, SnapStart = SnapStart, LoggingConfig = LoggingConfig)
  output <- .lambda$create_function_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_function <- lambda_create_function

#' Creates a Lambda function URL with the specified configuration
#' parameters
#'
#' @description
#' Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S) endpoint that you can use to invoke your function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_create_function_url_config/](https://www.paws-r-sdk.com/docs/lambda_create_function_url_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier The alias name.
#' @param AuthType &#91;required&#93; The type of authentication that your function URL uses. Set to `AWS_IAM`
#' if you want to restrict access to authenticated users only. Set to
#' `NONE` if you want to bypass IAM authentication to create a public
#' endpoint. For more information, see [Security and auth model for Lambda
#' function
#' URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
#' @param Cors The [cross-origin resource sharing
#' (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings
#' for your function URL.
#' @param InvokeMode Use one of the following options:
#' 
#' -   `BUFFERED` – This is the default option. Lambda invokes your
#'     function using the [`invoke`][lambda_invoke] API operation.
#'     Invocation results are available when the payload is complete. The
#'     maximum payload size is 6 MB.
#' 
#' -   `RESPONSE_STREAM` – Your function streams payload results as they
#'     become available. Lambda invokes your function using the
#'     [`invoke_with_response_stream`][lambda_invoke_with_response_stream]
#'     API operation. The maximum response payload size is 20 MB, however,
#'     you can [request a quota
#'     increase](https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html).
#'
#' @keywords internal
#'
#' @rdname lambda_create_function_url_config
lambda_create_function_url_config <- function(FunctionName, Qualifier = NULL, AuthType, Cors = NULL, InvokeMode = NULL) {
  op <- new_operation(
    name = "CreateFunctionUrlConfig",
    http_method = "POST",
    http_path = "/2021-10-31/functions/{FunctionName}/url",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$create_function_url_config_input(FunctionName = FunctionName, Qualifier = Qualifier, AuthType = AuthType, Cors = Cors, InvokeMode = InvokeMode)
  output <- .lambda$create_function_url_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_function_url_config <- lambda_create_function_url_config

#' Deletes a Lambda function alias
#'
#' @description
#' Deletes a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_alias/](https://www.paws-r-sdk.com/docs/lambda_delete_alias/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_alias
lambda_delete_alias <- function(FunctionName, Name) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "DELETE",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_alias_input(FunctionName = FunctionName, Name = Name)
  output <- .lambda$delete_alias_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_alias <- lambda_delete_alias

#' Deletes the code signing configuration
#'
#' @description
#' Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_delete_code_signing_config/) for full documentation.
#'
#' @param CodeSigningConfigArn &#91;required&#93; The The Amazon Resource Name (ARN) of the code signing configuration.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_code_signing_config
lambda_delete_code_signing_config <- function(CodeSigningConfigArn) {
  op <- new_operation(
    name = "DeleteCodeSigningConfig",
    http_method = "DELETE",
    http_path = "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_code_signing_config_input(CodeSigningConfigArn = CodeSigningConfigArn)
  output <- .lambda$delete_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_code_signing_config <- lambda_delete_code_signing_config

#' Deletes an event source mapping
#'
#' @description
#' Deletes an [event source mapping](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html). You can get the identifier of a mapping from the output of [`list_event_source_mappings`][lambda_list_event_source_mappings].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_event_source_mapping/](https://www.paws-r-sdk.com/docs/lambda_delete_event_source_mapping/) for full documentation.
#'
#' @param UUID &#91;required&#93; The identifier of the event source mapping.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_event_source_mapping
lambda_delete_event_source_mapping <- function(UUID) {
  op <- new_operation(
    name = "DeleteEventSourceMapping",
    http_method = "DELETE",
    http_path = "/2015-03-31/event-source-mappings/{UUID}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_event_source_mapping_input(UUID = UUID)
  output <- .lambda$delete_event_source_mapping_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_event_source_mapping <- lambda_delete_event_source_mapping

#' Deletes a Lambda function
#'
#' @description
#' Deletes a Lambda function. To delete a specific function version, use the `Qualifier` parameter. Otherwise, all versions and aliases are deleted. This doesn't require the user to have explicit permissions for [`delete_alias`][lambda_delete_alias].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_function/](https://www.paws-r-sdk.com/docs/lambda_delete_function/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function or version.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:1` (with
#'     version).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version to delete. You can't delete a version that an alias
#' references.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function
lambda_delete_function <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "DeleteFunction",
    http_method = "DELETE",
    http_path = "/2015-03-31/functions/{FunctionName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_function_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$delete_function_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function <- lambda_delete_function

#' Removes the code signing configuration from the function
#'
#' @description
#' Removes the code signing configuration from the function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_function_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_delete_function_code_signing_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function_code_signing_config
lambda_delete_function_code_signing_config <- function(FunctionName) {
  op <- new_operation(
    name = "DeleteFunctionCodeSigningConfig",
    http_method = "DELETE",
    http_path = "/2020-06-30/functions/{FunctionName}/code-signing-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_function_code_signing_config_input(FunctionName = FunctionName)
  output <- .lambda$delete_function_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function_code_signing_config <- lambda_delete_function_code_signing_config

#' Removes a concurrent execution limit from a function
#'
#' @description
#' Removes a concurrent execution limit from a function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_function_concurrency/](https://www.paws-r-sdk.com/docs/lambda_delete_function_concurrency/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function_concurrency
lambda_delete_function_concurrency <- function(FunctionName) {
  op <- new_operation(
    name = "DeleteFunctionConcurrency",
    http_method = "DELETE",
    http_path = "/2017-10-31/functions/{FunctionName}/concurrency",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_function_concurrency_input(FunctionName = FunctionName)
  output <- .lambda$delete_function_concurrency_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function_concurrency <- lambda_delete_function_concurrency

#' Deletes the configuration for asynchronous invocation for a function,
#' version, or alias
#'
#' @description
#' Deletes the configuration for asynchronous invocation for a function, version, or alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_function_event_invoke_config/](https://www.paws-r-sdk.com/docs/lambda_delete_function_event_invoke_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier A version number or alias name.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function_event_invoke_config
lambda_delete_function_event_invoke_config <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "DeleteFunctionEventInvokeConfig",
    http_method = "DELETE",
    http_path = "/2019-09-25/functions/{FunctionName}/event-invoke-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_function_event_invoke_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$delete_function_event_invoke_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function_event_invoke_config <- lambda_delete_function_event_invoke_config

#' Deletes a Lambda function URL
#'
#' @description
#' Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL results in a different URL address.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_function_url_config/](https://www.paws-r-sdk.com/docs/lambda_delete_function_url_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier The alias name.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function_url_config
lambda_delete_function_url_config <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "DeleteFunctionUrlConfig",
    http_method = "DELETE",
    http_path = "/2021-10-31/functions/{FunctionName}/url",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_function_url_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$delete_function_url_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function_url_config <- lambda_delete_function_url_config

#' Deletes a version of an Lambda layer
#'
#' @description
#' Deletes a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html). Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_layer_version/](https://www.paws-r-sdk.com/docs/lambda_delete_layer_version/) for full documentation.
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_layer_version
lambda_delete_layer_version <- function(LayerName, VersionNumber) {
  op <- new_operation(
    name = "DeleteLayerVersion",
    http_method = "DELETE",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_layer_version_input(LayerName = LayerName, VersionNumber = VersionNumber)
  output <- .lambda$delete_layer_version_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_layer_version <- lambda_delete_layer_version

#' Deletes the provisioned concurrency configuration for a function
#'
#' @description
#' Deletes the provisioned concurrency configuration for a function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_delete_provisioned_concurrency_config/](https://www.paws-r-sdk.com/docs/lambda_delete_provisioned_concurrency_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier &#91;required&#93; The version number or alias name.
#'
#' @keywords internal
#'
#' @rdname lambda_delete_provisioned_concurrency_config
lambda_delete_provisioned_concurrency_config <- function(FunctionName, Qualifier) {
  op <- new_operation(
    name = "DeleteProvisionedConcurrencyConfig",
    http_method = "DELETE",
    http_path = "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$delete_provisioned_concurrency_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$delete_provisioned_concurrency_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_provisioned_concurrency_config <- lambda_delete_provisioned_concurrency_config

#' Retrieves details about your account's limits and usage in an Amazon Web
#' Services Region
#'
#' @description
#' Retrieves details about your account's [limits](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html) and usage in an Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_account_settings/](https://www.paws-r-sdk.com/docs/lambda_get_account_settings/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lambda_get_account_settings
lambda_get_account_settings <- function() {
  op <- new_operation(
    name = "GetAccountSettings",
    http_method = "GET",
    http_path = "/2016-08-19/account-settings/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_account_settings_input()
  output <- .lambda$get_account_settings_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_account_settings <- lambda_get_account_settings

#' Returns details about a Lambda function alias
#'
#' @description
#' Returns details about a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_alias/](https://www.paws-r-sdk.com/docs/lambda_get_alias/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#'
#' @keywords internal
#'
#' @rdname lambda_get_alias
lambda_get_alias <- function(FunctionName, Name) {
  op <- new_operation(
    name = "GetAlias",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_alias_input(FunctionName = FunctionName, Name = Name)
  output <- .lambda$get_alias_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_alias <- lambda_get_alias

#' Returns information about the specified code signing configuration
#'
#' @description
#' Returns information about the specified code signing configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_get_code_signing_config/) for full documentation.
#'
#' @param CodeSigningConfigArn &#91;required&#93; The The Amazon Resource Name (ARN) of the code signing configuration.
#'
#' @keywords internal
#'
#' @rdname lambda_get_code_signing_config
lambda_get_code_signing_config <- function(CodeSigningConfigArn) {
  op <- new_operation(
    name = "GetCodeSigningConfig",
    http_method = "GET",
    http_path = "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_code_signing_config_input(CodeSigningConfigArn = CodeSigningConfigArn)
  output <- .lambda$get_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_code_signing_config <- lambda_get_code_signing_config

#' Returns details about an event source mapping
#'
#' @description
#' Returns details about an event source mapping. You can get the identifier of a mapping from the output of [`list_event_source_mappings`][lambda_list_event_source_mappings].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_event_source_mapping/](https://www.paws-r-sdk.com/docs/lambda_get_event_source_mapping/) for full documentation.
#'
#' @param UUID &#91;required&#93; The identifier of the event source mapping.
#'
#' @keywords internal
#'
#' @rdname lambda_get_event_source_mapping
lambda_get_event_source_mapping <- function(UUID) {
  op <- new_operation(
    name = "GetEventSourceMapping",
    http_method = "GET",
    http_path = "/2015-03-31/event-source-mappings/{UUID}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_event_source_mapping_input(UUID = UUID)
  output <- .lambda$get_event_source_mapping_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_event_source_mapping <- lambda_get_event_source_mapping

#' Returns information about the function or function version, with a link
#' to download the deployment package that's valid for 10 minutes
#'
#' @description
#' Returns information about the function or function version, with a link to download the deployment package that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function/](https://www.paws-r-sdk.com/docs/lambda_get_function/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version or alias to get details about a published version of
#' the function.
#'
#' @keywords internal
#'
#' @rdname lambda_get_function
lambda_get_function <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetFunction",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_function_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function <- lambda_get_function

#' Returns the code signing configuration for the specified function
#'
#' @description
#' Returns the code signing configuration for the specified function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_get_function_code_signing_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_code_signing_config
lambda_get_function_code_signing_config <- function(FunctionName) {
  op <- new_operation(
    name = "GetFunctionCodeSigningConfig",
    http_method = "GET",
    http_path = "/2020-06-30/functions/{FunctionName}/code-signing-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_code_signing_config_input(FunctionName = FunctionName)
  output <- .lambda$get_function_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_code_signing_config <- lambda_get_function_code_signing_config

#' Returns details about the reserved concurrency configuration for a
#' function
#'
#' @description
#' Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use [`put_function_concurrency`][lambda_put_function_concurrency].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function_concurrency/](https://www.paws-r-sdk.com/docs/lambda_get_function_concurrency/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_concurrency
lambda_get_function_concurrency <- function(FunctionName) {
  op <- new_operation(
    name = "GetFunctionConcurrency",
    http_method = "GET",
    http_path = "/2019-09-30/functions/{FunctionName}/concurrency",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_concurrency_input(FunctionName = FunctionName)
  output <- .lambda$get_function_concurrency_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_concurrency <- lambda_get_function_concurrency

#' Returns the version-specific settings of a Lambda function or version
#'
#' @description
#' Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use [`update_function_configuration`][lambda_update_function_configuration].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function_configuration/](https://www.paws-r-sdk.com/docs/lambda_get_function_configuration/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version or alias to get details about a published version of
#' the function.
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_configuration
lambda_get_function_configuration <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetFunctionConfiguration",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_configuration_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_function_configuration_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_configuration <- lambda_get_function_configuration

#' Retrieves the configuration for asynchronous invocation for a function,
#' version, or alias
#'
#' @description
#' Retrieves the configuration for asynchronous invocation for a function, version, or alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function_event_invoke_config/](https://www.paws-r-sdk.com/docs/lambda_get_function_event_invoke_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier A version number or alias name.
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_event_invoke_config
lambda_get_function_event_invoke_config <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetFunctionEventInvokeConfig",
    http_method = "GET",
    http_path = "/2019-09-25/functions/{FunctionName}/event-invoke-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_event_invoke_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_function_event_invoke_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_event_invoke_config <- lambda_get_function_event_invoke_config

#' Returns your function's recursive loop detection configuration
#'
#' @description
#' Returns your function's [recursive loop detection](https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html) configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function_recursion_config/](https://www.paws-r-sdk.com/docs/lambda_get_function_recursion_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_recursion_config
lambda_get_function_recursion_config <- function(FunctionName) {
  op <- new_operation(
    name = "GetFunctionRecursionConfig",
    http_method = "GET",
    http_path = "/2024-08-31/functions/{FunctionName}/recursion-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_recursion_config_input(FunctionName = FunctionName)
  output <- .lambda$get_function_recursion_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_recursion_config <- lambda_get_function_recursion_config

#' Returns details about a Lambda function URL
#'
#' @description
#' Returns details about a Lambda function URL.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_function_url_config/](https://www.paws-r-sdk.com/docs/lambda_get_function_url_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier The alias name.
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_url_config
lambda_get_function_url_config <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetFunctionUrlConfig",
    http_method = "GET",
    http_path = "/2021-10-31/functions/{FunctionName}/url",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_function_url_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_function_url_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_url_config <- lambda_get_function_url_config

#' Returns information about a version of an Lambda layer, with a link to
#' download the layer archive that's valid for 10 minutes
#'
#' @description
#' Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html), with a link to download the layer archive that's valid for 10 minutes.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_layer_version/](https://www.paws-r-sdk.com/docs/lambda_get_layer_version/) for full documentation.
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#'
#' @keywords internal
#'
#' @rdname lambda_get_layer_version
lambda_get_layer_version <- function(LayerName, VersionNumber) {
  op <- new_operation(
    name = "GetLayerVersion",
    http_method = "GET",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_layer_version_input(LayerName = LayerName, VersionNumber = VersionNumber)
  output <- .lambda$get_layer_version_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_layer_version <- lambda_get_layer_version

#' Returns information about a version of an Lambda layer, with a link to
#' download the layer archive that's valid for 10 minutes
#'
#' @description
#' Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html), with a link to download the layer archive that's valid for 10 minutes.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_layer_version_by_arn/](https://www.paws-r-sdk.com/docs/lambda_get_layer_version_by_arn/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the layer version.
#'
#' @keywords internal
#'
#' @rdname lambda_get_layer_version_by_arn
lambda_get_layer_version_by_arn <- function(Arn) {
  op <- new_operation(
    name = "GetLayerVersionByArn",
    http_method = "GET",
    http_path = "/2018-10-31/layers?find=LayerVersion",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_layer_version_by_arn_input(Arn = Arn)
  output <- .lambda$get_layer_version_by_arn_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_layer_version_by_arn <- lambda_get_layer_version_by_arn

#' Returns the permission policy for a version of an Lambda layer
#'
#' @description
#' Returns the permission policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html). For more information, see [`add_layer_version_permission`][lambda_add_layer_version_permission].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_layer_version_policy/](https://www.paws-r-sdk.com/docs/lambda_get_layer_version_policy/) for full documentation.
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#'
#' @keywords internal
#'
#' @rdname lambda_get_layer_version_policy
lambda_get_layer_version_policy <- function(LayerName, VersionNumber) {
  op <- new_operation(
    name = "GetLayerVersionPolicy",
    http_method = "GET",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_layer_version_policy_input(LayerName = LayerName, VersionNumber = VersionNumber)
  output <- .lambda$get_layer_version_policy_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_layer_version_policy <- lambda_get_layer_version_policy

#' Returns the resource-based IAM policy for a function, version, or alias
#'
#' @description
#' Returns the [resource-based IAM policy](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html) for a function, version, or alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_policy/](https://www.paws-r-sdk.com/docs/lambda_get_policy/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version or alias to get the policy for that resource.
#'
#' @keywords internal
#'
#' @rdname lambda_get_policy
lambda_get_policy <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_policy_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_policy_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_policy <- lambda_get_policy

#' Retrieves the provisioned concurrency configuration for a function's
#' alias or version
#'
#' @description
#' Retrieves the provisioned concurrency configuration for a function's alias or version.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_provisioned_concurrency_config/](https://www.paws-r-sdk.com/docs/lambda_get_provisioned_concurrency_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier &#91;required&#93; The version number or alias name.
#'
#' @keywords internal
#'
#' @rdname lambda_get_provisioned_concurrency_config
lambda_get_provisioned_concurrency_config <- function(FunctionName, Qualifier) {
  op <- new_operation(
    name = "GetProvisionedConcurrencyConfig",
    http_method = "GET",
    http_path = "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_provisioned_concurrency_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_provisioned_concurrency_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_provisioned_concurrency_config <- lambda_get_provisioned_concurrency_config

#' Retrieves the runtime management configuration for a function's version
#'
#' @description
#' Retrieves the runtime management configuration for a function's version. If the runtime update mode is **Manual**, this includes the ARN of the runtime version and the runtime update mode. If the runtime update mode is **Auto** or **Function update**, this includes the runtime update mode and `null` is returned for the ARN. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_get_runtime_management_config/](https://www.paws-r-sdk.com/docs/lambda_get_runtime_management_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version of the function. This can be `$LATEST` or a published
#' version number. If no value is specified, the configuration for the
#' `$LATEST` version is returned.
#'
#' @keywords internal
#'
#' @rdname lambda_get_runtime_management_config
lambda_get_runtime_management_config <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetRuntimeManagementConfig",
    http_method = "GET",
    http_path = "/2021-07-20/functions/{FunctionName}/runtime-management-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$get_runtime_management_config_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_runtime_management_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_runtime_management_config <- lambda_get_runtime_management_config

#' Invokes a Lambda function
#'
#' @description
#' Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously. By default, Lambda invokes your function synchronously (i.e. the`InvocationType` is `RequestResponse`). To invoke a function asynchronously, set `InvocationType` to `Event`. Lambda passes the `ClientContext` object to your function for synchronous invocations only.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_invoke/](https://www.paws-r-sdk.com/docs/lambda_invoke/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param InvocationType Choose from the following options.
#' 
#' -   `RequestResponse` (default) – Invoke the function synchronously.
#'     Keep the connection open until the function returns a response or
#'     times out. The API response includes the function response and
#'     additional data.
#' 
#' -   `Event` – Invoke the function asynchronously. Send events that fail
#'     multiple times to the function's dead-letter queue (if one is
#'     configured). The API response only includes a status code.
#' 
#' -   `DryRun` – Validate parameter values and verify that the user or
#'     role has permission to invoke the function.
#' @param LogType Set to `Tail` to include the execution log in the response. Applies to
#' synchronously invoked functions only.
#' @param ClientContext Up to 3,583 bytes of base64-encoded data about the invoking client to
#' pass to the function in the context object. Lambda passes the
#' `ClientContext` object to your function for synchronous invocations
#' only.
#' @param Payload The JSON that you want to provide to your Lambda function as input.
#' 
#' You can enter the JSON directly. For example,
#' `--payload '{ "key": "value" }'`. You can also specify a file path. For
#' example, `--payload file://payload.json`.
#' @param Qualifier Specify a version or alias to invoke a published version of the
#' function.
#'
#' @keywords internal
#'
#' @rdname lambda_invoke
lambda_invoke <- function(FunctionName, InvocationType = NULL, LogType = NULL, ClientContext = NULL, Payload = NULL, Qualifier = NULL) {
  op <- new_operation(
    name = "Invoke",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/invocations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$invoke_input(FunctionName = FunctionName, InvocationType = InvocationType, LogType = LogType, ClientContext = ClientContext, Payload = Payload, Qualifier = Qualifier)
  output <- .lambda$invoke_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$invoke <- lambda_invoke

#' For asynchronous function invocation, use Invoke
#'
#' @description
#' For asynchronous function invocation, use [`invoke`][lambda_invoke].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_invoke_async/](https://www.paws-r-sdk.com/docs/lambda_invoke_async/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param InvokeArgs &#91;required&#93; The JSON that you want to provide to your Lambda function as input.
#'
#' @keywords internal
#'
#' @rdname lambda_invoke_async
lambda_invoke_async <- function(FunctionName, InvokeArgs) {
  op <- new_operation(
    name = "InvokeAsync",
    http_method = "POST",
    http_path = "/2014-11-13/functions/{FunctionName}/invoke-async/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$invoke_async_input(FunctionName = FunctionName, InvokeArgs = InvokeArgs)
  output <- .lambda$invoke_async_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$invoke_async <- lambda_invoke_async

#' Configure your Lambda functions to stream response payloads back to
#' clients
#'
#' @description
#' Configure your Lambda functions to stream response payloads back to clients. For more information, see [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_invoke_with_response_stream/](https://www.paws-r-sdk.com/docs/lambda_invoke_with_response_stream/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param InvocationType Use one of the following options:
#' 
#' -   `RequestResponse` (default) – Invoke the function synchronously.
#'     Keep the connection open until the function returns a response or
#'     times out. The API operation response includes the function response
#'     and additional data.
#' 
#' -   `DryRun` – Validate parameter values and verify that the IAM user or
#'     role has permission to invoke the function.
#' @param LogType Set to `Tail` to include the execution log in the response. Applies to
#' synchronously invoked functions only.
#' @param ClientContext Up to 3,583 bytes of base64-encoded data about the invoking client to
#' pass to the function in the context object.
#' @param Qualifier The alias name.
#' @param Payload The JSON that you want to provide to your Lambda function as input.
#' 
#' You can enter the JSON directly. For example,
#' `--payload '{ "key": "value" }'`. You can also specify a file path. For
#' example, `--payload file://payload.json`.
#'
#' @keywords internal
#'
#' @rdname lambda_invoke_with_response_stream
lambda_invoke_with_response_stream <- function(FunctionName, InvocationType = NULL, LogType = NULL, ClientContext = NULL, Qualifier = NULL, Payload = NULL) {
  op <- new_operation(
    name = "InvokeWithResponseStream",
    http_method = "POST",
    http_path = "/2021-11-15/functions/{FunctionName}/response-streaming-invocations",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .lambda$invoke_with_response_stream_input(FunctionName = FunctionName, InvocationType = InvocationType, LogType = LogType, ClientContext = ClientContext, Qualifier = Qualifier, Payload = Payload)
  output <- .lambda$invoke_with_response_stream_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$invoke_with_response_stream <- lambda_invoke_with_response_stream

#' Returns a list of aliases for a Lambda function
#'
#' @description
#' Returns a list of [aliases](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html) for a Lambda function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_aliases/](https://www.paws-r-sdk.com/docs/lambda_list_aliases/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param FunctionVersion Specify a function version to only list aliases that invoke that
#' version.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Limit the number of aliases returned.
#'
#' @keywords internal
#'
#' @rdname lambda_list_aliases
lambda_list_aliases <- function(FunctionName, FunctionVersion = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases",
    host_prefix = "",
    paginator = list(input_token = "Marker", output_token = "NextMarker", limit_key = "MaxItems", result_key = "Aliases"),
    stream_api = FALSE
  )
  input <- .lambda$list_aliases_input(FunctionName = FunctionName, FunctionVersion = FunctionVersion, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_aliases_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_aliases <- lambda_list_aliases

#' Returns a list of code signing configurations
#'
#' @description
#' Returns a list of [code signing configurations](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html). A request returns up to 10,000 configurations per call. You can use the `MaxItems` parameter to return fewer configurations per call.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_code_signing_configs/](https://www.paws-r-sdk.com/docs/lambda_list_code_signing_configs/) for full documentation.
#'
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname lambda_list_code_signing_configs
lambda_list_code_signing_configs <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCodeSigningConfigs",
    http_method = "GET",
    http_path = "/2020-04-22/code-signing-configs/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "CodeSigningConfigs"),
    stream_api = FALSE
  )
  input <- .lambda$list_code_signing_configs_input(Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_code_signing_configs_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_code_signing_configs <- lambda_list_code_signing_configs

#' Lists event source mappings
#'
#' @description
#' Lists event source mappings. Specify an `EventSourceArn` to show only event source mappings for a single event source.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_event_source_mappings/](https://www.paws-r-sdk.com/docs/lambda_list_event_source_mappings/) for full documentation.
#'
#' @param EventSourceArn The Amazon Resource Name (ARN) of the event source.
#' 
#' -   **Amazon Kinesis** – The ARN of the data stream or a stream
#'     consumer.
#' 
#' -   **Amazon DynamoDB Streams** – The ARN of the stream.
#' 
#' -   **Amazon Simple Queue Service** – The ARN of the queue.
#' 
#' -   **Amazon Managed Streaming for Apache Kafka** – The ARN of the
#'     cluster or the ARN of the VPC connection (for [cross-account event
#'     source
#'     mappings](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc)).
#' 
#' -   **Amazon MQ** – The ARN of the broker.
#' 
#' -   **Amazon DocumentDB** – The ARN of the DocumentDB change stream.
#' @param FunctionName The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `MyFunction`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Version or Alias ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
#' 
#' -   **Partial ARN** – `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it's limited to 64 characters in length.
#' @param Marker A pagination token returned by a previous call.
#' @param MaxItems The maximum number of event source mappings to return. Note that
#' ListEventSourceMappings returns a maximum of 100 items in each response,
#' even if you set the number higher.
#'
#' @keywords internal
#'
#' @rdname lambda_list_event_source_mappings
lambda_list_event_source_mappings <- function(EventSourceArn = NULL, FunctionName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListEventSourceMappings",
    http_method = "GET",
    http_path = "/2015-03-31/event-source-mappings/",
    host_prefix = "",
    paginator = list(input_token = "Marker", output_token = "NextMarker", limit_key = "MaxItems", result_key = "EventSourceMappings"),
    stream_api = FALSE
  )
  input <- .lambda$list_event_source_mappings_input(EventSourceArn = EventSourceArn, FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_event_source_mappings_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_event_source_mappings <- lambda_list_event_source_mappings

#' Retrieves a list of configurations for asynchronous invocation for a
#' function
#'
#' @description
#' Retrieves a list of configurations for asynchronous invocation for a function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_function_event_invoke_configs/](https://www.paws-r-sdk.com/docs/lambda_list_function_event_invoke_configs/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems The maximum number of configurations to return.
#'
#' @keywords internal
#'
#' @rdname lambda_list_function_event_invoke_configs
lambda_list_function_event_invoke_configs <- function(FunctionName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFunctionEventInvokeConfigs",
    http_method = "GET",
    http_path = "/2019-09-25/functions/{FunctionName}/event-invoke-config/list",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "FunctionEventInvokeConfigs"),
    stream_api = FALSE
  )
  input <- .lambda$list_function_event_invoke_configs_input(FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_function_event_invoke_configs_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_function_event_invoke_configs <- lambda_list_function_event_invoke_configs

#' Returns a list of Lambda function URLs for the specified function
#'
#' @description
#' Returns a list of Lambda function URLs for the specified function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_function_url_configs/](https://www.paws-r-sdk.com/docs/lambda_list_function_url_configs/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems The maximum number of function URLs to return in the response. Note that
#' [`list_function_url_configs`][lambda_list_function_url_configs] returns
#' a maximum of 50 items in each response, even if you set the number
#' higher.
#'
#' @keywords internal
#'
#' @rdname lambda_list_function_url_configs
lambda_list_function_url_configs <- function(FunctionName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFunctionUrlConfigs",
    http_method = "GET",
    http_path = "/2021-10-31/functions/{FunctionName}/urls",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "FunctionUrlConfigs"),
    stream_api = FALSE
  )
  input <- .lambda$list_function_url_configs_input(FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_function_url_configs_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_function_url_configs <- lambda_list_function_url_configs

#' Returns a list of Lambda functions, with the version-specific
#' configuration of each
#'
#' @description
#' Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_functions/](https://www.paws-r-sdk.com/docs/lambda_list_functions/) for full documentation.
#'
#' @param MasterRegion For Lambda@@Edge functions, the Amazon Web Services Region of the master
#' function. For example, `us-east-1` filters the list of functions to
#' include only Lambda@@Edge functions replicated from a master function in
#' US East (N. Virginia). If specified, you must set `FunctionVersion` to
#' `ALL`.
#' @param FunctionVersion Set to `ALL` to include entries for all published versions of each
#' function.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems The maximum number of functions to return in the response. Note that
#' [`list_functions`][lambda_list_functions] returns a maximum of 50 items
#' in each response, even if you set the number higher.
#'
#' @keywords internal
#'
#' @rdname lambda_list_functions
lambda_list_functions <- function(MasterRegion = NULL, FunctionVersion = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFunctions",
    http_method = "GET",
    http_path = "/2015-03-31/functions/",
    host_prefix = "",
    paginator = list(input_token = "Marker", output_token = "NextMarker", limit_key = "MaxItems", result_key = "Functions"),
    stream_api = FALSE
  )
  input <- .lambda$list_functions_input(MasterRegion = MasterRegion, FunctionVersion = FunctionVersion, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_functions_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_functions <- lambda_list_functions

#' List the functions that use the specified code signing configuration
#'
#' @description
#' List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_functions_by_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_list_functions_by_code_signing_config/) for full documentation.
#'
#' @param CodeSigningConfigArn &#91;required&#93; The The Amazon Resource Name (ARN) of the code signing configuration.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname lambda_list_functions_by_code_signing_config
lambda_list_functions_by_code_signing_config <- function(CodeSigningConfigArn, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFunctionsByCodeSigningConfig",
    http_method = "GET",
    http_path = "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}/functions",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "FunctionArns"),
    stream_api = FALSE
  )
  input <- .lambda$list_functions_by_code_signing_config_input(CodeSigningConfigArn = CodeSigningConfigArn, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_functions_by_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_functions_by_code_signing_config <- lambda_list_functions_by_code_signing_config

#' Lists the versions of an Lambda layer
#'
#' @description
#' Lists the versions of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html). Versions that have been deleted aren't listed. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_layer_versions/](https://www.paws-r-sdk.com/docs/lambda_list_layer_versions/) for full documentation.
#'
#' @param CompatibleRuntime A runtime identifier.
#' 
#' The following list includes deprecated runtimes. For more information,
#' see [Runtime use after
#' deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
#' 
#' For a list of all currently supported runtimes, see [Supported
#' runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param Marker A pagination token returned by a previous call.
#' @param MaxItems The maximum number of versions to return.
#' @param CompatibleArchitecture The compatible [instruction set
#' architecture](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
#'
#' @keywords internal
#'
#' @rdname lambda_list_layer_versions
lambda_list_layer_versions <- function(CompatibleRuntime = NULL, LayerName, Marker = NULL, MaxItems = NULL, CompatibleArchitecture = NULL) {
  op <- new_operation(
    name = "ListLayerVersions",
    http_method = "GET",
    http_path = "/2018-10-31/layers/{LayerName}/versions",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "LayerVersions"),
    stream_api = FALSE
  )
  input <- .lambda$list_layer_versions_input(CompatibleRuntime = CompatibleRuntime, LayerName = LayerName, Marker = Marker, MaxItems = MaxItems, CompatibleArchitecture = CompatibleArchitecture)
  output <- .lambda$list_layer_versions_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_layer_versions <- lambda_list_layer_versions

#' Lists Lambda layers and shows information about the latest version of
#' each
#'
#' @description
#' Lists [Lambda layers](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html) and shows information about the latest version of each. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layers that are compatible with that [instruction set architecture](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_layers/](https://www.paws-r-sdk.com/docs/lambda_list_layers/) for full documentation.
#'
#' @param CompatibleRuntime A runtime identifier.
#' 
#' The following list includes deprecated runtimes. For more information,
#' see [Runtime use after
#' deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
#' 
#' For a list of all currently supported runtimes, see [Supported
#' runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
#' @param Marker A pagination token returned by a previous call.
#' @param MaxItems The maximum number of layers to return.
#' @param CompatibleArchitecture The compatible [instruction set
#' architecture](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
#'
#' @keywords internal
#'
#' @rdname lambda_list_layers
lambda_list_layers <- function(CompatibleRuntime = NULL, Marker = NULL, MaxItems = NULL, CompatibleArchitecture = NULL) {
  op <- new_operation(
    name = "ListLayers",
    http_method = "GET",
    http_path = "/2018-10-31/layers",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "Layers"),
    stream_api = FALSE
  )
  input <- .lambda$list_layers_input(CompatibleRuntime = CompatibleRuntime, Marker = Marker, MaxItems = MaxItems, CompatibleArchitecture = CompatibleArchitecture)
  output <- .lambda$list_layers_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_layers <- lambda_list_layers

#' Retrieves a list of provisioned concurrency configurations for a
#' function
#'
#' @description
#' Retrieves a list of provisioned concurrency configurations for a function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_provisioned_concurrency_configs/](https://www.paws-r-sdk.com/docs/lambda_list_provisioned_concurrency_configs/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Specify a number to limit the number of configurations returned.
#'
#' @keywords internal
#'
#' @rdname lambda_list_provisioned_concurrency_configs
lambda_list_provisioned_concurrency_configs <- function(FunctionName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListProvisionedConcurrencyConfigs",
    http_method = "GET",
    http_path = "/2019-09-30/functions/{FunctionName}/provisioned-concurrency?List=ALL",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "ProvisionedConcurrencyConfigs"),
    stream_api = FALSE
  )
  input <- .lambda$list_provisioned_concurrency_configs_input(FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_provisioned_concurrency_configs_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_provisioned_concurrency_configs <- lambda_list_provisioned_concurrency_configs

#' Returns a function, event source mapping, or code signing
#' configuration's tags
#'
#' @description
#' Returns a function, event source mapping, or code signing configuration's [tags](https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html). You can also view function tags with [`get_function`][lambda_get_function].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_tags/](https://www.paws-r-sdk.com/docs/lambda_list_tags/) for full documentation.
#'
#' @param Resource &#91;required&#93; The resource's Amazon Resource Name (ARN). Note: Lambda does not support
#' adding tags to function aliases or versions.
#'
#' @keywords internal
#'
#' @rdname lambda_list_tags
lambda_list_tags <- function(Resource) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/2017-03-31/tags/{ARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$list_tags_input(Resource = Resource)
  output <- .lambda$list_tags_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_tags <- lambda_list_tags

#' Returns a list of versions, with the version-specific configuration of
#' each
#'
#' @description
#' Returns a list of [versions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html), with the version-specific configuration of each. Lambda returns up to 50 versions per call.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_list_versions_by_function/](https://www.paws-r-sdk.com/docs/lambda_list_versions_by_function/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Marker Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems The maximum number of versions to return. Note that
#' [`list_versions_by_function`][lambda_list_versions_by_function] returns
#' a maximum of 50 items in each response, even if you set the number
#' higher.
#'
#' @keywords internal
#'
#' @rdname lambda_list_versions_by_function
lambda_list_versions_by_function <- function(FunctionName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListVersionsByFunction",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/versions",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "NextMarker", result_key = "Versions"),
    stream_api = FALSE
  )
  input <- .lambda$list_versions_by_function_input(FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_versions_by_function_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_versions_by_function <- lambda_list_versions_by_function

#' Creates an Lambda layer from a ZIP archive
#'
#' @description
#' Creates an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html) from a ZIP archive. Each time you call [`publish_layer_version`][lambda_publish_layer_version] with the same layer name, a new version is created.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_publish_layer_version/](https://www.paws-r-sdk.com/docs/lambda_publish_layer_version/) for full documentation.
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param Description The description of the version.
#' @param Content &#91;required&#93; The function layer archive.
#' @param CompatibleRuntimes A list of compatible [function
#' runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
#' Used for filtering with [`list_layers`][lambda_list_layers] and
#' [`list_layer_versions`][lambda_list_layer_versions].
#' 
#' The following list includes deprecated runtimes. For more information,
#' see [Runtime deprecation
#' policy](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy).
#' @param LicenseInfo The layer's software license. It can be any of the following:
#' 
#' -   An [SPDX license identifier](https://spdx.org/licenses/). For
#'     example, `MIT`.
#' 
#' -   The URL of a license hosted on the internet. For example,
#'     `https://opensource.org/licenses/MIT`.
#' 
#' -   The full text of the license.
#' @param CompatibleArchitectures A list of compatible [instruction set
#' architectures](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
#'
#' @keywords internal
#'
#' @rdname lambda_publish_layer_version
lambda_publish_layer_version <- function(LayerName, Description = NULL, Content, CompatibleRuntimes = NULL, LicenseInfo = NULL, CompatibleArchitectures = NULL) {
  op <- new_operation(
    name = "PublishLayerVersion",
    http_method = "POST",
    http_path = "/2018-10-31/layers/{LayerName}/versions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$publish_layer_version_input(LayerName = LayerName, Description = Description, Content = Content, CompatibleRuntimes = CompatibleRuntimes, LicenseInfo = LicenseInfo, CompatibleArchitectures = CompatibleArchitectures)
  output <- .lambda$publish_layer_version_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$publish_layer_version <- lambda_publish_layer_version

#' Creates a version from the current code and configuration of a function
#'
#' @description
#' Creates a [version](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html) from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn't change.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_publish_version/](https://www.paws-r-sdk.com/docs/lambda_publish_version/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param CodeSha256 Only publish a version if the hash value matches the value that's
#' specified. Use this option to avoid publishing a version if the function
#' code has changed since you last updated it. You can get the hash for the
#' version that you uploaded from the output of
#' [`update_function_code`][lambda_update_function_code].
#' @param Description A description for the version to override the description in the
#' function configuration.
#' @param RevisionId Only update the function if the revision ID matches the ID that's
#' specified. Use this option to avoid publishing a version if the function
#' configuration has changed since you last updated it.
#'
#' @keywords internal
#'
#' @rdname lambda_publish_version
lambda_publish_version <- function(FunctionName, CodeSha256 = NULL, Description = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "PublishVersion",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/versions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$publish_version_input(FunctionName = FunctionName, CodeSha256 = CodeSha256, Description = Description, RevisionId = RevisionId)
  output <- .lambda$publish_version_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$publish_version <- lambda_publish_version

#' Update the code signing configuration for the function
#'
#' @description
#' Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_put_function_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_put_function_code_signing_config/) for full documentation.
#'
#' @param CodeSigningConfigArn &#91;required&#93; The The Amazon Resource Name (ARN) of the code signing configuration.
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#'
#' @keywords internal
#'
#' @rdname lambda_put_function_code_signing_config
lambda_put_function_code_signing_config <- function(CodeSigningConfigArn, FunctionName) {
  op <- new_operation(
    name = "PutFunctionCodeSigningConfig",
    http_method = "PUT",
    http_path = "/2020-06-30/functions/{FunctionName}/code-signing-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$put_function_code_signing_config_input(CodeSigningConfigArn = CodeSigningConfigArn, FunctionName = FunctionName)
  output <- .lambda$put_function_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_function_code_signing_config <- lambda_put_function_code_signing_config

#' Sets the maximum number of simultaneous executions for a function, and
#' reserves capacity for that concurrency level
#'
#' @description
#' Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_put_function_concurrency/](https://www.paws-r-sdk.com/docs/lambda_put_function_concurrency/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param ReservedConcurrentExecutions &#91;required&#93; The number of simultaneous executions to reserve for the function.
#'
#' @keywords internal
#'
#' @rdname lambda_put_function_concurrency
lambda_put_function_concurrency <- function(FunctionName, ReservedConcurrentExecutions) {
  op <- new_operation(
    name = "PutFunctionConcurrency",
    http_method = "PUT",
    http_path = "/2017-10-31/functions/{FunctionName}/concurrency",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$put_function_concurrency_input(FunctionName = FunctionName, ReservedConcurrentExecutions = ReservedConcurrentExecutions)
  output <- .lambda$put_function_concurrency_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_function_concurrency <- lambda_put_function_concurrency

#' Configures options for asynchronous invocation on a function, version,
#' or alias
#'
#' @description
#' Configures options for [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html) on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use [`update_function_event_invoke_config`][lambda_update_function_event_invoke_config].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_put_function_event_invoke_config/](https://www.paws-r-sdk.com/docs/lambda_put_function_event_invoke_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier A version number or alias name.
#' @param MaximumRetryAttempts The maximum number of times to retry when the function returns an error.
#' @param MaximumEventAgeInSeconds The maximum age of a request that Lambda sends to a function for
#' processing.
#' @param DestinationConfig A destination for events after they have been sent to a function for
#' processing.
#' 
#' **Destinations**
#' 
#' -   **Function** - The Amazon Resource Name (ARN) of a Lambda function.
#' 
#' -   **Queue** - The ARN of a standard SQS queue.
#' 
#' -   **Bucket** - The ARN of an Amazon S3 bucket.
#' 
#' -   **Topic** - The ARN of a standard SNS topic.
#' 
#' -   **Event Bus** - The ARN of an Amazon EventBridge event bus.
#' 
#' S3 buckets are supported only for on-failure destinations. To retain
#' records of successful invocations, use another destination type.
#'
#' @keywords internal
#'
#' @rdname lambda_put_function_event_invoke_config
lambda_put_function_event_invoke_config <- function(FunctionName, Qualifier = NULL, MaximumRetryAttempts = NULL, MaximumEventAgeInSeconds = NULL, DestinationConfig = NULL) {
  op <- new_operation(
    name = "PutFunctionEventInvokeConfig",
    http_method = "PUT",
    http_path = "/2019-09-25/functions/{FunctionName}/event-invoke-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$put_function_event_invoke_config_input(FunctionName = FunctionName, Qualifier = Qualifier, MaximumRetryAttempts = MaximumRetryAttempts, MaximumEventAgeInSeconds = MaximumEventAgeInSeconds, DestinationConfig = DestinationConfig)
  output <- .lambda$put_function_event_invoke_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_function_event_invoke_config <- lambda_put_function_event_invoke_config

#' Sets your function's recursive loop detection configuration
#'
#' @description
#' Sets your function's [recursive loop detection](https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html) configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_put_function_recursion_config/](https://www.paws-r-sdk.com/docs/lambda_put_function_recursion_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param RecursiveLoop &#91;required&#93; If you set your function's recursive loop detection configuration to
#' `Allow`, Lambda doesn't take any action when it detects your function
#' being invoked as part of a recursive loop. We recommend that you only
#' use this setting if your design intentionally uses a Lambda function to
#' write data back to the same Amazon Web Services resource that invokes
#' it.
#' 
#' If you set your function's recursive loop detection configuration to
#' `Terminate`, Lambda stops your function being invoked and notifies you
#' when it detects your function being invoked as part of a recursive loop.
#' 
#' By default, Lambda sets your function's configuration to `Terminate`.
#' 
#' If your design intentionally uses a Lambda function to write data back
#' to the same Amazon Web Services resource that invokes the function, then
#' use caution and implement suitable guard rails to prevent unexpected
#' charges being billed to your Amazon Web Services account. To learn more
#' about best practices for using recursive invocation patterns, see
#' [Recursive patterns that cause run-away Lambda
#' functions](https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway)
#' in Serverless Land.
#'
#' @keywords internal
#'
#' @rdname lambda_put_function_recursion_config
lambda_put_function_recursion_config <- function(FunctionName, RecursiveLoop) {
  op <- new_operation(
    name = "PutFunctionRecursionConfig",
    http_method = "PUT",
    http_path = "/2024-08-31/functions/{FunctionName}/recursion-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$put_function_recursion_config_input(FunctionName = FunctionName, RecursiveLoop = RecursiveLoop)
  output <- .lambda$put_function_recursion_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_function_recursion_config <- lambda_put_function_recursion_config

#' Adds a provisioned concurrency configuration to a function's alias or
#' version
#'
#' @description
#' Adds a provisioned concurrency configuration to a function's alias or version.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_put_provisioned_concurrency_config/](https://www.paws-r-sdk.com/docs/lambda_put_provisioned_concurrency_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier &#91;required&#93; The version number or alias name.
#' @param ProvisionedConcurrentExecutions &#91;required&#93; The amount of provisioned concurrency to allocate for the version or
#' alias.
#'
#' @keywords internal
#'
#' @rdname lambda_put_provisioned_concurrency_config
lambda_put_provisioned_concurrency_config <- function(FunctionName, Qualifier, ProvisionedConcurrentExecutions) {
  op <- new_operation(
    name = "PutProvisionedConcurrencyConfig",
    http_method = "PUT",
    http_path = "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$put_provisioned_concurrency_config_input(FunctionName = FunctionName, Qualifier = Qualifier, ProvisionedConcurrentExecutions = ProvisionedConcurrentExecutions)
  output <- .lambda$put_provisioned_concurrency_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_provisioned_concurrency_config <- lambda_put_provisioned_concurrency_config

#' Sets the runtime management configuration for a function's version
#'
#' @description
#' Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_put_runtime_management_config/](https://www.paws-r-sdk.com/docs/lambda_put_runtime_management_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version of the function. This can be `$LATEST` or a published
#' version number. If no value is specified, the configuration for the
#' `$LATEST` version is returned.
#' @param UpdateRuntimeOn &#91;required&#93; Specify the runtime update mode.
#' 
#' -   **Auto (default)** - Automatically update to the most recent and
#'     secure runtime version using a [Two-phase runtime version
#'     rollout](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase).
#'     This is the best choice for most customers to ensure they always
#'     benefit from runtime updates.
#' 
#' -   **Function update** - Lambda updates the runtime of your function to
#'     the most recent and secure runtime version when you update your
#'     function. This approach synchronizes runtime updates with function
#'     deployments, giving you control over when runtime updates are
#'     applied and allowing you to detect and mitigate rare runtime update
#'     incompatibilities early. When using this setting, you need to
#'     regularly update your functions to keep their runtime up-to-date.
#' 
#' -   **Manual** - You specify a runtime version in your function
#'     configuration. The function will use this runtime version
#'     indefinitely. In the rare case where a new runtime version is
#'     incompatible with an existing function, this allows you to roll back
#'     your function to an earlier runtime version. For more information,
#'     see [Roll back a runtime
#'     version](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback).
#' @param RuntimeVersionArn The ARN of the runtime version you want the function to use.
#' 
#' This is only required if you're using the **Manual** runtime update
#' mode.
#'
#' @keywords internal
#'
#' @rdname lambda_put_runtime_management_config
lambda_put_runtime_management_config <- function(FunctionName, Qualifier = NULL, UpdateRuntimeOn, RuntimeVersionArn = NULL) {
  op <- new_operation(
    name = "PutRuntimeManagementConfig",
    http_method = "PUT",
    http_path = "/2021-07-20/functions/{FunctionName}/runtime-management-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$put_runtime_management_config_input(FunctionName = FunctionName, Qualifier = Qualifier, UpdateRuntimeOn = UpdateRuntimeOn, RuntimeVersionArn = RuntimeVersionArn)
  output <- .lambda$put_runtime_management_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_runtime_management_config <- lambda_put_runtime_management_config

#' Removes a statement from the permissions policy for a version of an
#' Lambda layer
#'
#' @description
#' Removes a statement from the permissions policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html). For more information, see [`add_layer_version_permission`][lambda_add_layer_version_permission].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_remove_layer_version_permission/](https://www.paws-r-sdk.com/docs/lambda_remove_layer_version_permission/) for full documentation.
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#' @param StatementId &#91;required&#93; The identifier that was specified when the statement was added.
#' @param RevisionId Only update the policy if the revision ID matches the ID specified. Use
#' this option to avoid modifying a policy that has changed since you last
#' read it.
#'
#' @keywords internal
#'
#' @rdname lambda_remove_layer_version_permission
lambda_remove_layer_version_permission <- function(LayerName, VersionNumber, StatementId, RevisionId = NULL) {
  op <- new_operation(
    name = "RemoveLayerVersionPermission",
    http_method = "DELETE",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy/{StatementId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$remove_layer_version_permission_input(LayerName = LayerName, VersionNumber = VersionNumber, StatementId = StatementId, RevisionId = RevisionId)
  output <- .lambda$remove_layer_version_permission_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$remove_layer_version_permission <- lambda_remove_layer_version_permission

#' Revokes function-use permission from an Amazon Web Services service or
#' another Amazon Web Services account
#'
#' @description
#' Revokes function-use permission from an Amazon Web Services service or another Amazon Web Services account. You can get the ID of the statement from the output of [`get_policy`][lambda_get_policy].
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_remove_permission/](https://www.paws-r-sdk.com/docs/lambda_remove_permission/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param StatementId &#91;required&#93; Statement ID of the permission to remove.
#' @param Qualifier Specify a version or alias to remove permissions from a published
#' version of the function.
#' @param RevisionId Update the policy only if the revision ID matches the ID that's
#' specified. Use this option to avoid modifying a policy that has changed
#' since you last read it.
#'
#' @keywords internal
#'
#' @rdname lambda_remove_permission
lambda_remove_permission <- function(FunctionName, StatementId, Qualifier = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "DELETE",
    http_path = "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$remove_permission_input(FunctionName = FunctionName, StatementId = StatementId, Qualifier = Qualifier, RevisionId = RevisionId)
  output <- .lambda$remove_permission_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$remove_permission <- lambda_remove_permission

#' Adds tags to a function, event source mapping, or code signing
#' configuration
#'
#' @description
#' Adds [tags](https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html) to a function, event source mapping, or code signing configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_tag_resource/](https://www.paws-r-sdk.com/docs/lambda_tag_resource/) for full documentation.
#'
#' @param Resource &#91;required&#93; The resource's Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; A list of tags to apply to the resource.
#'
#' @keywords internal
#'
#' @rdname lambda_tag_resource
lambda_tag_resource <- function(Resource, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2017-03-31/tags/{ARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$tag_resource_input(Resource = Resource, Tags = Tags)
  output <- .lambda$tag_resource_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$tag_resource <- lambda_tag_resource

#' Removes tags from a function, event source mapping, or code signing
#' configuration
#'
#' @description
#' Removes [tags](https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html) from a function, event source mapping, or code signing configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_untag_resource/](https://www.paws-r-sdk.com/docs/lambda_untag_resource/) for full documentation.
#'
#' @param Resource &#91;required&#93; The resource's Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; A list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname lambda_untag_resource
lambda_untag_resource <- function(Resource, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/2017-03-31/tags/{ARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$untag_resource_input(Resource = Resource, TagKeys = TagKeys)
  output <- .lambda$untag_resource_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$untag_resource <- lambda_untag_resource

#' Updates the configuration of a Lambda function alias
#'
#' @description
#' Updates the configuration of a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_alias/](https://www.paws-r-sdk.com/docs/lambda_update_alias/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#' @param FunctionVersion The function version that the alias invokes.
#' @param Description A description of the alias.
#' @param RoutingConfig The [routing
#' configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing)
#' of the alias.
#' @param RevisionId Only update the alias if the revision ID matches the ID that's
#' specified. Use this option to avoid modifying an alias that has changed
#' since you last read it.
#'
#' @keywords internal
#'
#' @rdname lambda_update_alias
lambda_update_alias <- function(FunctionName, Name, FunctionVersion = NULL, Description = NULL, RoutingConfig = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "UpdateAlias",
    http_method = "PUT",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_alias_input(FunctionName = FunctionName, Name = Name, FunctionVersion = FunctionVersion, Description = Description, RoutingConfig = RoutingConfig, RevisionId = RevisionId)
  output <- .lambda$update_alias_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_alias <- lambda_update_alias

#' Update the code signing configuration
#'
#' @description
#' Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_code_signing_config/](https://www.paws-r-sdk.com/docs/lambda_update_code_signing_config/) for full documentation.
#'
#' @param CodeSigningConfigArn &#91;required&#93; The The Amazon Resource Name (ARN) of the code signing configuration.
#' @param Description Descriptive name for this code signing configuration.
#' @param AllowedPublishers Signing profiles for this code signing configuration.
#' @param CodeSigningPolicies The code signing policy.
#'
#' @keywords internal
#'
#' @rdname lambda_update_code_signing_config
lambda_update_code_signing_config <- function(CodeSigningConfigArn, Description = NULL, AllowedPublishers = NULL, CodeSigningPolicies = NULL) {
  op <- new_operation(
    name = "UpdateCodeSigningConfig",
    http_method = "PUT",
    http_path = "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_code_signing_config_input(CodeSigningConfigArn = CodeSigningConfigArn, Description = Description, AllowedPublishers = AllowedPublishers, CodeSigningPolicies = CodeSigningPolicies)
  output <- .lambda$update_code_signing_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_code_signing_config <- lambda_update_code_signing_config

#' Updates an event source mapping
#'
#' @description
#' Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_event_source_mapping/](https://www.paws-r-sdk.com/docs/lambda_update_event_source_mapping/) for full documentation.
#'
#' @param UUID &#91;required&#93; The identifier of the event source mapping.
#' @param FunctionName The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `MyFunction`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Version or Alias ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
#' 
#' -   **Partial ARN** – `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it's limited to 64 characters in length.
#' @param Enabled When true, the event source mapping is active. When false, Lambda pauses
#' polling and invocation.
#' 
#' Default: True
#' @param BatchSize The maximum number of records in each batch that Lambda pulls from your
#' stream or queue and sends to your function. Lambda passes all of the
#' records in the batch to the function in a single call, up to the payload
#' limit for synchronous invocation (6 MB).
#' 
#' -   **Amazon Kinesis** – Default 100. Max 10,000.
#' 
#' -   **Amazon DynamoDB Streams** – Default 100. Max 10,000.
#' 
#' -   **Amazon Simple Queue Service** – Default 10. For standard queues
#'     the max is 10,000. For FIFO queues the max is 10.
#' 
#' -   **Amazon Managed Streaming for Apache Kafka** – Default 100. Max
#'     10,000.
#' 
#' -   **Self-managed Apache Kafka** – Default 100. Max 10,000.
#' 
#' -   **Amazon MQ (ActiveMQ and RabbitMQ)** – Default 100. Max 10,000.
#' 
#' -   **DocumentDB** – Default 100. Max 10,000.
#' @param FilterCriteria An object that defines the filter criteria that determine whether Lambda
#' should process an event. For more information, see [Lambda event
#' filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
#' @param MaximumBatchingWindowInSeconds The maximum amount of time, in seconds, that Lambda spends gathering
#' records before invoking the function. You can configure
#' `MaximumBatchingWindowInSeconds` to any value from 0 seconds to 300
#' seconds in increments of seconds.
#' 
#' For Kinesis, DynamoDB, and Amazon SQS event sources, the default
#' batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka,
#' Amazon MQ, and DocumentDB event sources, the default batching window is
#' 500 ms. Note that because you can only change
#' `MaximumBatchingWindowInSeconds` in increments of seconds, you cannot
#' revert back to the 500 ms default batching window after you have changed
#' it. To restore the default batching window, you must create a new event
#' source mapping.
#' 
#' Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources,
#' when you set `BatchSize` to a value greater than 10, you must set
#' `MaximumBatchingWindowInSeconds` to at least 1.
#' @param DestinationConfig (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A
#' configuration object that specifies the destination of an event after
#' Lambda processes it.
#' @param MaximumRecordAgeInSeconds (Kinesis and DynamoDB Streams only) Discard records older than the
#' specified age. The default value is infinite (-1).
#' @param BisectBatchOnFunctionError (Kinesis and DynamoDB Streams only) If the function returns an error,
#' split the batch in two and retry.
#' @param MaximumRetryAttempts (Kinesis and DynamoDB Streams only) Discard records after the specified
#' number of retries. The default value is infinite (-1). When set to
#' infinite (-1), failed records are retried until the record expires.
#' @param ParallelizationFactor (Kinesis and DynamoDB Streams only) The number of batches to process
#' from each shard concurrently.
#' @param SourceAccessConfigurations An array of authentication protocols or VPC components required to
#' secure your event source.
#' @param TumblingWindowInSeconds (Kinesis and DynamoDB Streams only) The duration in seconds of a
#' processing window for DynamoDB and Kinesis Streams event sources. A
#' value of 0 seconds indicates no tumbling window.
#' @param FunctionResponseTypes (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response
#' type enums applied to the event source mapping.
#' @param ScalingConfig (Amazon SQS only) The scaling configuration for the event source. For
#' more information, see [Configuring maximum concurrency for Amazon SQS
#' event
#' sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
#' @param DocumentDBEventSourceConfig Specific configuration settings for a DocumentDB event source.
#' @param KMSKeyArn The ARN of the Key Management Service (KMS) customer managed key that
#' Lambda uses to encrypt your function's [filter
#' criteria](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics).
#' By default, Lambda does not encrypt your filter criteria object. Specify
#' this property to encrypt data using your own customer managed key.
#' @param MetricsConfig The metrics configuration for your event source. For more information,
#' see [Event source mapping
#' metrics](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics).
#' @param ProvisionedPollerConfig (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode
#' configuration for the event source. For more information, see
#' [Provisioned
#' Mode](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode).
#'
#' @keywords internal
#'
#' @rdname lambda_update_event_source_mapping
lambda_update_event_source_mapping <- function(UUID, FunctionName = NULL, Enabled = NULL, BatchSize = NULL, FilterCriteria = NULL, MaximumBatchingWindowInSeconds = NULL, DestinationConfig = NULL, MaximumRecordAgeInSeconds = NULL, BisectBatchOnFunctionError = NULL, MaximumRetryAttempts = NULL, ParallelizationFactor = NULL, SourceAccessConfigurations = NULL, TumblingWindowInSeconds = NULL, FunctionResponseTypes = NULL, ScalingConfig = NULL, DocumentDBEventSourceConfig = NULL, KMSKeyArn = NULL, MetricsConfig = NULL, ProvisionedPollerConfig = NULL) {
  op <- new_operation(
    name = "UpdateEventSourceMapping",
    http_method = "PUT",
    http_path = "/2015-03-31/event-source-mappings/{UUID}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_event_source_mapping_input(UUID = UUID, FunctionName = FunctionName, Enabled = Enabled, BatchSize = BatchSize, FilterCriteria = FilterCriteria, MaximumBatchingWindowInSeconds = MaximumBatchingWindowInSeconds, DestinationConfig = DestinationConfig, MaximumRecordAgeInSeconds = MaximumRecordAgeInSeconds, BisectBatchOnFunctionError = BisectBatchOnFunctionError, MaximumRetryAttempts = MaximumRetryAttempts, ParallelizationFactor = ParallelizationFactor, SourceAccessConfigurations = SourceAccessConfigurations, TumblingWindowInSeconds = TumblingWindowInSeconds, FunctionResponseTypes = FunctionResponseTypes, ScalingConfig = ScalingConfig, DocumentDBEventSourceConfig = DocumentDBEventSourceConfig, KMSKeyArn = KMSKeyArn, MetricsConfig = MetricsConfig, ProvisionedPollerConfig = ProvisionedPollerConfig)
  output <- .lambda$update_event_source_mapping_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_event_source_mapping <- lambda_update_event_source_mapping

#' Updates a Lambda function's code
#'
#' @description
#' Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see [Configuring code signing for Lambda](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_function_code/](https://www.paws-r-sdk.com/docs/lambda_update_function_code/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param ZipFile The base64-encoded contents of the deployment package. Amazon Web
#' Services SDK and CLI clients handle the encoding for you. Use only with
#' a function defined with a .zip file archive deployment package.
#' @param S3Bucket An Amazon S3 bucket in the same Amazon Web Services Region as your
#' function. The bucket can be in a different Amazon Web Services account.
#' Use only with a function defined with a .zip file archive deployment
#' package.
#' @param S3Key The Amazon S3 key of the deployment package. Use only with a function
#' defined with a .zip file archive deployment package.
#' @param S3ObjectVersion For versioned objects, the version of the deployment package object to
#' use.
#' @param ImageUri URI of a container image in the Amazon ECR registry. Do not use for a
#' function defined with a .zip file archive.
#' @param Publish Set to true to publish a new version of the function after updating the
#' code. This has the same effect as calling
#' [`publish_version`][lambda_publish_version] separately.
#' @param DryRun Set to true to validate the request parameters and access permissions
#' without modifying the function code.
#' @param RevisionId Update the function only if the revision ID matches the ID that's
#' specified. Use this option to avoid modifying a function that has
#' changed since you last read it.
#' @param Architectures The instruction set architecture that the function supports. Enter a
#' string array with one of the valid values (arm64 or x86_64). The default
#' value is `x86_64`.
#' @param SourceKMSKeyArn The ARN of the Key Management Service (KMS) customer managed key that's
#' used to encrypt your function's .zip deployment package. If you don't
#' provide a customer managed key, Lambda uses an Amazon Web Services
#' managed key.
#'
#' @keywords internal
#'
#' @rdname lambda_update_function_code
lambda_update_function_code <- function(FunctionName, ZipFile = NULL, S3Bucket = NULL, S3Key = NULL, S3ObjectVersion = NULL, ImageUri = NULL, Publish = NULL, DryRun = NULL, RevisionId = NULL, Architectures = NULL, SourceKMSKeyArn = NULL) {
  op <- new_operation(
    name = "UpdateFunctionCode",
    http_method = "PUT",
    http_path = "/2015-03-31/functions/{FunctionName}/code",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_function_code_input(FunctionName = FunctionName, ZipFile = ZipFile, S3Bucket = S3Bucket, S3Key = S3Key, S3ObjectVersion = S3ObjectVersion, ImageUri = ImageUri, Publish = Publish, DryRun = DryRun, RevisionId = RevisionId, Architectures = Architectures, SourceKMSKeyArn = SourceKMSKeyArn)
  output <- .lambda$update_function_code_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_function_code <- lambda_update_function_code

#' Modify the version-specific settings of a Lambda function
#'
#' @description
#' Modify the version-specific settings of a Lambda function.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_function_configuration/](https://www.paws-r-sdk.com/docs/lambda_update_function_configuration/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Role The Amazon Resource Name (ARN) of the function's execution role.
#' @param Handler The name of the method within your code that Lambda calls to run your
#' function. Handler is required if the deployment package is a .zip file
#' archive. The format includes the file name. It can also include
#' namespaces and other qualifiers, depending on the runtime. For more
#' information, see [Lambda programming
#' model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
#' @param Description A description of the function.
#' @param Timeout The amount of time (in seconds) that Lambda allows a function to run
#' before stopping it. The default is 3 seconds. The maximum allowed value
#' is 900 seconds. For more information, see [Lambda execution
#' environment](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtime-environment.html).
#' @param MemorySize The amount of [memory available to the
#' function](https://docs.aws.amazon.com/lambda/latest/dg/lambda-functions.html#configuration-memory-console)
#' at runtime. Increasing the function memory also increases its CPU
#' allocation. The default value is 128 MB. The value can be any multiple
#' of 1 MB.
#' @param VpcConfig For network connectivity to Amazon Web Services resources in a VPC,
#' specify a list of security groups and subnets in the VPC. When you
#' connect a function to a VPC, it can access resources and the internet
#' only through that VPC. For more information, see [Configuring a Lambda
#' function to access resources in a
#' VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
#' @param Environment Environment variables that are accessible from function code during
#' execution.
#' @param Runtime The identifier of the function's
#' [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
#' Runtime is required if the deployment package is a .zip file archive.
#' Specifying a runtime results in an error if you're deploying a function
#' using a container image.
#' 
#' The following list includes deprecated runtimes. Lambda blocks creating
#' new functions and updating existing functions shortly after each runtime
#' is deprecated. For more information, see [Runtime use after
#' deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
#' 
#' For a list of all currently supported runtimes, see [Supported
#' runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
#' @param DeadLetterConfig A dead-letter queue configuration that specifies the queue or topic
#' where Lambda sends asynchronous events when they fail processing. For
#' more information, see [Dead-letter
#' queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
#' @param KMSKeyArn The ARN of the Key Management Service (KMS) customer managed key that's
#' used to encrypt the following resources:
#' 
#' -   The function's [environment
#'     variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption).
#' 
#' -   The function's [Lambda
#'     SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html)
#'     snapshots.
#' 
#' -   When used with `SourceKMSKeyArn`, the unzipped version of the .zip
#'     deployment package that's used for function invocations. For more
#'     information, see [Specifying a customer managed key for
#'     Lambda](https://docs.aws.amazon.com/lambda/latest/dg/encrypt-zip-package.html#enable-zip-custom-encryption).
#' 
#' -   The optimized version of the container image that's used for
#'     function invocations. Note that this is not the same key that's used
#'     to protect your container image in the Amazon Elastic Container
#'     Registry (Amazon ECR). For more information, see [Function
#'     lifecycle](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-lifecycle).
#' 
#' If you don't provide a customer managed key, Lambda uses an [Amazon Web
#' Services owned
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk)
#' or an [Amazon Web Services managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' @param TracingConfig Set `Mode` to `Active` to sample and trace a subset of incoming requests
#' with
#' [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
#' @param RevisionId Update the function only if the revision ID matches the ID that's
#' specified. Use this option to avoid modifying a function that has
#' changed since you last read it.
#' @param Layers A list of [function
#' layers](https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html)
#' to add to the function's execution environment. Specify each layer by
#' its ARN, including the version.
#' @param FileSystemConfigs Connection settings for an Amazon EFS file system.
#' @param ImageConfig [Container image configuration
#' values](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms)
#' that override the values in the container image Docker file.
#' @param EphemeralStorage The size of the function's `/tmp` directory in MB. The default value is
#' 512, but can be any whole number between 512 and 10,240 MB. For more
#' information, see [Configuring ephemeral storage
#' (console)](https://docs.aws.amazon.com/lambda/latest/dg/lambda-functions.html#configuration-ephemeral-storage).
#' @param SnapStart The function's
#' [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html)
#' setting.
#' @param LoggingConfig The function's Amazon CloudWatch Logs configuration settings.
#'
#' @keywords internal
#'
#' @rdname lambda_update_function_configuration
lambda_update_function_configuration <- function(FunctionName, Role = NULL, Handler = NULL, Description = NULL, Timeout = NULL, MemorySize = NULL, VpcConfig = NULL, Environment = NULL, Runtime = NULL, DeadLetterConfig = NULL, KMSKeyArn = NULL, TracingConfig = NULL, RevisionId = NULL, Layers = NULL, FileSystemConfigs = NULL, ImageConfig = NULL, EphemeralStorage = NULL, SnapStart = NULL, LoggingConfig = NULL) {
  op <- new_operation(
    name = "UpdateFunctionConfiguration",
    http_method = "PUT",
    http_path = "/2015-03-31/functions/{FunctionName}/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_function_configuration_input(FunctionName = FunctionName, Role = Role, Handler = Handler, Description = Description, Timeout = Timeout, MemorySize = MemorySize, VpcConfig = VpcConfig, Environment = Environment, Runtime = Runtime, DeadLetterConfig = DeadLetterConfig, KMSKeyArn = KMSKeyArn, TracingConfig = TracingConfig, RevisionId = RevisionId, Layers = Layers, FileSystemConfigs = FileSystemConfigs, ImageConfig = ImageConfig, EphemeralStorage = EphemeralStorage, SnapStart = SnapStart, LoggingConfig = LoggingConfig)
  output <- .lambda$update_function_configuration_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_function_configuration <- lambda_update_function_configuration

#' Updates the configuration for asynchronous invocation for a function,
#' version, or alias
#'
#' @description
#' Updates the configuration for asynchronous invocation for a function, version, or alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_function_event_invoke_config/](https://www.paws-r-sdk.com/docs/lambda_update_function_event_invoke_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier A version number or alias name.
#' @param MaximumRetryAttempts The maximum number of times to retry when the function returns an error.
#' @param MaximumEventAgeInSeconds The maximum age of a request that Lambda sends to a function for
#' processing.
#' @param DestinationConfig A destination for events after they have been sent to a function for
#' processing.
#' 
#' **Destinations**
#' 
#' -   **Function** - The Amazon Resource Name (ARN) of a Lambda function.
#' 
#' -   **Queue** - The ARN of a standard SQS queue.
#' 
#' -   **Bucket** - The ARN of an Amazon S3 bucket.
#' 
#' -   **Topic** - The ARN of a standard SNS topic.
#' 
#' -   **Event Bus** - The ARN of an Amazon EventBridge event bus.
#' 
#' S3 buckets are supported only for on-failure destinations. To retain
#' records of successful invocations, use another destination type.
#'
#' @keywords internal
#'
#' @rdname lambda_update_function_event_invoke_config
lambda_update_function_event_invoke_config <- function(FunctionName, Qualifier = NULL, MaximumRetryAttempts = NULL, MaximumEventAgeInSeconds = NULL, DestinationConfig = NULL) {
  op <- new_operation(
    name = "UpdateFunctionEventInvokeConfig",
    http_method = "POST",
    http_path = "/2019-09-25/functions/{FunctionName}/event-invoke-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_function_event_invoke_config_input(FunctionName = FunctionName, Qualifier = Qualifier, MaximumRetryAttempts = MaximumRetryAttempts, MaximumEventAgeInSeconds = MaximumEventAgeInSeconds, DestinationConfig = DestinationConfig)
  output <- .lambda$update_function_event_invoke_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_function_event_invoke_config <- lambda_update_function_event_invoke_config

#' Updates the configuration for a Lambda function URL
#'
#' @description
#' Updates the configuration for a Lambda function URL.
#'
#' See [https://www.paws-r-sdk.com/docs/lambda_update_function_url_config/](https://www.paws-r-sdk.com/docs/lambda_update_function_url_config/) for full documentation.
#'
#' @param FunctionName &#91;required&#93; The name or ARN of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** – `my-function`.
#' 
#' -   **Function ARN** –
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** – `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Qualifier The alias name.
#' @param AuthType The type of authentication that your function URL uses. Set to `AWS_IAM`
#' if you want to restrict access to authenticated users only. Set to
#' `NONE` if you want to bypass IAM authentication to create a public
#' endpoint. For more information, see [Security and auth model for Lambda
#' function
#' URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
#' @param Cors The [cross-origin resource sharing
#' (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings
#' for your function URL.
#' @param InvokeMode Use one of the following options:
#' 
#' -   `BUFFERED` – This is the default option. Lambda invokes your
#'     function using the [`invoke`][lambda_invoke] API operation.
#'     Invocation results are available when the payload is complete. The
#'     maximum payload size is 6 MB.
#' 
#' -   `RESPONSE_STREAM` – Your function streams payload results as they
#'     become available. Lambda invokes your function using the
#'     [`invoke_with_response_stream`][lambda_invoke_with_response_stream]
#'     API operation. The maximum response payload size is 20 MB, however,
#'     you can [request a quota
#'     increase](https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html).
#'
#' @keywords internal
#'
#' @rdname lambda_update_function_url_config
lambda_update_function_url_config <- function(FunctionName, Qualifier = NULL, AuthType = NULL, Cors = NULL, InvokeMode = NULL) {
  op <- new_operation(
    name = "UpdateFunctionUrlConfig",
    http_method = "PUT",
    http_path = "/2021-10-31/functions/{FunctionName}/url",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lambda$update_function_url_config_input(FunctionName = FunctionName, Qualifier = Qualifier, AuthType = AuthType, Cors = Cors, InvokeMode = InvokeMode)
  output <- .lambda$update_function_url_config_output()
  config <- get_config()
  svc <- .lambda$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_function_url_config <- lambda_update_function_url_config
