% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_capacity_reservation_by_splitting}
\alias{ec2_create_capacity_reservation_by_splitting}
\title{Create a new Capacity Reservation by splitting the capacity of the
source Capacity Reservation}
\usage{
ec2_create_capacity_reservation_by_splitting(
  DryRun = NULL,
  ClientToken = NULL,
  SourceCapacityReservationId,
  InstanceCount,
  TagSpecifications = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensure Idempotency}.}

\item{SourceCapacityReservationId}{[required] The ID of the Capacity Reservation from which you want to split the
capacity.}

\item{InstanceCount}{[required] The number of instances to split from the source Capacity Reservation.}

\item{TagSpecifications}{The tags to apply to the new Capacity Reservation.}
}
\description{
Create a new Capacity Reservation by splitting the capacity of the source Capacity Reservation. The new Capacity Reservation will have the same attributes as the source Capacity Reservation except for tags. The source Capacity Reservation must be \code{active} and owned by your Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation_by_splitting/} for full documentation.
}
\keyword{internal}
