# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AmazonConnectCampaignServiceV2
#'
#' @description
#' Provide APIs to create and manage Amazon Connect Campaigns.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- connectcampaignservicev2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- connectcampaignservicev2()
#' svc$create_campaign(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=connectcampaignservicev2_create_campaign]{create_campaign} \tab Creates a campaign for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_delete_campaign]{delete_campaign} \tab Deletes a campaign from the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_delete_campaign_channel_subtype_config]{delete_campaign_channel_subtype_config} \tab Deletes the channel subtype config of a campaign\cr
#'  \link[=connectcampaignservicev2_delete_campaign_communication_limits]{delete_campaign_communication_limits} \tab Deletes the communication limits config for a campaign\cr
#'  \link[=connectcampaignservicev2_delete_campaign_communication_time]{delete_campaign_communication_time} \tab Deletes the communication time config for a campaign\cr
#'  \link[=connectcampaignservicev2_delete_connect_instance_config]{delete_connect_instance_config} \tab Deletes a connect instance config from the specified AWS account\cr
#'  \link[=connectcampaignservicev2_delete_connect_instance_integration]{delete_connect_instance_integration} \tab Delete the integration for the specified Amazon Connect instance\cr
#'  \link[=connectcampaignservicev2_delete_instance_onboarding_job]{delete_instance_onboarding_job} \tab Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance\cr
#'  \link[=connectcampaignservicev2_describe_campaign]{describe_campaign} \tab Describes the specific campaign\cr
#'  \link[=connectcampaignservicev2_get_campaign_state]{get_campaign_state} \tab Get state of a campaign for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_get_campaign_state_batch]{get_campaign_state_batch} \tab Get state of campaigns for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_get_connect_instance_config]{get_connect_instance_config} \tab Get the specific Connect instance config\cr
#'  \link[=connectcampaignservicev2_get_instance_onboarding_job_status]{get_instance_onboarding_job_status} \tab Get the specific instance onboarding job status\cr
#'  \link[=connectcampaignservicev2_list_campaigns]{list_campaigns} \tab Provides summary information about the campaigns under the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_list_connect_instance_integrations]{list_connect_instance_integrations} \tab Provides summary information about the integration under the specified Connect instance\cr
#'  \link[=connectcampaignservicev2_list_tags_for_resource]{list_tags_for_resource} \tab List tags for a resource\cr
#'  \link[=connectcampaignservicev2_pause_campaign]{pause_campaign} \tab Pauses a campaign for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_put_connect_instance_integration]{put_connect_instance_integration} \tab Put or update the integration for the specified Amazon Connect instance\cr
#'  \link[=connectcampaignservicev2_put_outbound_request_batch]{put_outbound_request_batch} \tab Creates outbound requests for the specified campaign Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_put_profile_outbound_request_batch]{put_profile_outbound_request_batch} \tab Takes in a list of profile outbound requests to be placed as part of an outbound campaign\cr
#'  \link[=connectcampaignservicev2_resume_campaign]{resume_campaign} \tab Stops a campaign for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_start_campaign]{start_campaign} \tab Starts a campaign for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_start_instance_onboarding_job]{start_instance_onboarding_job} \tab Onboard the specific Amazon Connect instance to Connect Campaigns\cr
#'  \link[=connectcampaignservicev2_stop_campaign]{stop_campaign} \tab Stops a campaign for the specified Amazon Connect account\cr
#'  \link[=connectcampaignservicev2_tag_resource]{tag_resource} \tab Tag a resource\cr
#'  \link[=connectcampaignservicev2_untag_resource]{untag_resource} \tab Untag a resource\cr
#'  \link[=connectcampaignservicev2_update_campaign_channel_subtype_config]{update_campaign_channel_subtype_config} \tab Updates the channel subtype config of a campaign\cr
#'  \link[=connectcampaignservicev2_update_campaign_communication_limits]{update_campaign_communication_limits} \tab Updates the communication limits config for a campaign\cr
#'  \link[=connectcampaignservicev2_update_campaign_communication_time]{update_campaign_communication_time} \tab Updates the communication time config for a campaign\cr
#'  \link[=connectcampaignservicev2_update_campaign_flow_association]{update_campaign_flow_association} \tab Updates the campaign flow associated with a campaign\cr
#'  \link[=connectcampaignservicev2_update_campaign_name]{update_campaign_name} \tab Updates the name of a campaign\cr
#'  \link[=connectcampaignservicev2_update_campaign_schedule]{update_campaign_schedule} \tab Updates the schedule for a campaign\cr
#'  \link[=connectcampaignservicev2_update_campaign_source]{update_campaign_source} \tab Updates the campaign source with a campaign
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname connectcampaignservicev2
#' @export
connectcampaignservicev2 <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .connectcampaignservicev2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.connectcampaignservicev2 <- list()

.connectcampaignservicev2$operations <- list()

.connectcampaignservicev2$metadata <- list(
  service_name = "connectcampaignservicev2",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "connect-campaigns.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ConnectCampaignsV2",
  api_version = "2024-04-23",
  signing_name = "connect-campaigns",
  json_version = "1.1",
  target_prefix = ""
)

.connectcampaignservicev2$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.connectcampaignservicev2$metadata, handlers, config, op)
}
