% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_contact_flow_version}
\alias{connect_create_contact_flow_version}
\title{Publishes a new version of the flow provided}
\usage{
connect_create_contact_flow_version(
  InstanceId,
  Description = NULL,
  ContactFlowId,
  FlowContentSha256 = NULL,
  ContactFlowVersion = NULL,
  LastModifiedTime = NULL,
  LastModifiedRegion = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{Description}{The description of the flow version.}

\item{ContactFlowId}{[required] The identifier of the flow.}

\item{FlowContentSha256}{Indicates the checksum value of the flow content.}

\item{ContactFlowVersion}{The identifier of the flow version.}

\item{LastModifiedTime}{The Amazon Web Services Region where this resource was last modified.}

\item{LastModifiedRegion}{The Amazon Web Services Region where this resource was last modified.}
}
\description{
Publishes a new version of the flow provided. Versions are immutable and monotonically increasing. If the \code{FlowContentSha256} provided is different from the \code{FlowContentSha256} of the \verb{$LATEST} published flow content, then an error is returned. This API only supports creating versions for flows of type \code{Campaign}.

See \url{https://www.paws-r-sdk.com/docs/connect_create_contact_flow_version/} for full documentation.
}
\keyword{internal}
