% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_attached_file}
\alias{connect_get_attached_file}
\title{Provides a pre-signed URL for download of an approved attached file}
\usage{
connect_get_attached_file(
  InstanceId,
  FileId,
  UrlExpiryInSeconds = NULL,
  AssociatedResourceArn
)
}
\arguments{
\item{InstanceId}{[required] The unique identifier of the Amazon Connect instance.}

\item{FileId}{[required] The unique identifier of the attached file resource.}

\item{UrlExpiryInSeconds}{Optional override for the expiry of the pre-signed S3 URL in seconds.
The default value is 300.}

\item{AssociatedResourceArn}{[required] The resource to which the attached file is (being) uploaded to. The
supported resources are
\href{https://docs.aws.amazon.com/connect/latest/adminguide/cases.html}{Cases}
and
\href{https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html}{Email}.

This value must be a valid ARN.}
}
\description{
Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the attached file. It will only return a downloadURL if the status of the attached file is \code{APPROVED}.

See \url{https://www.paws-r-sdk.com/docs/connect_get_attached_file/} for full documentation.
}
\keyword{internal}
