% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_put_profile_object_type}
\alias{customerprofiles_put_profile_object_type}
\title{Defines a ProfileObjectType}
\usage{
customerprofiles_put_profile_object_type(
  DomainName,
  ObjectTypeName,
  Description,
  TemplateId = NULL,
  ExpirationDays = NULL,
  EncryptionKey = NULL,
  AllowProfileCreation = NULL,
  SourceLastUpdatedTimestampFormat = NULL,
  MaxProfileObjectCount = NULL,
  Fields = NULL,
  Keys = NULL,
  Tags = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{ObjectTypeName}{[required] The name of the profile object type.}

\item{Description}{[required] Description of the profile object type.}

\item{TemplateId}{A unique identifier for the object template. For some attributes in the
request, the service will use the default value from the object template
when TemplateId is present. If these attributes are present in the
request, the service may return a \code{BadRequestException}. These
attributes include: AllowProfileCreation,
SourceLastUpdatedTimestampFormat, Fields, and Keys. For example, if
AllowProfileCreation is set to true when TemplateId is set, the service
may return a \code{BadRequestException}.}

\item{ExpirationDays}{The number of days until the data in the object expires.}

\item{EncryptionKey}{The customer-provided key to encrypt the profile object that will be
created in this profile object type.}

\item{AllowProfileCreation}{Indicates whether a profile should be created when data is received if
one doesn’t exist for an object of this type. The default is \code{FALSE}. If
the AllowProfileCreation flag is set to \code{FALSE}, then the service tries
to fetch a standard profile and associate this object with the profile.
If it is set to \code{TRUE}, and if no match is found, then the service
creates a new standard profile.}

\item{SourceLastUpdatedTimestampFormat}{The format of your \code{sourceLastUpdatedTimestamp} that was previously set
up.}

\item{MaxProfileObjectCount}{The amount of profile object max count assigned to the object type}

\item{Fields}{A map of the name and ObjectType field.}

\item{Keys}{A list of unique keys that can be used to map data to the profile.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Defines a ProfileObjectType.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_put_profile_object_type/} for full documentation.
}
\keyword{internal}
