% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_orderable_db_instance_options}
\alias{docdb_describe_orderable_db_instance_options}
\title{Returns a list of orderable instance options for the specified engine}
\usage{
docdb_describe_orderable_db_instance_options(
  Engine,
  EngineVersion = NULL,
  DBInstanceClass = NULL,
  LicenseModel = NULL,
  Vpc = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{Engine}{[required] The name of the engine to retrieve instance options for.}

\item{EngineVersion}{The engine version filter value. Specify this parameter to show only the
available offerings that match the specified engine version.}

\item{DBInstanceClass}{The instance class filter value. Specify this parameter to show only the
available offerings that match the specified instance class.}

\item{LicenseModel}{The license model filter value. Specify this parameter to show only the
available offerings that match the specified license model.}

\item{Vpc}{The virtual private cloud (VPC) filter value. Specify this parameter to
show only the available VPC or non-VPC offerings.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns a list of orderable instance options for the specified engine.

See \url{https://www.paws-r-sdk.com/docs/docdb_describe_orderable_db_instance_options/} for full documentation.
}
\keyword{internal}
