% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_restore_table_from_backup}
\alias{dynamodb_restore_table_from_backup}
\title{Creates a new table from an existing backup}
\usage{
dynamodb_restore_table_from_backup(
  TargetTableName,
  BackupArn,
  BillingModeOverride = NULL,
  GlobalSecondaryIndexOverride = NULL,
  LocalSecondaryIndexOverride = NULL,
  ProvisionedThroughputOverride = NULL,
  OnDemandThroughputOverride = NULL,
  SSESpecificationOverride = NULL
)
}
\arguments{
\item{TargetTableName}{[required] The name of the new table to which the backup must be restored.}

\item{BackupArn}{[required] The Amazon Resource Name (ARN) associated with the backup.}

\item{BillingModeOverride}{The billing mode of the restored table.}

\item{GlobalSecondaryIndexOverride}{List of global secondary indexes for the restored table. The indexes
provided should match existing secondary indexes. You can choose to
exclude some or all of the indexes at the time of restore.}

\item{LocalSecondaryIndexOverride}{List of local secondary indexes for the restored table. The indexes
provided should match existing secondary indexes. You can choose to
exclude some or all of the indexes at the time of restore.}

\item{ProvisionedThroughputOverride}{Provisioned throughput settings for the restored table.}

\item{OnDemandThroughputOverride}{}

\item{SSESpecificationOverride}{The new server-side encryption settings for the restored table.}
}
\description{
Creates a new table from an existing backup. Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_restore_table_from_backup/} for full documentation.
}
\keyword{internal}
