% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_custom.R
\name{rds_build_auth_token_v2}
\alias{rds_build_auth_token_v2}
\title{Generates an auth token used to connect to a db with IAM credentials.}
\usage{
rds_build_auth_token_v2(DBHostname, Port, DBUsername, Region = NULL)
}
\arguments{
\item{DBHostname}{[required] The hostname of the database to connect to.}

\item{Port}{[required] The port number the database is listening on.}

\item{DBUsername}{[required] The username to log in as.}

\item{Region}{The region the database is in. If \code{NULL}, the client
region will be used.}
}
\value{
A presigned url which can be used as an auth token.
}
\description{
See \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{\emph{IAM Database Authentication for MySQL and PostgreSQL}}
for more information on using IAM database authentication with RDS.
}
\examples{
\dontrun{
# This example gets an authentication token for an RDS database, then
# connects to the database using the token.
host <- "database-1.cluster-abcdef123456.us-east-1.rds.amazonaws.com"
port <- 3306
user <- "jane_doe"
token <- svc$build_auth_token_v2(
  DBHostname = host,
  Port = port,
  user = user
)
conn <- DBI::dbConnect(
  drv = RMariaDB::MariaDB(),
  user = user,
  password = token,
  host = host,
  port = port,
  client.flag = RMariaDB::CLIENT_SSL
)
}

}
\seealso{
\link[paws.database:rds_build_auth_token]{rds_build_auth_token}
}
\keyword{internal}
