# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include bedrockagent_service.R
NULL

#' Makes an agent a collaborator for another agent
#'
#' @description
#' Makes an agent a collaborator for another agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_associate_agent_collaborator/](https://www.paws-r-sdk.com/docs/bedrockagent_associate_agent_collaborator/) for full documentation.
#'
#' @param agentDescriptor &#91;required&#93; The alias of the collaborator agent.
#' @param agentId &#91;required&#93; The agent's ID.
#' @param agentVersion &#91;required&#93; An agent version.
#' @param clientToken A client token.
#' @param collaborationInstruction &#91;required&#93; Instruction for the collaborator.
#' @param collaboratorName &#91;required&#93; A name for the collaborator.
#' @param relayConversationHistory A relay conversation history for the collaborator.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_associate_agent_collaborator
bedrockagent_associate_agent_collaborator <- function(agentDescriptor, agentId, agentVersion, clientToken = NULL, collaborationInstruction, collaboratorName, relayConversationHistory = NULL) {
  op <- new_operation(
    name = "AssociateAgentCollaborator",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$associate_agent_collaborator_input(agentDescriptor = agentDescriptor, agentId = agentId, agentVersion = agentVersion, clientToken = clientToken, collaborationInstruction = collaborationInstruction, collaboratorName = collaboratorName, relayConversationHistory = relayConversationHistory)
  output <- .bedrockagent$associate_agent_collaborator_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$associate_agent_collaborator <- bedrockagent_associate_agent_collaborator

#' Associates a knowledge base with an agent
#'
#' @description
#' Associates a knowledge base with an agent. If a knowledge base is associated and its `indexState` is set to `Enabled`, the agent queries the knowledge base for information to augment its response to the user.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_associate_agent_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_associate_agent_knowledge_base/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent with which you want to associate the
#' knowledge base.
#' @param agentVersion &#91;required&#93; The version of the agent with which you want to associate the knowledge
#' base.
#' @param description &#91;required&#93; A description of what the agent should use the knowledge base for.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to associate with the agent.
#' @param knowledgeBaseState Specifies whether to use the knowledge base or not when sending an
#' [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
#' request.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_associate_agent_knowledge_base
bedrockagent_associate_agent_knowledge_base <- function(agentId, agentVersion, description, knowledgeBaseId, knowledgeBaseState = NULL) {
  op <- new_operation(
    name = "AssociateAgentKnowledgeBase",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$associate_agent_knowledge_base_input(agentId = agentId, agentVersion = agentVersion, description = description, knowledgeBaseId = knowledgeBaseId, knowledgeBaseState = knowledgeBaseState)
  output <- .bedrockagent$associate_agent_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$associate_agent_knowledge_base <- bedrockagent_associate_agent_knowledge_base

#' Creates an agent that orchestrates interactions between foundation
#' models, data sources, software applications, user conversations, and
#' APIs to carry out tasks to help customers
#'
#' @description
#' Creates an agent that orchestrates interactions between foundation models, data sources, software applications, user conversations, and APIs to carry out tasks to help customers.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_agent/](https://www.paws-r-sdk.com/docs/bedrockagent_create_agent/) for full documentation.
#'
#' @param agentCollaboration The agent's collaboration role.
#' @param agentName &#91;required&#93; A name for the agent that you create.
#' @param agentResourceRoleArn The Amazon Resource Name (ARN) of the IAM role with permissions to
#' invoke API operations on the agent.
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param customOrchestration Contains details of the custom orchestration configured for the agent.
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key with which to encrypt the
#' agent.
#' @param description A description of the agent.
#' @param foundationModel The identifier for the model that you want to be used for orchestration
#' by the agent you create.
#' 
#' The `modelId` to provide depends on the type of model or throughput that
#' you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an inference profile, specify the inference profile ID or
#'     its ARN. For a list of inference profile IDs, see [Supported Regions
#'     and models for cross-region
#'     inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an [imported
#'     model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html),
#'     specify the ARN of the imported model. You can get the model ARN
#'     from a successful call to
#'     [CreateModelImportJob](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html)
#'     or from the Imported models page in the Amazon Bedrock console.
#' @param guardrailConfiguration The unique Guardrail configuration assigned to the agent when it is
#' created.
#' @param idleSessionTTLInSeconds The number of seconds for which Amazon Bedrock keeps information about a
#' user's conversation with the agent.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and Amazon
#' Bedrock deletes any data provided before the timeout.
#' @param instruction Instructions that tell the agent what it should do and how it should
#' interact with users.
#' @param memoryConfiguration Contains the details of the memory configured for the agent.
#' @param orchestrationType Specifies the type of orchestration strategy for the agent. This is set
#' to `DEFAULT` orchestration type, by default.
#' @param promptOverrideConfiguration Contains configurations to override prompts in different parts of an
#' agent sequence. For more information, see [Advanced
#' prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
#' @param tags Any tags that you want to attach to the agent.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_agent
bedrockagent_create_agent <- function(agentCollaboration = NULL, agentName, agentResourceRoleArn = NULL, clientToken = NULL, customOrchestration = NULL, customerEncryptionKeyArn = NULL, description = NULL, foundationModel = NULL, guardrailConfiguration = NULL, idleSessionTTLInSeconds = NULL, instruction = NULL, memoryConfiguration = NULL, orchestrationType = NULL, promptOverrideConfiguration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAgent",
    http_method = "PUT",
    http_path = "/agents/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_agent_input(agentCollaboration = agentCollaboration, agentName = agentName, agentResourceRoleArn = agentResourceRoleArn, clientToken = clientToken, customOrchestration = customOrchestration, customerEncryptionKeyArn = customerEncryptionKeyArn, description = description, foundationModel = foundationModel, guardrailConfiguration = guardrailConfiguration, idleSessionTTLInSeconds = idleSessionTTLInSeconds, instruction = instruction, memoryConfiguration = memoryConfiguration, orchestrationType = orchestrationType, promptOverrideConfiguration = promptOverrideConfiguration, tags = tags)
  output <- .bedrockagent$create_agent_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_agent <- bedrockagent_create_agent

#' Creates an action group for an agent
#'
#' @description
#' Creates an action group for an agent. An action group represents the actions that an agent can carry out for the customer by defining the APIs that an agent can call and the logic for calling them.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_agent_action_group/](https://www.paws-r-sdk.com/docs/bedrockagent_create_agent_action_group/) for full documentation.
#'
#' @param actionGroupExecutor The Amazon Resource Name (ARN) of the Lambda function containing the
#' business logic that is carried out upon invoking the action or the
#' custom control method for handling the information elicited from the
#' user.
#' @param actionGroupName &#91;required&#93; The name to give the action group.
#' @param actionGroupState Specifies whether the action group is available for the agent to invoke
#' or not when sending an
#' [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
#' request.
#' @param agentId &#91;required&#93; The unique identifier of the agent for which to create the action group.
#' @param agentVersion &#91;required&#93; The version of the agent for which to create the action group.
#' @param apiSchema Contains either details about the S3 object containing the OpenAPI
#' schema for the action group or the JSON or YAML-formatted payload
#' defining the schema. For more information, see [Action group OpenAPI
#' schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param description A description of the action group.
#' @param functionSchema Contains details about the function schema for the action group or the
#' JSON or YAML-formatted payload defining the schema.
#' @param parentActionGroupSignature To allow your agent to request the user for additional information when
#' trying to complete a task, set this field to `AMAZON.UserInput`. You
#' must leave the `description`, `apiSchema`, and `actionGroupExecutor`
#' fields blank for this action group.
#' 
#' To allow your agent to generate, run, and troubleshoot code when trying
#' to complete a task, set this field to `AMAZON.CodeInterpreter`. You must
#' leave the `description`, `apiSchema`, and `actionGroupExecutor` fields
#' blank for this action group.
#' 
#' During orchestration, if your agent determines that it needs to invoke
#' an API in an action group, but doesn't have enough information to
#' complete the API request, it will invoke this action group instead and
#' return an
#' [Observation](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
#' reprompting the user for more information.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_agent_action_group
bedrockagent_create_agent_action_group <- function(actionGroupExecutor = NULL, actionGroupName, actionGroupState = NULL, agentId, agentVersion, apiSchema = NULL, clientToken = NULL, description = NULL, functionSchema = NULL, parentActionGroupSignature = NULL) {
  op <- new_operation(
    name = "CreateAgentActionGroup",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_agent_action_group_input(actionGroupExecutor = actionGroupExecutor, actionGroupName = actionGroupName, actionGroupState = actionGroupState, agentId = agentId, agentVersion = agentVersion, apiSchema = apiSchema, clientToken = clientToken, description = description, functionSchema = functionSchema, parentActionGroupSignature = parentActionGroupSignature)
  output <- .bedrockagent$create_agent_action_group_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_agent_action_group <- bedrockagent_create_agent_action_group

#' Creates an alias of an agent that can be used to deploy the agent
#'
#' @description
#' Creates an alias of an agent that can be used to deploy the agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_agent_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_create_agent_alias/) for full documentation.
#'
#' @param agentAliasName &#91;required&#93; The name of the alias.
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param description A description of the alias of the agent.
#' @param routingConfiguration Contains details about the routing configuration of the alias.
#' @param tags Any tags that you want to attach to the alias of the agent.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_agent_alias
bedrockagent_create_agent_alias <- function(agentAliasName, agentId, clientToken = NULL, description = NULL, routingConfiguration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAgentAlias",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentaliases/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_agent_alias_input(agentAliasName = agentAliasName, agentId = agentId, clientToken = clientToken, description = description, routingConfiguration = routingConfiguration, tags = tags)
  output <- .bedrockagent$create_agent_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_agent_alias <- bedrockagent_create_agent_alias

#' Connects a knowledge base to a data source
#'
#' @description
#' Connects a knowledge base to a data source. You specify the configuration for the specific data source service in the `dataSourceConfiguration` field.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_data_source/](https://www.paws-r-sdk.com/docs/bedrockagent_create_data_source/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param dataDeletionPolicy The data deletion policy for the data source.
#' 
#' You can set the data deletion policy to:
#' 
#' -   DELETE: Deletes all data from your data source that’s converted into
#'     vector embeddings upon deletion of a knowledge base or data source
#'     resource. Note that the **vector store itself is not deleted**, only
#'     the data. This flag is ignored if an Amazon Web Services account is
#'     deleted.
#' 
#' -   RETAIN: Retains all data from your data source that’s converted into
#'     vector embeddings upon deletion of a knowledge base or data source
#'     resource. Note that the **vector store itself is not deleted** if
#'     you delete a knowledge base or data source resource.
#' @param dataSourceConfiguration &#91;required&#93; The connection configuration for the data source.
#' @param description A description of the data source.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to which to add the data
#' source.
#' @param name &#91;required&#93; The name of the data source.
#' @param serverSideEncryptionConfiguration Contains details about the server-side encryption for the data source.
#' @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_data_source
bedrockagent_create_data_source <- function(clientToken = NULL, dataDeletionPolicy = NULL, dataSourceConfiguration, description = NULL, knowledgeBaseId, name, serverSideEncryptionConfiguration = NULL, vectorIngestionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateDataSource",
    http_method = "PUT",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_data_source_input(clientToken = clientToken, dataDeletionPolicy = dataDeletionPolicy, dataSourceConfiguration = dataSourceConfiguration, description = description, knowledgeBaseId = knowledgeBaseId, name = name, serverSideEncryptionConfiguration = serverSideEncryptionConfiguration, vectorIngestionConfiguration = vectorIngestionConfiguration)
  output <- .bedrockagent$create_data_source_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_data_source <- bedrockagent_create_data_source

#' Creates a prompt flow that you can use to send an input through various
#' steps to yield an output
#'
#' @description
#' Creates a prompt flow that you can use to send an input through various steps to yield an output. Configure nodes, each of which corresponds to a step of the flow, and create connections between the nodes to create paths to different outputs. For more information, see [How it works](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html) and [Create a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_flow/](https://www.paws-r-sdk.com/docs/bedrockagent_create_flow/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
#' @param definition A definition of the nodes and connections between nodes in the flow.
#' @param description A description for the flow.
#' @param executionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the service role with permissions to
#' create and manage a flow. For more information, see [Create a service
#' role for flows in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
#' in the Amazon Bedrock User Guide.
#' @param name &#91;required&#93; A name for the flow.
#' @param tags Any tags that you want to attach to the flow. For more information, see
#' [Tagging resources in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_flow
bedrockagent_create_flow <- function(clientToken = NULL, customerEncryptionKeyArn = NULL, definition = NULL, description = NULL, executionRoleArn, name, tags = NULL) {
  op <- new_operation(
    name = "CreateFlow",
    http_method = "POST",
    http_path = "/flows/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_flow_input(clientToken = clientToken, customerEncryptionKeyArn = customerEncryptionKeyArn, definition = definition, description = description, executionRoleArn = executionRoleArn, name = name, tags = tags)
  output <- .bedrockagent$create_flow_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_flow <- bedrockagent_create_flow

#' Creates an alias of a flow for deployment
#'
#' @description
#' Creates an alias of a flow for deployment. For more information, see [Deploy a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_flow_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_create_flow_alias/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param description A description for the alias.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow for which to create an alias.
#' @param name &#91;required&#93; A name for the alias.
#' @param routingConfiguration &#91;required&#93; Contains information about the version to which to map the alias.
#' @param tags Any tags that you want to attach to the alias of the flow. For more
#' information, see [Tagging resources in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_flow_alias
bedrockagent_create_flow_alias <- function(clientToken = NULL, description = NULL, flowIdentifier, name, routingConfiguration, tags = NULL) {
  op <- new_operation(
    name = "CreateFlowAlias",
    http_method = "POST",
    http_path = "/flows/{flowIdentifier}/aliases",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_flow_alias_input(clientToken = clientToken, description = description, flowIdentifier = flowIdentifier, name = name, routingConfiguration = routingConfiguration, tags = tags)
  output <- .bedrockagent$create_flow_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_flow_alias <- bedrockagent_create_flow_alias

#' Creates a version of the flow that you can deploy
#'
#' @description
#' Creates a version of the flow that you can deploy. For more information, see [Deploy a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_flow_version/](https://www.paws-r-sdk.com/docs/bedrockagent_create_flow_version/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param description A description of the version of the flow.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow that you want to create a version of.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_flow_version
bedrockagent_create_flow_version <- function(clientToken = NULL, description = NULL, flowIdentifier) {
  op <- new_operation(
    name = "CreateFlowVersion",
    http_method = "POST",
    http_path = "/flows/{flowIdentifier}/versions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_flow_version_input(clientToken = clientToken, description = description, flowIdentifier = flowIdentifier)
  output <- .bedrockagent$create_flow_version_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_flow_version <- bedrockagent_create_flow_version

#' Creates a knowledge base
#'
#' @description
#' Creates a knowledge base. A knowledge base contains your data sources so that Large Language Models (LLMs) can use your data. To create a knowledge base, you must first set up your data sources and configure a supported vector store. For more information, see [Set up a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_create_knowledge_base/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param description A description of the knowledge base.
#' @param knowledgeBaseConfiguration &#91;required&#93; Contains details about the embeddings model used for the knowledge base.
#' @param name &#91;required&#93; A name for the knowledge base.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role with permissions to
#' invoke API operations on the knowledge base.
#' @param storageConfiguration Contains details about the configuration of the vector database used for
#' the knowledge base.
#' @param tags Specify the key-value pairs for the tags that you want to attach to your
#' knowledge base in this object.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_knowledge_base
bedrockagent_create_knowledge_base <- function(clientToken = NULL, description = NULL, knowledgeBaseConfiguration, name, roleArn, storageConfiguration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateKnowledgeBase",
    http_method = "PUT",
    http_path = "/knowledgebases/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_knowledge_base_input(clientToken = clientToken, description = description, knowledgeBaseConfiguration = knowledgeBaseConfiguration, name = name, roleArn = roleArn, storageConfiguration = storageConfiguration, tags = tags)
  output <- .bedrockagent$create_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_knowledge_base <- bedrockagent_create_knowledge_base

#' Creates a prompt in your prompt library that you can add to a flow
#'
#' @description
#' Creates a prompt in your prompt library that you can add to a flow. For more information, see [Prompt management in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html), [Create a prompt using Prompt management](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html) and [Prompt flows in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_prompt/](https://www.paws-r-sdk.com/docs/bedrockagent_create_prompt/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
#' @param defaultVariant The name of the default variant for the prompt. This value must match
#' the `name` field in the relevant
#' [PromptVariant](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
#' object.
#' @param description A description for the prompt.
#' @param name &#91;required&#93; A name for the prompt.
#' @param tags Any tags that you want to attach to the prompt. For more information,
#' see [Tagging resources in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
#' @param variants A list of objects, each containing details about a variant of the
#' prompt.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_prompt
bedrockagent_create_prompt <- function(clientToken = NULL, customerEncryptionKeyArn = NULL, defaultVariant = NULL, description = NULL, name, tags = NULL, variants = NULL) {
  op <- new_operation(
    name = "CreatePrompt",
    http_method = "POST",
    http_path = "/prompts/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_prompt_input(clientToken = clientToken, customerEncryptionKeyArn = customerEncryptionKeyArn, defaultVariant = defaultVariant, description = description, name = name, tags = tags, variants = variants)
  output <- .bedrockagent$create_prompt_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_prompt <- bedrockagent_create_prompt

#' Creates a static snapshot of your prompt that can be deployed to
#' production
#'
#' @description
#' Creates a static snapshot of your prompt that can be deployed to production. For more information, see [Deploy prompts using Prompt management by creating versions](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_create_prompt_version/](https://www.paws-r-sdk.com/docs/bedrockagent_create_prompt_version/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param description A description for the version of the prompt.
#' @param promptIdentifier &#91;required&#93; The unique identifier of the prompt that you want to create a version
#' of.
#' @param tags Any tags that you want to attach to the version of the prompt. For more
#' information, see [Tagging resources in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname bedrockagent_create_prompt_version
bedrockagent_create_prompt_version <- function(clientToken = NULL, description = NULL, promptIdentifier, tags = NULL) {
  op <- new_operation(
    name = "CreatePromptVersion",
    http_method = "POST",
    http_path = "/prompts/{promptIdentifier}/versions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$create_prompt_version_input(clientToken = clientToken, description = description, promptIdentifier = promptIdentifier, tags = tags)
  output <- .bedrockagent$create_prompt_version_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$create_prompt_version <- bedrockagent_create_prompt_version

#' Deletes an agent
#'
#' @description
#' Deletes an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent to delete.
#' @param skipResourceInUseCheck By default, this value is `false` and deletion is stopped if the
#' resource is in use. If you set it to `true`, the resource will be
#' deleted even if the resource is in use.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_agent
bedrockagent_delete_agent <- function(agentId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteAgent",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_agent_input(agentId = agentId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .bedrockagent$delete_agent_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_agent <- bedrockagent_delete_agent

#' Deletes an action group in an agent
#'
#' @description
#' Deletes an action group in an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent_action_group/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent_action_group/) for full documentation.
#'
#' @param actionGroupId &#91;required&#93; The unique identifier of the action group to delete.
#' @param agentId &#91;required&#93; The unique identifier of the agent that the action group belongs to.
#' @param agentVersion &#91;required&#93; The version of the agent that the action group belongs to.
#' @param skipResourceInUseCheck By default, this value is `false` and deletion is stopped if the
#' resource is in use. If you set it to `true`, the resource will be
#' deleted even if the resource is in use.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_agent_action_group
bedrockagent_delete_agent_action_group <- function(actionGroupId, agentId, agentVersion, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteAgentActionGroup",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_agent_action_group_input(actionGroupId = actionGroupId, agentId = agentId, agentVersion = agentVersion, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .bedrockagent$delete_agent_action_group_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_agent_action_group <- bedrockagent_delete_agent_action_group

#' Deletes an alias of an agent
#'
#' @description
#' Deletes an alias of an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent_alias/) for full documentation.
#'
#' @param agentAliasId &#91;required&#93; The unique identifier of the alias to delete.
#' @param agentId &#91;required&#93; The unique identifier of the agent that the alias belongs to.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_agent_alias
bedrockagent_delete_agent_alias <- function(agentAliasId, agentId) {
  op <- new_operation(
    name = "DeleteAgentAlias",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/agentaliases/{agentAliasId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_agent_alias_input(agentAliasId = agentAliasId, agentId = agentId)
  output <- .bedrockagent$delete_agent_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_agent_alias <- bedrockagent_delete_agent_alias

#' Deletes a version of an agent
#'
#' @description
#' Deletes a version of an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent_version/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_agent_version/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent that the version belongs to.
#' @param agentVersion &#91;required&#93; The version of the agent to delete.
#' @param skipResourceInUseCheck By default, this value is `false` and deletion is stopped if the
#' resource is in use. If you set it to `true`, the resource will be
#' deleted even if the resource is in use.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_agent_version
bedrockagent_delete_agent_version <- function(agentId, agentVersion, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteAgentVersion",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_agent_version_input(agentId = agentId, agentVersion = agentVersion, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .bedrockagent$delete_agent_version_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_agent_version <- bedrockagent_delete_agent_version

#' Deletes a data source from a knowledge base
#'
#' @description
#' Deletes a data source from a knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_data_source/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_data_source/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source to delete.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base from which to delete the
#' data source.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_data_source
bedrockagent_delete_data_source <- function(dataSourceId, knowledgeBaseId) {
  op <- new_operation(
    name = "DeleteDataSource",
    http_method = "DELETE",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_data_source_input(dataSourceId = dataSourceId, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$delete_data_source_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_data_source <- bedrockagent_delete_data_source

#' Deletes a flow
#'
#' @description
#' Deletes a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_flow/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_flow/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#' @param skipResourceInUseCheck By default, this value is `false` and deletion is stopped if the
#' resource is in use. If you set it to `true`, the resource will be
#' deleted even if the resource is in use.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_flow
bedrockagent_delete_flow <- function(flowIdentifier, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteFlow",
    http_method = "DELETE",
    http_path = "/flows/{flowIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_flow_input(flowIdentifier = flowIdentifier, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .bedrockagent$delete_flow_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_flow <- bedrockagent_delete_flow

#' Deletes an alias of a flow
#'
#' @description
#' Deletes an alias of a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_flow_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_flow_alias/) for full documentation.
#'
#' @param aliasIdentifier &#91;required&#93; The unique identifier of the alias to be deleted.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow that the alias belongs to.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_flow_alias
bedrockagent_delete_flow_alias <- function(aliasIdentifier, flowIdentifier) {
  op <- new_operation(
    name = "DeleteFlowAlias",
    http_method = "DELETE",
    http_path = "/flows/{flowIdentifier}/aliases/{aliasIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_flow_alias_input(aliasIdentifier = aliasIdentifier, flowIdentifier = flowIdentifier)
  output <- .bedrockagent$delete_flow_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_flow_alias <- bedrockagent_delete_flow_alias

#' Deletes a version of a flow
#'
#' @description
#' Deletes a version of a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_flow_version/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_flow_version/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow whose version that you want to delete
#' @param flowVersion &#91;required&#93; The version of the flow that you want to delete.
#' @param skipResourceInUseCheck By default, this value is `false` and deletion is stopped if the
#' resource is in use. If you set it to `true`, the resource will be
#' deleted even if the resource is in use.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_flow_version
bedrockagent_delete_flow_version <- function(flowIdentifier, flowVersion, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteFlowVersion",
    http_method = "DELETE",
    http_path = "/flows/{flowIdentifier}/versions/{flowVersion}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_flow_version_input(flowIdentifier = flowIdentifier, flowVersion = flowVersion, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .bedrockagent$delete_flow_version_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_flow_version <- bedrockagent_delete_flow_version

#' Deletes a knowledge base
#'
#' @description
#' Deletes a knowledge base. Before deleting a knowledge base, you should disassociate the knowledge base from any agents that it is associated with by making a [`disassociate_agent_knowledge_base`][bedrockagent_disassociate_agent_knowledge_base] request.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_knowledge_base/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to delete.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_knowledge_base
bedrockagent_delete_knowledge_base <- function(knowledgeBaseId) {
  op <- new_operation(
    name = "DeleteKnowledgeBase",
    http_method = "DELETE",
    http_path = "/knowledgebases/{knowledgeBaseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_knowledge_base_input(knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$delete_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_knowledge_base <- bedrockagent_delete_knowledge_base

#' Deletes documents from a data source and syncs the changes to the
#' knowledge base that is connected to it
#'
#' @description
#' Deletes documents from a data source and syncs the changes to the knowledge base that is connected to it. For more information, see [Ingest changes directly into a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_knowledge_base_documents/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_knowledge_base_documents/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source that contains the documents.
#' @param documentIdentifiers &#91;required&#93; A list of objects, each of which contains information to identify a
#' document to delete.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base that is connected to the
#' data source.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_knowledge_base_documents
bedrockagent_delete_knowledge_base_documents <- function(clientToken = NULL, dataSourceId, documentIdentifiers, knowledgeBaseId) {
  op <- new_operation(
    name = "DeleteKnowledgeBaseDocuments",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents/deleteDocuments",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_knowledge_base_documents_input(clientToken = clientToken, dataSourceId = dataSourceId, documentIdentifiers = documentIdentifiers, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$delete_knowledge_base_documents_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_knowledge_base_documents <- bedrockagent_delete_knowledge_base_documents

#' Deletes a prompt or a version of it, depending on whether you include
#' the promptVersion field or not
#'
#' @description
#' Deletes a prompt or a version of it, depending on whether you include the `promptVersion` field or not. For more information, see [Delete prompts from the Prompt management tool](https://docs.aws.amazon.com/bedrock/latest/userguide/#prompt-management-delete.html) and [Delete a version of a prompt from the Prompt management tool](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-delete.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_delete_prompt/](https://www.paws-r-sdk.com/docs/bedrockagent_delete_prompt/) for full documentation.
#'
#' @param promptIdentifier &#91;required&#93; The unique identifier of the prompt.
#' @param promptVersion The version of the prompt to delete. To delete the prompt, omit this
#' field.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_delete_prompt
bedrockagent_delete_prompt <- function(promptIdentifier, promptVersion = NULL) {
  op <- new_operation(
    name = "DeletePrompt",
    http_method = "DELETE",
    http_path = "/prompts/{promptIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$delete_prompt_input(promptIdentifier = promptIdentifier, promptVersion = promptVersion)
  output <- .bedrockagent$delete_prompt_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$delete_prompt <- bedrockagent_delete_prompt

#' Disassociates an agent collaborator
#'
#' @description
#' Disassociates an agent collaborator.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_disassociate_agent_collaborator/](https://www.paws-r-sdk.com/docs/bedrockagent_disassociate_agent_collaborator/) for full documentation.
#'
#' @param agentId &#91;required&#93; An agent ID.
#' @param agentVersion &#91;required&#93; The agent's version.
#' @param collaboratorId &#91;required&#93; The collaborator's ID.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_disassociate_agent_collaborator
bedrockagent_disassociate_agent_collaborator <- function(agentId, agentVersion, collaboratorId) {
  op <- new_operation(
    name = "DisassociateAgentCollaborator",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/{collaboratorId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$disassociate_agent_collaborator_input(agentId = agentId, agentVersion = agentVersion, collaboratorId = collaboratorId)
  output <- .bedrockagent$disassociate_agent_collaborator_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$disassociate_agent_collaborator <- bedrockagent_disassociate_agent_collaborator

#' Disassociates a knowledge base from an agent
#'
#' @description
#' Disassociates a knowledge base from an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_disassociate_agent_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_disassociate_agent_knowledge_base/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent from which to disassociate the
#' knowledge base.
#' @param agentVersion &#91;required&#93; The version of the agent from which to disassociate the knowledge base.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to disassociate.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_disassociate_agent_knowledge_base
bedrockagent_disassociate_agent_knowledge_base <- function(agentId, agentVersion, knowledgeBaseId) {
  op <- new_operation(
    name = "DisassociateAgentKnowledgeBase",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$disassociate_agent_knowledge_base_input(agentId = agentId, agentVersion = agentVersion, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$disassociate_agent_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$disassociate_agent_knowledge_base <- bedrockagent_disassociate_agent_knowledge_base

#' Gets information about an agent
#'
#' @description
#' Gets information about an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_agent/](https://www.paws-r-sdk.com/docs/bedrockagent_get_agent/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_agent
bedrockagent_get_agent <- function(agentId) {
  op <- new_operation(
    name = "GetAgent",
    http_method = "GET",
    http_path = "/agents/{agentId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_agent_input(agentId = agentId)
  output <- .bedrockagent$get_agent_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_agent <- bedrockagent_get_agent

#' Gets information about an action group for an agent
#'
#' @description
#' Gets information about an action group for an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_action_group/](https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_action_group/) for full documentation.
#'
#' @param actionGroupId &#91;required&#93; The unique identifier of the action group for which to get information.
#' @param agentId &#91;required&#93; The unique identifier of the agent that the action group belongs to.
#' @param agentVersion &#91;required&#93; The version of the agent that the action group belongs to.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_agent_action_group
bedrockagent_get_agent_action_group <- function(actionGroupId, agentId, agentVersion) {
  op <- new_operation(
    name = "GetAgentActionGroup",
    http_method = "GET",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_agent_action_group_input(actionGroupId = actionGroupId, agentId = agentId, agentVersion = agentVersion)
  output <- .bedrockagent$get_agent_action_group_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_agent_action_group <- bedrockagent_get_agent_action_group

#' Gets information about an alias of an agent
#'
#' @description
#' Gets information about an alias of an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_alias/) for full documentation.
#'
#' @param agentAliasId &#91;required&#93; The unique identifier of the alias for which to get information.
#' @param agentId &#91;required&#93; The unique identifier of the agent to which the alias to get information
#' belongs.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_agent_alias
bedrockagent_get_agent_alias <- function(agentAliasId, agentId) {
  op <- new_operation(
    name = "GetAgentAlias",
    http_method = "GET",
    http_path = "/agents/{agentId}/agentaliases/{agentAliasId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_agent_alias_input(agentAliasId = agentAliasId, agentId = agentId)
  output <- .bedrockagent$get_agent_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_agent_alias <- bedrockagent_get_agent_alias

#' Retrieves information about an agent's collaborator
#'
#' @description
#' Retrieves information about an agent's collaborator.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_collaborator/](https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_collaborator/) for full documentation.
#'
#' @param agentId &#91;required&#93; The agent's ID.
#' @param agentVersion &#91;required&#93; The agent's version.
#' @param collaboratorId &#91;required&#93; The collaborator's ID.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_agent_collaborator
bedrockagent_get_agent_collaborator <- function(agentId, agentVersion, collaboratorId) {
  op <- new_operation(
    name = "GetAgentCollaborator",
    http_method = "GET",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/{collaboratorId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_agent_collaborator_input(agentId = agentId, agentVersion = agentVersion, collaboratorId = collaboratorId)
  output <- .bedrockagent$get_agent_collaborator_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_agent_collaborator <- bedrockagent_get_agent_collaborator

#' Gets information about a knowledge base associated with an agent
#'
#' @description
#' Gets information about a knowledge base associated with an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_knowledge_base/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent with which the knowledge base is
#' associated.
#' @param agentVersion &#91;required&#93; The version of the agent with which the knowledge base is associated.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base associated with the agent.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_agent_knowledge_base
bedrockagent_get_agent_knowledge_base <- function(agentId, agentVersion, knowledgeBaseId) {
  op <- new_operation(
    name = "GetAgentKnowledgeBase",
    http_method = "GET",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_agent_knowledge_base_input(agentId = agentId, agentVersion = agentVersion, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$get_agent_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_agent_knowledge_base <- bedrockagent_get_agent_knowledge_base

#' Gets details about a version of an agent
#'
#' @description
#' Gets details about a version of an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_version/](https://www.paws-r-sdk.com/docs/bedrockagent_get_agent_version/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param agentVersion &#91;required&#93; The version of the agent.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_agent_version
bedrockagent_get_agent_version <- function(agentId, agentVersion) {
  op <- new_operation(
    name = "GetAgentVersion",
    http_method = "GET",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_agent_version_input(agentId = agentId, agentVersion = agentVersion)
  output <- .bedrockagent$get_agent_version_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_agent_version <- bedrockagent_get_agent_version

#' Gets information about a data source
#'
#' @description
#' Gets information about a data source.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_data_source/](https://www.paws-r-sdk.com/docs/bedrockagent_get_data_source/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for the data source.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_data_source
bedrockagent_get_data_source <- function(dataSourceId, knowledgeBaseId) {
  op <- new_operation(
    name = "GetDataSource",
    http_method = "GET",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_data_source_input(dataSourceId = dataSourceId, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$get_data_source_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_data_source <- bedrockagent_get_data_source

#' Retrieves information about a flow
#'
#' @description
#' Retrieves information about a flow. For more information, see [Manage a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_flow/](https://www.paws-r-sdk.com/docs/bedrockagent_get_flow/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_flow
bedrockagent_get_flow <- function(flowIdentifier) {
  op <- new_operation(
    name = "GetFlow",
    http_method = "GET",
    http_path = "/flows/{flowIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_flow_input(flowIdentifier = flowIdentifier)
  output <- .bedrockagent$get_flow_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_flow <- bedrockagent_get_flow

#' Retrieves information about a flow
#'
#' @description
#' Retrieves information about a flow. For more information, see [Deploy a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_flow_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_get_flow_alias/) for full documentation.
#'
#' @param aliasIdentifier &#91;required&#93; The unique identifier of the alias for which to retrieve information.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow that the alias belongs to.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_flow_alias
bedrockagent_get_flow_alias <- function(aliasIdentifier, flowIdentifier) {
  op <- new_operation(
    name = "GetFlowAlias",
    http_method = "GET",
    http_path = "/flows/{flowIdentifier}/aliases/{aliasIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_flow_alias_input(aliasIdentifier = aliasIdentifier, flowIdentifier = flowIdentifier)
  output <- .bedrockagent$get_flow_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_flow_alias <- bedrockagent_get_flow_alias

#' Retrieves information about a version of a flow
#'
#' @description
#' Retrieves information about a version of a flow. For more information, see [Deploy a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_flow_version/](https://www.paws-r-sdk.com/docs/bedrockagent_get_flow_version/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow for which to get information.
#' @param flowVersion &#91;required&#93; The version of the flow for which to get information.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_flow_version
bedrockagent_get_flow_version <- function(flowIdentifier, flowVersion) {
  op <- new_operation(
    name = "GetFlowVersion",
    http_method = "GET",
    http_path = "/flows/{flowIdentifier}/versions/{flowVersion}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_flow_version_input(flowIdentifier = flowIdentifier, flowVersion = flowVersion)
  output <- .bedrockagent$get_flow_version_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_flow_version <- bedrockagent_get_flow_version

#' Gets information about a data ingestion job
#'
#' @description
#' Gets information about a data ingestion job. Data sources are ingested into your knowledge base so that Large Language Models (LLMs) can use your data.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_ingestion_job/](https://www.paws-r-sdk.com/docs/bedrockagent_get_ingestion_job/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source for the data ingestion job you
#' want to get information on.
#' @param ingestionJobId &#91;required&#93; The unique identifier of the data ingestion job you want to get
#' information on.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for the data ingestion job
#' you want to get information on.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_ingestion_job
bedrockagent_get_ingestion_job <- function(dataSourceId, ingestionJobId, knowledgeBaseId) {
  op <- new_operation(
    name = "GetIngestionJob",
    http_method = "GET",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/{ingestionJobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_ingestion_job_input(dataSourceId = dataSourceId, ingestionJobId = ingestionJobId, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$get_ingestion_job_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_ingestion_job <- bedrockagent_get_ingestion_job

#' Gets information about a knoweldge base
#'
#' @description
#' Gets information about a knoweldge base.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_get_knowledge_base/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base you want to get information
#' on.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_knowledge_base
bedrockagent_get_knowledge_base <- function(knowledgeBaseId) {
  op <- new_operation(
    name = "GetKnowledgeBase",
    http_method = "GET",
    http_path = "/knowledgebases/{knowledgeBaseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_knowledge_base_input(knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$get_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_knowledge_base <- bedrockagent_get_knowledge_base

#' Retrieves specific documents from a data source that is connected to a
#' knowledge base
#'
#' @description
#' Retrieves specific documents from a data source that is connected to a knowledge base. For more information, see [Ingest changes directly into a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_knowledge_base_documents/](https://www.paws-r-sdk.com/docs/bedrockagent_get_knowledge_base_documents/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source that contains the documents.
#' @param documentIdentifiers &#91;required&#93; A list of objects, each of which contains information to identify a
#' document for which to retrieve information.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base that is connected to the
#' data source.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_knowledge_base_documents
bedrockagent_get_knowledge_base_documents <- function(dataSourceId, documentIdentifiers, knowledgeBaseId) {
  op <- new_operation(
    name = "GetKnowledgeBaseDocuments",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents/getDocuments",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_knowledge_base_documents_input(dataSourceId = dataSourceId, documentIdentifiers = documentIdentifiers, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$get_knowledge_base_documents_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_knowledge_base_documents <- bedrockagent_get_knowledge_base_documents

#' Retrieves information about the working draft (DRAFT version) of a
#' prompt or a version of it, depending on whether you include the
#' promptVersion field or not
#'
#' @description
#' Retrieves information about the working draft (`DRAFT` version) of a prompt or a version of it, depending on whether you include the `promptVersion` field or not. For more information, see [View information about prompts using Prompt management](https://docs.aws.amazon.com/bedrock/latest/userguide/#prompt-management-view.html) and [View information about a version of your prompt](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-view.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_get_prompt/](https://www.paws-r-sdk.com/docs/bedrockagent_get_prompt/) for full documentation.
#'
#' @param promptIdentifier &#91;required&#93; The unique identifier of the prompt.
#' @param promptVersion The version of the prompt about which you want to retrieve information.
#' Omit this field to return information about the working draft of the
#' prompt.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_get_prompt
bedrockagent_get_prompt <- function(promptIdentifier, promptVersion = NULL) {
  op <- new_operation(
    name = "GetPrompt",
    http_method = "GET",
    http_path = "/prompts/{promptIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$get_prompt_input(promptIdentifier = promptIdentifier, promptVersion = promptVersion)
  output <- .bedrockagent$get_prompt_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$get_prompt <- bedrockagent_get_prompt

#' Ingests documents directly into the knowledge base that is connected to
#' the data source
#'
#' @description
#' Ingests documents directly into the knowledge base that is connected to the data source. The `dataSourceType` specified in the content for each document must match the type of the data source that you specify in the header. For more information, see [Ingest changes directly into a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_ingest_knowledge_base_documents/](https://www.paws-r-sdk.com/docs/bedrockagent_ingest_knowledge_base_documents/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source connected to the knowledge base
#' that you're adding documents to.
#' @param documents &#91;required&#93; A list of objects, each of which contains information about the
#' documents to add.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to ingest the documents
#' into.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_ingest_knowledge_base_documents
bedrockagent_ingest_knowledge_base_documents <- function(clientToken = NULL, dataSourceId, documents, knowledgeBaseId) {
  op <- new_operation(
    name = "IngestKnowledgeBaseDocuments",
    http_method = "PUT",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$ingest_knowledge_base_documents_input(clientToken = clientToken, dataSourceId = dataSourceId, documents = documents, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$ingest_knowledge_base_documents_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$ingest_knowledge_base_documents <- bedrockagent_ingest_knowledge_base_documents

#' Lists the action groups for an agent and information about each one
#'
#' @description
#' Lists the action groups for an agent and information about each one.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_action_groups/](https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_action_groups/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param agentVersion &#91;required&#93; The version of the agent.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_agent_action_groups
bedrockagent_list_agent_action_groups <- function(agentId, agentVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAgentActionGroups",
    http_method = "POST",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "actionGroupSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_agent_action_groups_input(agentId = agentId, agentVersion = agentVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_agent_action_groups_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_agent_action_groups <- bedrockagent_list_agent_action_groups

#' Lists the aliases of an agent and information about each one
#'
#' @description
#' Lists the aliases of an agent and information about each one.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_aliases/](https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_aliases/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_agent_aliases
bedrockagent_list_agent_aliases <- function(agentId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAgentAliases",
    http_method = "POST",
    http_path = "/agents/{agentId}/agentaliases/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "agentAliasSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_agent_aliases_input(agentId = agentId, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_agent_aliases_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_agent_aliases <- bedrockagent_list_agent_aliases

#' Retrieve a list of an agent's collaborators
#'
#' @description
#' Retrieve a list of an agent's collaborators.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_collaborators/](https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_collaborators/) for full documentation.
#'
#' @param agentId &#91;required&#93; The agent's ID.
#' @param agentVersion &#91;required&#93; The agent's version.
#' @param maxResults The maximum number of agent collaborators to return in one page of
#' results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_agent_collaborators
bedrockagent_list_agent_collaborators <- function(agentId, agentVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAgentCollaborators",
    http_method = "POST",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "agentCollaboratorSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_agent_collaborators_input(agentId = agentId, agentVersion = agentVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_agent_collaborators_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_agent_collaborators <- bedrockagent_list_agent_collaborators

#' Lists knowledge bases associated with an agent and information about
#' each one
#'
#' @description
#' Lists knowledge bases associated with an agent and information about each one.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_knowledge_bases/](https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_knowledge_bases/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent for which to return information about
#' knowledge bases associated with it.
#' @param agentVersion &#91;required&#93; The version of the agent for which to return information about knowledge
#' bases associated with it.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_agent_knowledge_bases
bedrockagent_list_agent_knowledge_bases <- function(agentId, agentVersion, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAgentKnowledgeBases",
    http_method = "POST",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "agentKnowledgeBaseSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_agent_knowledge_bases_input(agentId = agentId, agentVersion = agentVersion, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_agent_knowledge_bases_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_agent_knowledge_bases <- bedrockagent_list_agent_knowledge_bases

#' Lists the versions of an agent and information about each version
#'
#' @description
#' Lists the versions of an agent and information about each version.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_versions/](https://www.paws-r-sdk.com/docs/bedrockagent_list_agent_versions/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_agent_versions
bedrockagent_list_agent_versions <- function(agentId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAgentVersions",
    http_method = "POST",
    http_path = "/agents/{agentId}/agentversions/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "agentVersionSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_agent_versions_input(agentId = agentId, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_agent_versions_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_agent_versions <- bedrockagent_list_agent_versions

#' Lists the agents belonging to an account and information about each
#' agent
#'
#' @description
#' Lists the agents belonging to an account and information about each agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_agents/](https://www.paws-r-sdk.com/docs/bedrockagent_list_agents/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_agents
bedrockagent_list_agents <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAgents",
    http_method = "POST",
    http_path = "/agents/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "agentSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_agents_input(maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_agents_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_agents <- bedrockagent_list_agents

#' Lists the data sources in a knowledge base and information about each
#' one
#'
#' @description
#' Lists the data sources in a knowledge base and information about each one.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_data_sources/](https://www.paws-r-sdk.com/docs/bedrockagent_list_data_sources/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for which to return a list
#' of information.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_data_sources
bedrockagent_list_data_sources <- function(knowledgeBaseId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDataSources",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "dataSourceSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_data_sources_input(knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_data_sources_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_data_sources <- bedrockagent_list_data_sources

#' Returns a list of aliases for a flow
#'
#' @description
#' Returns a list of aliases for a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_flow_aliases/](https://www.paws-r-sdk.com/docs/bedrockagent_list_flow_aliases/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow for which aliases are being returned.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_flow_aliases
bedrockagent_list_flow_aliases <- function(flowIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFlowAliases",
    http_method = "GET",
    http_path = "/flows/{flowIdentifier}/aliases",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "flowAliasSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_flow_aliases_input(flowIdentifier = flowIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_flow_aliases_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_flow_aliases <- bedrockagent_list_flow_aliases

#' Returns a list of information about each flow
#'
#' @description
#' Returns a list of information about each flow. For more information, see [Deploy a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_flow_versions/](https://www.paws-r-sdk.com/docs/bedrockagent_list_flow_versions/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_flow_versions
bedrockagent_list_flow_versions <- function(flowIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFlowVersions",
    http_method = "GET",
    http_path = "/flows/{flowIdentifier}/versions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "flowVersionSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_flow_versions_input(flowIdentifier = flowIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_flow_versions_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_flow_versions <- bedrockagent_list_flow_versions

#' Returns a list of flows and information about each flow
#'
#' @description
#' Returns a list of flows and information about each flow. For more information, see [Manage a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_flows/](https://www.paws-r-sdk.com/docs/bedrockagent_list_flows/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_flows
bedrockagent_list_flows <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFlows",
    http_method = "GET",
    http_path = "/flows/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "flowSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_flows_input(maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_flows_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_flows <- bedrockagent_list_flows

#' Lists the data ingestion jobs for a data source
#'
#' @description
#' Lists the data ingestion jobs for a data source. The list also includes information about each job.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_ingestion_jobs/](https://www.paws-r-sdk.com/docs/bedrockagent_list_ingestion_jobs/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source for the list of data ingestion
#' jobs.
#' @param filters Contains information about the filters for filtering the data.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for the list of data
#' ingestion jobs.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param sortBy Contains details about how to sort the data.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_ingestion_jobs
bedrockagent_list_ingestion_jobs <- function(dataSourceId, filters = NULL, knowledgeBaseId, maxResults = NULL, nextToken = NULL, sortBy = NULL) {
  op <- new_operation(
    name = "ListIngestionJobs",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "ingestionJobSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_ingestion_jobs_input(dataSourceId = dataSourceId, filters = filters, knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy)
  output <- .bedrockagent$list_ingestion_jobs_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_ingestion_jobs <- bedrockagent_list_ingestion_jobs

#' Retrieves all the documents contained in a data source that is connected
#' to a knowledge base
#'
#' @description
#' Retrieves all the documents contained in a data source that is connected to a knowledge base. For more information, see [Ingest changes directly into a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_knowledge_base_documents/](https://www.paws-r-sdk.com/docs/bedrockagent_list_knowledge_base_documents/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source that contains the documents.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base that is connected to the
#' data source.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_knowledge_base_documents
bedrockagent_list_knowledge_base_documents <- function(dataSourceId, knowledgeBaseId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListKnowledgeBaseDocuments",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/documents",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "documentDetails"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_knowledge_base_documents_input(dataSourceId = dataSourceId, knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_knowledge_base_documents_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_knowledge_base_documents <- bedrockagent_list_knowledge_base_documents

#' Lists the knowledge bases in an account
#'
#' @description
#' Lists the knowledge bases in an account. The list also includesinformation about each knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_knowledge_bases/](https://www.paws-r-sdk.com/docs/bedrockagent_list_knowledge_bases/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_knowledge_bases
bedrockagent_list_knowledge_bases <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListKnowledgeBases",
    http_method = "POST",
    http_path = "/knowledgebases/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "knowledgeBaseSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_knowledge_bases_input(maxResults = maxResults, nextToken = nextToken)
  output <- .bedrockagent$list_knowledge_bases_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_knowledge_bases <- bedrockagent_list_knowledge_bases

#' Returns either information about the working draft (DRAFT version) of
#' each prompt in an account, or information about of all versions of a
#' prompt, depending on whether you include the promptIdentifier field or
#' not
#'
#' @description
#' Returns either information about the working draft (`DRAFT` version) of each prompt in an account, or information about of all versions of a prompt, depending on whether you include the `promptIdentifier` field or not. For more information, see [View information about prompts using Prompt management](https://docs.aws.amazon.com/bedrock/latest/userguide/#prompt-management-view.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_prompts/](https://www.paws-r-sdk.com/docs/bedrockagent_list_prompts/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param promptIdentifier The unique identifier of the prompt for whose versions you want to
#' return information. Omit this field to list information about all
#' prompts in an account.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_prompts
bedrockagent_list_prompts <- function(maxResults = NULL, nextToken = NULL, promptIdentifier = NULL) {
  op <- new_operation(
    name = "ListPrompts",
    http_method = "GET",
    http_path = "/prompts/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "promptSummaries"),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_prompts_input(maxResults = maxResults, nextToken = nextToken, promptIdentifier = promptIdentifier)
  output <- .bedrockagent$list_prompts_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_prompts <- bedrockagent_list_prompts

#' List all the tags for the resource you specify
#'
#' @description
#' List all the tags for the resource you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/bedrockagent_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which to list tags.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_list_tags_for_resource
bedrockagent_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .bedrockagent$list_tags_for_resource_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$list_tags_for_resource <- bedrockagent_list_tags_for_resource

#' Creates a DRAFT version of the agent that can be used for internal
#' testing
#'
#' @description
#' Creates a `DRAFT` version of the agent that can be used for internal testing.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_prepare_agent/](https://www.paws-r-sdk.com/docs/bedrockagent_prepare_agent/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent for which to create a `DRAFT`
#' version.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_prepare_agent
bedrockagent_prepare_agent <- function(agentId) {
  op <- new_operation(
    name = "PrepareAgent",
    http_method = "POST",
    http_path = "/agents/{agentId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$prepare_agent_input(agentId = agentId)
  output <- .bedrockagent$prepare_agent_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$prepare_agent <- bedrockagent_prepare_agent

#' Prepares the DRAFT version of a flow so that it can be invoked
#'
#' @description
#' Prepares the `DRAFT` version of a flow so that it can be invoked. For more information, see [Test a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_prepare_flow/](https://www.paws-r-sdk.com/docs/bedrockagent_prepare_flow/) for full documentation.
#'
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_prepare_flow
bedrockagent_prepare_flow <- function(flowIdentifier) {
  op <- new_operation(
    name = "PrepareFlow",
    http_method = "POST",
    http_path = "/flows/{flowIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$prepare_flow_input(flowIdentifier = flowIdentifier)
  output <- .bedrockagent$prepare_flow_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$prepare_flow <- bedrockagent_prepare_flow

#' Begins a data ingestion job
#'
#' @description
#' Begins a data ingestion job. Data sources are ingested into your knowledge base so that Large Language Models (LLMs) can use your data.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_start_ingestion_job/](https://www.paws-r-sdk.com/docs/bedrockagent_start_ingestion_job/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source you want to ingest into your
#' knowledge base.
#' @param description A description of the data ingestion job.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for the data ingestion job.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_start_ingestion_job
bedrockagent_start_ingestion_job <- function(clientToken = NULL, dataSourceId, description = NULL, knowledgeBaseId) {
  op <- new_operation(
    name = "StartIngestionJob",
    http_method = "PUT",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$start_ingestion_job_input(clientToken = clientToken, dataSourceId = dataSourceId, description = description, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$start_ingestion_job_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$start_ingestion_job <- bedrockagent_start_ingestion_job

#' Stops a currently running data ingestion job
#'
#' @description
#' Stops a currently running data ingestion job. You can send a [`start_ingestion_job`][bedrockagent_start_ingestion_job] request again to ingest the rest of your data when you are ready.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_stop_ingestion_job/](https://www.paws-r-sdk.com/docs/bedrockagent_stop_ingestion_job/) for full documentation.
#'
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source for the data ingestion job you
#' want to stop.
#' @param ingestionJobId &#91;required&#93; The unique identifier of the data ingestion job you want to stop.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for the data ingestion job
#' you want to stop.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_stop_ingestion_job
bedrockagent_stop_ingestion_job <- function(dataSourceId, ingestionJobId, knowledgeBaseId) {
  op <- new_operation(
    name = "StopIngestionJob",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/{ingestionJobId}/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$stop_ingestion_job_input(dataSourceId = dataSourceId, ingestionJobId = ingestionJobId, knowledgeBaseId = knowledgeBaseId)
  output <- .bedrockagent$stop_ingestion_job_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$stop_ingestion_job <- bedrockagent_stop_ingestion_job

#' Associate tags with a resource
#'
#' @description
#' Associate tags with a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_tag_resource/](https://www.paws-r-sdk.com/docs/bedrockagent_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to tag.
#' @param tags &#91;required&#93; An object containing key-value pairs that define the tags to attach to
#' the resource.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_tag_resource
bedrockagent_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .bedrockagent$tag_resource_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$tag_resource <- bedrockagent_tag_resource

#' Remove tags from a resource
#'
#' @description
#' Remove tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_untag_resource/](https://www.paws-r-sdk.com/docs/bedrockagent_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to remove
#' tags.
#' @param tagKeys &#91;required&#93; A list of keys of the tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_untag_resource
bedrockagent_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .bedrockagent$untag_resource_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$untag_resource <- bedrockagent_untag_resource

#' Updates the configuration of an agent
#'
#' @description
#' Updates the configuration of an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_agent/](https://www.paws-r-sdk.com/docs/bedrockagent_update_agent/) for full documentation.
#'
#' @param agentCollaboration The agent's collaboration role.
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param agentName &#91;required&#93; Specifies a new name for the agent.
#' @param agentResourceRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role with permissions to
#' invoke API operations on the agent.
#' @param customOrchestration Contains details of the custom orchestration configured for the agent.
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key with which to encrypt the
#' agent.
#' @param description Specifies a new description of the agent.
#' @param foundationModel &#91;required&#93; The identifier for the model that you want to be used for orchestration
#' by the agent you create.
#' 
#' The `modelId` to provide depends on the type of model or throughput that
#' you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an inference profile, specify the inference profile ID or
#'     its ARN. For a list of inference profile IDs, see [Supported Regions
#'     and models for cross-region
#'     inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use an [imported
#'     model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html),
#'     specify the ARN of the imported model. You can get the model ARN
#'     from a successful call to
#'     [CreateModelImportJob](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html)
#'     or from the Imported models page in the Amazon Bedrock console.
#' @param guardrailConfiguration The unique Guardrail configuration assigned to the agent when it is
#' updated.
#' @param idleSessionTTLInSeconds The number of seconds for which Amazon Bedrock keeps information about a
#' user's conversation with the agent.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and Amazon
#' Bedrock deletes any data provided before the timeout.
#' @param instruction Specifies new instructions that tell the agent what it should do and how
#' it should interact with users.
#' @param memoryConfiguration Specifies the new memory configuration for the agent.
#' @param orchestrationType Specifies the type of orchestration strategy for the agent. This is set
#' to `DEFAULT` orchestration type, by default.
#' @param promptOverrideConfiguration Contains configurations to override prompts in different parts of an
#' agent sequence. For more information, see [Advanced
#' prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_agent
bedrockagent_update_agent <- function(agentCollaboration = NULL, agentId, agentName, agentResourceRoleArn, customOrchestration = NULL, customerEncryptionKeyArn = NULL, description = NULL, foundationModel, guardrailConfiguration = NULL, idleSessionTTLInSeconds = NULL, instruction = NULL, memoryConfiguration = NULL, orchestrationType = NULL, promptOverrideConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateAgent",
    http_method = "PUT",
    http_path = "/agents/{agentId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_agent_input(agentCollaboration = agentCollaboration, agentId = agentId, agentName = agentName, agentResourceRoleArn = agentResourceRoleArn, customOrchestration = customOrchestration, customerEncryptionKeyArn = customerEncryptionKeyArn, description = description, foundationModel = foundationModel, guardrailConfiguration = guardrailConfiguration, idleSessionTTLInSeconds = idleSessionTTLInSeconds, instruction = instruction, memoryConfiguration = memoryConfiguration, orchestrationType = orchestrationType, promptOverrideConfiguration = promptOverrideConfiguration)
  output <- .bedrockagent$update_agent_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_agent <- bedrockagent_update_agent

#' Updates the configuration for an action group for an agent
#'
#' @description
#' Updates the configuration for an action group for an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_action_group/](https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_action_group/) for full documentation.
#'
#' @param actionGroupExecutor The Amazon Resource Name (ARN) of the Lambda function containing the
#' business logic that is carried out upon invoking the action.
#' @param actionGroupId &#91;required&#93; The unique identifier of the action group.
#' @param actionGroupName &#91;required&#93; Specifies a new name for the action group.
#' @param actionGroupState Specifies whether the action group is available for the agent to invoke
#' or not when sending an
#' [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
#' request.
#' @param agentId &#91;required&#93; The unique identifier of the agent for which to update the action group.
#' @param agentVersion &#91;required&#93; The unique identifier of the agent version for which to update the
#' action group.
#' @param apiSchema Contains either details about the S3 object containing the OpenAPI
#' schema for the action group or the JSON or YAML-formatted payload
#' defining the schema. For more information, see [Action group OpenAPI
#' schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
#' @param description Specifies a new name for the action group.
#' @param functionSchema Contains details about the function schema for the action group or the
#' JSON or YAML-formatted payload defining the schema.
#' @param parentActionGroupSignature To allow your agent to request the user for additional information when
#' trying to complete a task, set this field to `AMAZON.UserInput`. You
#' must leave the `description`, `apiSchema`, and `actionGroupExecutor`
#' fields blank for this action group.
#' 
#' During orchestration, if your agent determines that it needs to invoke
#' an API in an action group, but doesn't have enough information to
#' complete the API request, it will invoke this action group instead and
#' return an
#' [Observation](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
#' reprompting the user for more information.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_agent_action_group
bedrockagent_update_agent_action_group <- function(actionGroupExecutor = NULL, actionGroupId, actionGroupName, actionGroupState = NULL, agentId, agentVersion, apiSchema = NULL, description = NULL, functionSchema = NULL, parentActionGroupSignature = NULL) {
  op <- new_operation(
    name = "UpdateAgentActionGroup",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_agent_action_group_input(actionGroupExecutor = actionGroupExecutor, actionGroupId = actionGroupId, actionGroupName = actionGroupName, actionGroupState = actionGroupState, agentId = agentId, agentVersion = agentVersion, apiSchema = apiSchema, description = description, functionSchema = functionSchema, parentActionGroupSignature = parentActionGroupSignature)
  output <- .bedrockagent$update_agent_action_group_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_agent_action_group <- bedrockagent_update_agent_action_group

#' Updates configurations for an alias of an agent
#'
#' @description
#' Updates configurations for an alias of an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_alias/) for full documentation.
#'
#' @param agentAliasId &#91;required&#93; The unique identifier of the alias.
#' @param agentAliasName &#91;required&#93; Specifies a new name for the alias.
#' @param agentId &#91;required&#93; The unique identifier of the agent.
#' @param description Specifies a new description for the alias.
#' @param routingConfiguration Contains details about the routing configuration of the alias.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_agent_alias
bedrockagent_update_agent_alias <- function(agentAliasId, agentAliasName, agentId, description = NULL, routingConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateAgentAlias",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentaliases/{agentAliasId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_agent_alias_input(agentAliasId = agentAliasId, agentAliasName = agentAliasName, agentId = agentId, description = description, routingConfiguration = routingConfiguration)
  output <- .bedrockagent$update_agent_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_agent_alias <- bedrockagent_update_agent_alias

#' Updates an agent's collaborator
#'
#' @description
#' Updates an agent's collaborator.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_collaborator/](https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_collaborator/) for full documentation.
#'
#' @param agentDescriptor &#91;required&#93; An agent descriptor for the agent collaborator.
#' @param agentId &#91;required&#93; The agent's ID.
#' @param agentVersion &#91;required&#93; The agent's version.
#' @param collaborationInstruction &#91;required&#93; Instruction for the collaborator.
#' @param collaboratorId &#91;required&#93; The collaborator's ID.
#' @param collaboratorName &#91;required&#93; The collaborator's name.
#' @param relayConversationHistory A relay conversation history for the collaborator.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_agent_collaborator
bedrockagent_update_agent_collaborator <- function(agentDescriptor, agentId, agentVersion, collaborationInstruction, collaboratorId, collaboratorName, relayConversationHistory = NULL) {
  op <- new_operation(
    name = "UpdateAgentCollaborator",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/agentcollaborators/{collaboratorId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_agent_collaborator_input(agentDescriptor = agentDescriptor, agentId = agentId, agentVersion = agentVersion, collaborationInstruction = collaborationInstruction, collaboratorId = collaboratorId, collaboratorName = collaboratorName, relayConversationHistory = relayConversationHistory)
  output <- .bedrockagent$update_agent_collaborator_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_agent_collaborator <- bedrockagent_update_agent_collaborator

#' Updates the configuration for a knowledge base that has been associated
#' with an agent
#'
#' @description
#' Updates the configuration for a knowledge base that has been associated with an agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_knowledge_base/) for full documentation.
#'
#' @param agentId &#91;required&#93; The unique identifier of the agent associated with the knowledge base
#' that you want to update.
#' @param agentVersion &#91;required&#93; The version of the agent associated with the knowledge base that you
#' want to update.
#' @param description Specifies a new description for the knowledge base associated with an
#' agent.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base that has been associated
#' with an agent.
#' @param knowledgeBaseState Specifies whether the agent uses the knowledge base or not when sending
#' an
#' [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
#' request.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_agent_knowledge_base
bedrockagent_update_agent_knowledge_base <- function(agentId, agentVersion, description = NULL, knowledgeBaseId, knowledgeBaseState = NULL) {
  op <- new_operation(
    name = "UpdateAgentKnowledgeBase",
    http_method = "PUT",
    http_path = "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_agent_knowledge_base_input(agentId = agentId, agentVersion = agentVersion, description = description, knowledgeBaseId = knowledgeBaseId, knowledgeBaseState = knowledgeBaseState)
  output <- .bedrockagent$update_agent_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_agent_knowledge_base <- bedrockagent_update_agent_knowledge_base

#' Updates the configurations for a data source connector
#'
#' @description
#' Updates the configurations for a data source connector.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_data_source/](https://www.paws-r-sdk.com/docs/bedrockagent_update_data_source/) for full documentation.
#'
#' @param dataDeletionPolicy The data deletion policy for the data source that you want to update.
#' @param dataSourceConfiguration &#91;required&#93; The connection configuration for the data source that you want to
#' update.
#' @param dataSourceId &#91;required&#93; The unique identifier of the data source.
#' @param description Specifies a new description for the data source.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base for the data source.
#' @param name &#91;required&#93; Specifies a new name for the data source.
#' @param serverSideEncryptionConfiguration Contains details about server-side encryption of the data source.
#' @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_data_source
bedrockagent_update_data_source <- function(dataDeletionPolicy = NULL, dataSourceConfiguration, dataSourceId, description = NULL, knowledgeBaseId, name, serverSideEncryptionConfiguration = NULL, vectorIngestionConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateDataSource",
    http_method = "PUT",
    http_path = "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_data_source_input(dataDeletionPolicy = dataDeletionPolicy, dataSourceConfiguration = dataSourceConfiguration, dataSourceId = dataSourceId, description = description, knowledgeBaseId = knowledgeBaseId, name = name, serverSideEncryptionConfiguration = serverSideEncryptionConfiguration, vectorIngestionConfiguration = vectorIngestionConfiguration)
  output <- .bedrockagent$update_data_source_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_data_source <- bedrockagent_update_data_source

#' Modifies a flow
#'
#' @description
#' Modifies a flow. Include both fields that you want to keep and fields that you want to change. For more information, see [How it works](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html) and [Create a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_flow/](https://www.paws-r-sdk.com/docs/bedrockagent_update_flow/) for full documentation.
#'
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
#' @param definition A definition of the nodes and the connections between the nodes in the
#' flow.
#' @param description A description for the flow.
#' @param executionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the service role with permissions to
#' create and manage a flow. For more information, see [Create a service
#' role for flows in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
#' in the Amazon Bedrock User Guide.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#' @param name &#91;required&#93; A name for the flow.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_flow
bedrockagent_update_flow <- function(customerEncryptionKeyArn = NULL, definition = NULL, description = NULL, executionRoleArn, flowIdentifier, name) {
  op <- new_operation(
    name = "UpdateFlow",
    http_method = "PUT",
    http_path = "/flows/{flowIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_flow_input(customerEncryptionKeyArn = customerEncryptionKeyArn, definition = definition, description = description, executionRoleArn = executionRoleArn, flowIdentifier = flowIdentifier, name = name)
  output <- .bedrockagent$update_flow_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_flow <- bedrockagent_update_flow

#' Modifies the alias of a flow
#'
#' @description
#' Modifies the alias of a flow. Include both fields that you want to keep and ones that you want to change. For more information, see [Deploy a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_flow_alias/](https://www.paws-r-sdk.com/docs/bedrockagent_update_flow_alias/) for full documentation.
#'
#' @param aliasIdentifier &#91;required&#93; The unique identifier of the alias.
#' @param description A description for the alias.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#' @param name &#91;required&#93; The name of the alias.
#' @param routingConfiguration &#91;required&#93; Contains information about the version to which to map the alias.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_flow_alias
bedrockagent_update_flow_alias <- function(aliasIdentifier, description = NULL, flowIdentifier, name, routingConfiguration) {
  op <- new_operation(
    name = "UpdateFlowAlias",
    http_method = "PUT",
    http_path = "/flows/{flowIdentifier}/aliases/{aliasIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_flow_alias_input(aliasIdentifier = aliasIdentifier, description = description, flowIdentifier = flowIdentifier, name = name, routingConfiguration = routingConfiguration)
  output <- .bedrockagent$update_flow_alias_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_flow_alias <- bedrockagent_update_flow_alias

#' Updates the configuration of a knowledge base with the fields that you
#' specify
#'
#' @description
#' Updates the configuration of a knowledge base with the fields that you specify. Because all fields will be overwritten, you must include the same values for fields that you want to keep the same.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_knowledge_base/](https://www.paws-r-sdk.com/docs/bedrockagent_update_knowledge_base/) for full documentation.
#'
#' @param description Specifies a new description for the knowledge base.
#' @param knowledgeBaseConfiguration &#91;required&#93; Specifies the configuration for the embeddings model used for the
#' knowledge base. You must use the same configuration as when the
#' knowledge base was created.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to update.
#' @param name &#91;required&#93; Specifies a new name for the knowledge base.
#' @param roleArn &#91;required&#93; Specifies a different Amazon Resource Name (ARN) of the IAM role with
#' permissions to invoke API operations on the knowledge base.
#' @param storageConfiguration Specifies the configuration for the vector store used for the knowledge
#' base. You must use the same configuration as when the knowledge base was
#' created.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_knowledge_base
bedrockagent_update_knowledge_base <- function(description = NULL, knowledgeBaseConfiguration, knowledgeBaseId, name, roleArn, storageConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateKnowledgeBase",
    http_method = "PUT",
    http_path = "/knowledgebases/{knowledgeBaseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_knowledge_base_input(description = description, knowledgeBaseConfiguration = knowledgeBaseConfiguration, knowledgeBaseId = knowledgeBaseId, name = name, roleArn = roleArn, storageConfiguration = storageConfiguration)
  output <- .bedrockagent$update_knowledge_base_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_knowledge_base <- bedrockagent_update_knowledge_base

#' Modifies a prompt in your prompt library
#'
#' @description
#' Modifies a prompt in your prompt library. Include both fields that you want to keep and fields that you want to replace. For more information, see [Prompt management in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html) and [Edit prompts in your prompt library](https://docs.aws.amazon.com/bedrock/latest/userguide/#prompt-management-edit) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_update_prompt/](https://www.paws-r-sdk.com/docs/bedrockagent_update_prompt/) for full documentation.
#'
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
#' @param defaultVariant The name of the default variant for the prompt. This value must match
#' the `name` field in the relevant
#' [PromptVariant](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
#' object.
#' @param description A description for the prompt.
#' @param name &#91;required&#93; A name for the prompt.
#' @param promptIdentifier &#91;required&#93; The unique identifier of the prompt.
#' @param variants A list of objects, each containing details about a variant of the
#' prompt.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_update_prompt
bedrockagent_update_prompt <- function(customerEncryptionKeyArn = NULL, defaultVariant = NULL, description = NULL, name, promptIdentifier, variants = NULL) {
  op <- new_operation(
    name = "UpdatePrompt",
    http_method = "PUT",
    http_path = "/prompts/{promptIdentifier}/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$update_prompt_input(customerEncryptionKeyArn = customerEncryptionKeyArn, defaultVariant = defaultVariant, description = description, name = name, promptIdentifier = promptIdentifier, variants = variants)
  output <- .bedrockagent$update_prompt_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$update_prompt <- bedrockagent_update_prompt

#' Validates the definition of a flow
#'
#' @description
#' Validates the definition of a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagent_validate_flow_definition/](https://www.paws-r-sdk.com/docs/bedrockagent_validate_flow_definition/) for full documentation.
#'
#' @param definition &#91;required&#93; The definition of a flow to validate.
#'
#' @keywords internal
#'
#' @rdname bedrockagent_validate_flow_definition
bedrockagent_validate_flow_definition <- function(definition) {
  op <- new_operation(
    name = "ValidateFlowDefinition",
    http_method = "POST",
    http_path = "/flows/validate-definition",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagent$validate_flow_definition_input(definition = definition)
  output <- .bedrockagent$validate_flow_definition_output()
  config <- get_config()
  svc <- .bedrockagent$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagent$operations$validate_flow_definition <- bedrockagent_validate_flow_definition
