# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include translate_service.R
NULL

#' Creates a parallel data resource in Amazon Translate by importing an
#' input file from Amazon S3
#'
#' @description
#' Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data files contain examples that show how you want segments of text to be translated. By adding parallel data, you can influence the style, tone, and word choice in your translation output.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_create_parallel_data/](https://www.paws-r-sdk.com/docs/translate_create_parallel_data/) for full documentation.
#'
#' @param Name &#91;required&#93; A custom name for the parallel data resource in Amazon Translate. You
#' must assign a name that is unique in the account and region.
#' @param Description A custom description for the parallel data resource in Amazon Translate.
#' @param ParallelDataConfig &#91;required&#93; Specifies the format and S3 location of the parallel data input file.
#' @param EncryptionKey 
#' @param ClientToken &#91;required&#93; A unique identifier for the request. This token is automatically
#' generated when you use Amazon Translate through an AWS SDK.
#' @param Tags Tags to be associated with this resource. A tag is a key-value pair that
#' adds metadata to a resource. Each tag key for the resource must be
#' unique. For more information, see [Tagging your
#' resources](https://docs.aws.amazon.com/translate/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname translate_create_parallel_data
translate_create_parallel_data <- function(Name, Description = NULL, ParallelDataConfig, EncryptionKey = NULL, ClientToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateParallelData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$create_parallel_data_input(Name = Name, Description = Description, ParallelDataConfig = ParallelDataConfig, EncryptionKey = EncryptionKey, ClientToken = ClientToken, Tags = Tags)
  output <- .translate$create_parallel_data_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$create_parallel_data <- translate_create_parallel_data

#' Deletes a parallel data resource in Amazon Translate
#'
#' @description
#' Deletes a parallel data resource in Amazon Translate.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_delete_parallel_data/](https://www.paws-r-sdk.com/docs/translate_delete_parallel_data/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parallel data resource that is being deleted.
#'
#' @keywords internal
#'
#' @rdname translate_delete_parallel_data
translate_delete_parallel_data <- function(Name) {
  op <- new_operation(
    name = "DeleteParallelData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$delete_parallel_data_input(Name = Name)
  output <- .translate$delete_parallel_data_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$delete_parallel_data <- translate_delete_parallel_data

#' A synchronous action that deletes a custom terminology
#'
#' @description
#' A synchronous action that deletes a custom terminology.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_delete_terminology/](https://www.paws-r-sdk.com/docs/translate_delete_terminology/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom terminology being deleted.
#'
#' @keywords internal
#'
#' @rdname translate_delete_terminology
translate_delete_terminology <- function(Name) {
  op <- new_operation(
    name = "DeleteTerminology",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$delete_terminology_input(Name = Name)
  output <- .translate$delete_terminology_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$delete_terminology <- translate_delete_terminology

#' Gets the properties associated with an asynchronous batch translation
#' job including name, ID, status, source and target languages,
#' input/output S3 buckets, and so on
#'
#' @description
#' Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_describe_text_translation_job/](https://www.paws-r-sdk.com/docs/translate_describe_text_translation_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Translate generated for the job. The
#' [`start_text_translation_job`][translate_start_text_translation_job]
#' operation returns this identifier in its response.
#'
#' @keywords internal
#'
#' @rdname translate_describe_text_translation_job
translate_describe_text_translation_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeTextTranslationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$describe_text_translation_job_input(JobId = JobId)
  output <- .translate$describe_text_translation_job_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$describe_text_translation_job <- translate_describe_text_translation_job

#' Provides information about a parallel data resource
#'
#' @description
#' Provides information about a parallel data resource.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_get_parallel_data/](https://www.paws-r-sdk.com/docs/translate_get_parallel_data/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parallel data resource that is being retrieved.
#'
#' @keywords internal
#'
#' @rdname translate_get_parallel_data
translate_get_parallel_data <- function(Name) {
  op <- new_operation(
    name = "GetParallelData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$get_parallel_data_input(Name = Name)
  output <- .translate$get_parallel_data_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$get_parallel_data <- translate_get_parallel_data

#' Retrieves a custom terminology
#'
#' @description
#' Retrieves a custom terminology.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_get_terminology/](https://www.paws-r-sdk.com/docs/translate_get_terminology/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom terminology being retrieved.
#' @param TerminologyDataFormat The data format of the custom terminology being retrieved.
#' 
#' If you don't specify this parameter, Amazon Translate returns a file
#' with the same format as the file that was imported to create the
#' terminology.
#' 
#' If you specify this parameter when you retrieve a multi-directional
#' terminology resource, you must specify the same format as the input file
#' that was imported to create it. Otherwise, Amazon Translate throws an
#' error.
#'
#' @keywords internal
#'
#' @rdname translate_get_terminology
translate_get_terminology <- function(Name, TerminologyDataFormat = NULL) {
  op <- new_operation(
    name = "GetTerminology",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$get_terminology_input(Name = Name, TerminologyDataFormat = TerminologyDataFormat)
  output <- .translate$get_terminology_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$get_terminology <- translate_get_terminology

#' Creates or updates a custom terminology, depending on whether one
#' already exists for the given terminology name
#'
#' @description
#' Creates or updates a custom terminology, depending on whether one already exists for the given terminology name. Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen merge strategy. The only supported merge strategy is OVERWRITE, where the imported terminology overwrites the existing terminology of the same name.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_import_terminology/](https://www.paws-r-sdk.com/docs/translate_import_terminology/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom terminology being imported.
#' @param MergeStrategy &#91;required&#93; The merge strategy of the custom terminology being imported. Currently,
#' only the OVERWRITE merge strategy is supported. In this case, the
#' imported terminology will overwrite an existing terminology of the same
#' name.
#' @param Description The description of the custom terminology being imported.
#' @param TerminologyData &#91;required&#93; The terminology data for the custom terminology being imported.
#' @param EncryptionKey The encryption key for the custom terminology being imported.
#' @param Tags Tags to be associated with this resource. A tag is a key-value pair that
#' adds metadata to a resource. Each tag key for the resource must be
#' unique. For more information, see [Tagging your
#' resources](https://docs.aws.amazon.com/translate/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname translate_import_terminology
translate_import_terminology <- function(Name, MergeStrategy, Description = NULL, TerminologyData, EncryptionKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ImportTerminology",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$import_terminology_input(Name = Name, MergeStrategy = MergeStrategy, Description = Description, TerminologyData = TerminologyData, EncryptionKey = EncryptionKey, Tags = Tags)
  output <- .translate$import_terminology_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$import_terminology <- translate_import_terminology

#' Provides a list of languages (RFC-5646 codes and names) that Amazon
#' Translate supports
#'
#' @description
#' Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_list_languages/](https://www.paws-r-sdk.com/docs/translate_list_languages/) for full documentation.
#'
#' @param DisplayLanguageCode The language code for the language to use to display the language names
#' in the response. The language code is `en` by default.
#' @param NextToken Include the NextToken value to fetch the next group of supported
#' languages.
#' @param MaxResults The maximum number of results to return in each response.
#'
#' @keywords internal
#'
#' @rdname translate_list_languages
translate_list_languages <- function(DisplayLanguageCode = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLanguages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .translate$list_languages_input(DisplayLanguageCode = DisplayLanguageCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .translate$list_languages_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$list_languages <- translate_list_languages

#' Provides a list of your parallel data resources in Amazon Translate
#'
#' @description
#' Provides a list of your parallel data resources in Amazon Translate.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_list_parallel_data/](https://www.paws-r-sdk.com/docs/translate_list_parallel_data/) for full documentation.
#'
#' @param NextToken A string that specifies the next page of results to return in a
#' paginated response.
#' @param MaxResults The maximum number of parallel data resources returned for each request.
#'
#' @keywords internal
#'
#' @rdname translate_list_parallel_data
translate_list_parallel_data <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListParallelData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .translate$list_parallel_data_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .translate$list_parallel_data_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$list_parallel_data <- translate_list_parallel_data

#' Lists all tags associated with a given Amazon Translate resource
#'
#' @description
#' Lists all tags associated with a given Amazon Translate resource. For more information, see [Tagging your resources](https://docs.aws.amazon.com/translate/latest/dg/tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/translate_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/translate_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the given Amazon Translate resource
#' you are querying.
#'
#' @keywords internal
#'
#' @rdname translate_list_tags_for_resource
translate_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .translate$list_tags_for_resource_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$list_tags_for_resource <- translate_list_tags_for_resource

#' Provides a list of custom terminologies associated with your account
#'
#' @description
#' Provides a list of custom terminologies associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_list_terminologies/](https://www.paws-r-sdk.com/docs/translate_list_terminologies/) for full documentation.
#'
#' @param NextToken If the result of the request to ListTerminologies was truncated, include
#' the NextToken to fetch the next group of custom terminologies.
#' @param MaxResults The maximum number of custom terminologies returned per list request.
#'
#' @keywords internal
#'
#' @rdname translate_list_terminologies
translate_list_terminologies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTerminologies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TerminologyPropertiesList"),
    stream_api = FALSE
  )
  input <- .translate$list_terminologies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .translate$list_terminologies_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$list_terminologies <- translate_list_terminologies

#' Gets a list of the batch translation jobs that you have submitted
#'
#' @description
#' Gets a list of the batch translation jobs that you have submitted.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_list_text_translation_jobs/](https://www.paws-r-sdk.com/docs/translate_list_text_translation_jobs/) for full documentation.
#'
#' @param Filter The parameters that specify which batch translation jobs to retrieve.
#' Filters include job name, job status, and submission time. You can only
#' set one filter at a time.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in each page. The default value
#' is 100.
#'
#' @keywords internal
#'
#' @rdname translate_list_text_translation_jobs
translate_list_text_translation_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTextTranslationJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .translate$list_text_translation_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .translate$list_text_translation_jobs_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$list_text_translation_jobs <- translate_list_text_translation_jobs

#' Starts an asynchronous batch translation job
#'
#' @description
#' Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text across multiple documents at once. For batch translation, you can input documents with different source languages (specify `auto` as the source language). You can specify one or more target languages. Batch translation translates each input document into each of the target languages. For more information, see [Asynchronous batch processing](https://docs.aws.amazon.com/translate/latest/dg/async.html).
#'
#' See [https://www.paws-r-sdk.com/docs/translate_start_text_translation_job/](https://www.paws-r-sdk.com/docs/translate_start_text_translation_job/) for full documentation.
#'
#' @param JobName The name of the batch translation job to be performed.
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input documents for the
#' translation job.
#' @param OutputDataConfig &#91;required&#93; Specifies the S3 folder to which your job output will be saved.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an AWS Identity Access and Management
#' (IAM) role that grants Amazon Translate read access to your input data.
#' For more information, see [Identity and access
#' management](https://docs.aws.amazon.com/translate/latest/dg/) .
#' @param SourceLanguageCode &#91;required&#93; The language code of the input language. Specify the language if all
#' input documents share the same language. If you don't know the language
#' of the source files, or your input documents contains different source
#' languages, select `auto`. Amazon Translate auto detects the source
#' language for each input document. For a list of supported language
#' codes, see [Supported
#' languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#' @param TargetLanguageCodes &#91;required&#93; The target languages of the translation job. Enter up to 10 language
#' codes. Each input file is translated into each target language.
#' 
#' Each language code is 2 or 5 characters long. For a list of language
#' codes, see [Supported
#' languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#' @param TerminologyNames The name of a custom terminology resource to add to the translation job.
#' This resource lists examples source terms and the desired translation
#' for each term.
#' 
#' This parameter accepts only one custom terminology resource.
#' 
#' If you specify multiple target languages for the job, translate uses the
#' designated terminology for each requested target language that has an
#' entry for the source term in the terminology file.
#' 
#' For a list of available custom terminology resources, use the
#' [`list_terminologies`][translate_list_terminologies] operation.
#' 
#' For more information, see [Custom
#' terminology](https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html).
#' @param ParallelDataNames The name of a parallel data resource to add to the translation job. This
#' resource consists of examples that show how you want segments of text to
#' be translated. If you specify multiple target languages for the job, the
#' parallel data file must include translations for all the target
#' languages.
#' 
#' When you add parallel data to a translation job, you create an *Active
#' Custom Translation* job.
#' 
#' This parameter accepts only one parallel data resource.
#' 
#' Active Custom Translation jobs are priced at a higher rate than other
#' jobs that don't use parallel data. For more information, see [Amazon
#' Translate pricing](https://aws.amazon.com/translate/pricing/).
#' 
#' For a list of available parallel data resources, use the
#' [`list_parallel_data`][translate_list_parallel_data] operation.
#' 
#' For more information, see [Customizing your translations with parallel
#' data](https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html).
#' @param ClientToken &#91;required&#93; A unique identifier for the request. This token is generated for you
#' when using the Amazon Translate SDK.
#' @param Settings Settings to configure your translation output. You can configure the
#' following options:
#' 
#' -   Brevity: not supported.
#' 
#' -   Formality: sets the formality level of the output text.
#' 
#' -   Profanity: masks profane words and phrases in your translation
#'     output.
#'
#' @keywords internal
#'
#' @rdname translate_start_text_translation_job
translate_start_text_translation_job <- function(JobName = NULL, InputDataConfig, OutputDataConfig, DataAccessRoleArn, SourceLanguageCode, TargetLanguageCodes, TerminologyNames = NULL, ParallelDataNames = NULL, ClientToken, Settings = NULL) {
  op <- new_operation(
    name = "StartTextTranslationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$start_text_translation_job_input(JobName = JobName, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, SourceLanguageCode = SourceLanguageCode, TargetLanguageCodes = TargetLanguageCodes, TerminologyNames = TerminologyNames, ParallelDataNames = ParallelDataNames, ClientToken = ClientToken, Settings = Settings)
  output <- .translate$start_text_translation_job_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$start_text_translation_job <- translate_start_text_translation_job

#' Stops an asynchronous batch translation job that is in progress
#'
#' @description
#' Stops an asynchronous batch translation job that is in progress.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_stop_text_translation_job/](https://www.paws-r-sdk.com/docs/translate_stop_text_translation_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The job ID of the job to be stopped.
#'
#' @keywords internal
#'
#' @rdname translate_stop_text_translation_job
translate_stop_text_translation_job <- function(JobId) {
  op <- new_operation(
    name = "StopTextTranslationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$stop_text_translation_job_input(JobId = JobId)
  output <- .translate$stop_text_translation_job_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$stop_text_translation_job <- translate_stop_text_translation_job

#' Associates a specific tag with a resource
#'
#' @description
#' Associates a specific tag with a resource. A tag is a key-value pair that adds as a metadata to a resource. For more information, see [Tagging your resources](https://docs.aws.amazon.com/translate/latest/dg/tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/translate_tag_resource/](https://www.paws-r-sdk.com/docs/translate_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the given Amazon Translate resource to
#' which you want to associate the tags.
#' @param Tags &#91;required&#93; Tags being associated with a specific Amazon Translate resource. There
#' can be a maximum of 50 tags (both existing and pending) associated with
#' a specific resource.
#'
#' @keywords internal
#'
#' @rdname translate_tag_resource
translate_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .translate$tag_resource_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$tag_resource <- translate_tag_resource

#' Translates the input document from the source language to the target
#' language
#'
#' @description
#' Translates the input document from the source language to the target language. This synchronous operation supports text, HTML, or Word documents as the input document. [`translate_document`][translate_translate_document] supports translations from English to any supported language, and from any supported language to English. Therefore, specify either the source language code or the target language code as “en” (English).
#'
#' See [https://www.paws-r-sdk.com/docs/translate_translate_document/](https://www.paws-r-sdk.com/docs/translate_translate_document/) for full documentation.
#'
#' @param Document &#91;required&#93; The content and content type for the document to be translated. The
#' document size must not exceed 100 KB.
#' @param TerminologyNames The name of a terminology list file to add to the translation job. This
#' file provides source terms and the desired translation for each term. A
#' terminology list can contain a maximum of 256 terms. You can use one
#' custom terminology resource in your translation request.
#' 
#' Use the [`list_terminologies`][translate_list_terminologies] operation
#' to get the available terminology lists.
#' 
#' For more information about custom terminology lists, see [Custom
#' terminology](https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html).
#' @param SourceLanguageCode &#91;required&#93; The language code for the language of the source text. For a list of
#' supported language codes, see [Supported
#' languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#' 
#' To have Amazon Translate determine the source language of your text, you
#' can specify `auto` in the `SourceLanguageCode` field. If you specify
#' `auto`, Amazon Translate will call [Amazon
#' Comprehend](https://docs.aws.amazon.com/comprehend/latest/dg/what-is.html)
#' to determine the source language.
#' 
#' If you specify `auto`, you must send the
#' [`translate_document`][translate_translate_document] request in a region
#' that supports Amazon Comprehend. Otherwise, the request returns an error
#' indicating that autodetect is not supported.
#' @param TargetLanguageCode &#91;required&#93; The language code requested for the translated document. For a list of
#' supported language codes, see [Supported
#' languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#' @param Settings Settings to configure your translation output. You can configure the
#' following options:
#' 
#' -   Brevity: not supported.
#' 
#' -   Formality: sets the formality level of the output text.
#' 
#' -   Profanity: masks profane words and phrases in your translation
#'     output.
#'
#' @keywords internal
#'
#' @rdname translate_translate_document
translate_translate_document <- function(Document, TerminologyNames = NULL, SourceLanguageCode, TargetLanguageCode, Settings = NULL) {
  op <- new_operation(
    name = "TranslateDocument",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$translate_document_input(Document = Document, TerminologyNames = TerminologyNames, SourceLanguageCode = SourceLanguageCode, TargetLanguageCode = TargetLanguageCode, Settings = Settings)
  output <- .translate$translate_document_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$translate_document <- translate_translate_document

#' Translates input text from the source language to the target language
#'
#' @description
#' Translates input text from the source language to the target language. For a list of available languages and language codes, see [Supported languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/translate_translate_text/](https://www.paws-r-sdk.com/docs/translate_translate_text/) for full documentation.
#'
#' @param Text &#91;required&#93; The text to translate. The text string can be a maximum of 10,000 bytes
#' long. Depending on your character set, this may be fewer than 10,000
#' characters.
#' @param TerminologyNames The name of a terminology list file to add to the translation job. This
#' file provides source terms and the desired translation for each term. A
#' terminology list can contain a maximum of 256 terms. You can use one
#' custom terminology resource in your translation request.
#' 
#' Use the [`list_terminologies`][translate_list_terminologies] operation
#' to get the available terminology lists.
#' 
#' For more information about custom terminology lists, see [Custom
#' terminology](https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html).
#' @param SourceLanguageCode &#91;required&#93; The language code for the language of the source text. For a list of
#' language codes, see [Supported
#' languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#' 
#' To have Amazon Translate determine the source language of your text, you
#' can specify `auto` in the `SourceLanguageCode` field. If you specify
#' `auto`, Amazon Translate will call [Amazon
#' Comprehend](https://docs.aws.amazon.com/comprehend/latest/dg/what-is.html)
#' to determine the source language.
#' 
#' If you specify `auto`, you must send the
#' [`translate_text`][translate_translate_text] request in a region that
#' supports Amazon Comprehend. Otherwise, the request returns an error
#' indicating that autodetect is not supported.
#' @param TargetLanguageCode &#91;required&#93; The language code requested for the language of the target text. For a
#' list of language codes, see [Supported
#' languages](https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html).
#' @param Settings Settings to configure your translation output. You can configure the
#' following options:
#' 
#' -   Brevity: reduces the length of the translated output for most
#'     translations.
#' 
#' -   Formality: sets the formality level of the output text.
#' 
#' -   Profanity: masks profane words and phrases in your translation
#'     output.
#'
#' @keywords internal
#'
#' @rdname translate_translate_text
translate_translate_text <- function(Text, TerminologyNames = NULL, SourceLanguageCode, TargetLanguageCode, Settings = NULL) {
  op <- new_operation(
    name = "TranslateText",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$translate_text_input(Text = Text, TerminologyNames = TerminologyNames, SourceLanguageCode = SourceLanguageCode, TargetLanguageCode = TargetLanguageCode, Settings = Settings)
  output <- .translate$translate_text_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$translate_text <- translate_translate_text

#' Removes a specific tag associated with an Amazon Translate resource
#'
#' @description
#' Removes a specific tag associated with an Amazon Translate resource. For more information, see [Tagging your resources](https://docs.aws.amazon.com/translate/latest/dg/tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/translate_untag_resource/](https://www.paws-r-sdk.com/docs/translate_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the given Amazon Translate resource
#' from which you want to remove the tags.
#' @param TagKeys &#91;required&#93; The initial part of a key-value pair that forms a tag being removed from
#' a given resource. Keys must be unique and cannot be duplicated for a
#' particular resource.
#'
#' @keywords internal
#'
#' @rdname translate_untag_resource
translate_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .translate$untag_resource_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$untag_resource <- translate_untag_resource

#' Updates a previously created parallel data resource by importing a new
#' input file from Amazon S3
#'
#' @description
#' Updates a previously created parallel data resource by importing a new input file from Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/translate_update_parallel_data/](https://www.paws-r-sdk.com/docs/translate_update_parallel_data/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parallel data resource being updated.
#' @param Description A custom description for the parallel data resource in Amazon Translate.
#' @param ParallelDataConfig &#91;required&#93; Specifies the format and S3 location of the parallel data input file.
#' @param ClientToken &#91;required&#93; A unique identifier for the request. This token is automatically
#' generated when you use Amazon Translate through an AWS SDK.
#'
#' @keywords internal
#'
#' @rdname translate_update_parallel_data
translate_update_parallel_data <- function(Name, Description = NULL, ParallelDataConfig, ClientToken) {
  op <- new_operation(
    name = "UpdateParallelData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .translate$update_parallel_data_input(Name = Name, Description = Description, ParallelDataConfig = ParallelDataConfig, ClientToken = ClientToken)
  output <- .translate$update_parallel_data_output()
  config <- get_config()
  svc <- .translate$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$update_parallel_data <- translate_update_parallel_data
