% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_tag_resource}
\alias{forecastservice_tag_resource}
\title{Associates the specified tags to a resource with the specified
resourceArn}
\usage{
forecastservice_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource for which to
list the tags.}

\item{Tags}{[required] The tags to add to the resource. A tag is an array of key-value pairs.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for keys as it is reserved for Amazon Web Services
use. You cannot edit or delete tag keys with this prefix. Values can
have this prefix. If a tag value has \code{aws} as its prefix but the key
does not, then Forecast considers it to be a user tag and will count
against the limit of 50 tags. Tags with only the key prefix of \code{aws}
do not count against your tags per resource limit.
}}
}
\description{
Associates the specified tags to a resource with the specified \code{resourceArn}. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.

See \url{https://www.paws-r-sdk.com/docs/forecastservice_tag_resource/} for full documentation.
}
\keyword{internal}
