% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_metric_attribution}
\alias{personalize_create_metric_attribution}
\title{Creates a metric attribution}
\usage{
personalize_create_metric_attribution(
  name,
  datasetGroupArn,
  metrics,
  metricsOutputConfig
)
}
\arguments{
\item{name}{[required] A name for the metric attribution.}

\item{datasetGroupArn}{[required] The Amazon Resource Name (ARN) of the destination dataset group for the
metric attribution.}

\item{metrics}{[required] A list of metric attributes for the metric attribution. Each metric
attribute specifies an event type to track and a function. Available
functions are \code{SUM()} or \code{SAMPLECOUNT()}. For SUM() functions, provide
the dataset type (either Interactions or Items) and column to sum as a
parameter. For example SUM(Items.PRICE).}

\item{metricsOutputConfig}{[required] The output configuration details for the metric attribution.}
}
\description{
Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see \href{https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html}{Measuring impact of recommendations}.

See \url{https://www.paws-r-sdk.com/docs/personalize_create_metric_attribution/} for full documentation.
}
\keyword{internal}
