% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_disassociate_faces}
\alias{rekognition_disassociate_faces}
\title{Removes the association between a Face supplied in an array of FaceIds
and the User}
\usage{
rekognition_disassociate_faces(
  CollectionId,
  UserId,
  ClientRequestToken = NULL,
  FaceIds
)
}
\arguments{
\item{CollectionId}{[required] The ID of an existing collection containing the UserID.}

\item{UserId}{[required] ID for the existing UserID.}

\item{ClientRequestToken}{Idempotent token used to identify the request to
\code{\link[=rekognition_disassociate_faces]{disassociate_faces}}. If you use the
same token with multiple
\code{\link[=rekognition_disassociate_faces]{disassociate_faces}} requests, the
same response is returned. Use ClientRequestToken to prevent the same
request from being processed more than once.}

\item{FaceIds}{[required] An array of face IDs to disassociate from the UserID.}
}
\description{
Removes the association between a \code{Face} supplied in an array of \code{FaceIds} and the User. If the User is not present already, then a \code{ResourceNotFound} exception is thrown. If successful, an array of faces that are disassociated from the User is returned. If a given face is already disassociated from the given UserID, it will be ignored and not be returned in the response. If a given face is already associated with a different User or not found in the collection it will be returned as part of \code{UnsuccessfulDisassociations}. You can remove 1 - 100 face IDs from a user at one time.

See \url{https://www.paws-r-sdk.com/docs/rekognition_disassociate_faces/} for full documentation.
}
\keyword{internal}
