% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_model_quality_job_definition}
\alias{sagemaker_create_model_quality_job_definition}
\title{Creates a definition for a job that monitors model quality and drift}
\usage{
sagemaker_create_model_quality_job_definition(
  JobDefinitionName,
  ModelQualityBaselineConfig = NULL,
  ModelQualityAppSpecification,
  ModelQualityJobInput,
  ModelQualityJobOutputConfig,
  JobResources,
  NetworkConfig = NULL,
  RoleArn,
  StoppingCondition = NULL,
  Tags = NULL
)
}
\arguments{
\item{JobDefinitionName}{[required] The name of the monitoring job definition.}

\item{ModelQualityBaselineConfig}{Specifies the constraints and baselines for the monitoring job.}

\item{ModelQualityAppSpecification}{[required] The container that runs the monitoring job.}

\item{ModelQualityJobInput}{[required] A list of the inputs that are monitored. Currently endpoints are
supported.}

\item{ModelQualityJobOutputConfig}{[required]}

\item{JobResources}{[required]}

\item{NetworkConfig}{Specifies the network configuration for the monitoring job.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
can assume to perform tasks on your behalf.}

\item{StoppingCondition}{}

\item{Tags}{(Optional) An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL}{Using Cost Allocation Tags}
in the \emph{Amazon Web Services Billing and Cost Management User Guide}.}
}
\description{
Creates a definition for a job that monitors model quality and drift. For information about model monitor, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html}{Amazon SageMaker AI Model Monitor}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_model_quality_job_definition/} for full documentation.
}
\keyword{internal}
