% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_labeling_jobs_for_workteam}
\alias{sagemaker_list_labeling_jobs_for_workteam}
\title{Gets a list of labeling jobs assigned to a specified work team}
\usage{
sagemaker_list_labeling_jobs_for_workteam(
  WorkteamArn,
  MaxResults = NULL,
  NextToken = NULL,
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  JobReferenceCodeContains = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{WorkteamArn}{[required] The Amazon Resource Name (ARN) of the work team for which you want to
see labeling jobs for.}

\item{MaxResults}{The maximum number of labeling jobs to return in each page of the
response.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_labeling_jobs_for_workteam]{list_labeling_jobs_for_workteam}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of labeling jobs, use the token in the next request.}

\item{CreationTimeAfter}{A filter that returns only labeling jobs created after the specified
time (timestamp).}

\item{CreationTimeBefore}{A filter that returns only labeling jobs created before the specified
time (timestamp).}

\item{JobReferenceCodeContains}{A filter the limits jobs to only the ones whose job reference code
contains the specified string.}

\item{SortBy}{The field to sort results by. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\description{
Gets a list of labeling jobs assigned to a specified work team.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_labeling_jobs_for_workteam/} for full documentation.
}
\keyword{internal}
