% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_create_project}
\alias{cloudwatchevidently_create_project}
\title{Creates a project, which is the logical object in Evidently that can
contain features, launches, and experiments}
\usage{
cloudwatchevidently_create_project(
  appConfigResource = NULL,
  dataDelivery = NULL,
  description = NULL,
  name,
  tags = NULL
)
}
\arguments{
\item{appConfigResource}{Use this parameter if the project will use \emph{client-side evaluation
powered by AppConfig}. Client-side evaluation allows your application to
assign variations to user sessions locally instead of by calling the
\code{\link[=cloudwatchevidently_evaluate_feature]{evaluate_feature}} operation.
This mitigates the latency and availability risks that come with an API
call. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html}{Client-side evaluation - powered by AppConfig.}

This parameter is a structure that contains information about the
AppConfig application and environment that will be used as for
client-side evaluation.

To create a project that uses client-side evaluation, you must have the
\code{evidently:ExportProjectAsConfiguration} permission.}

\item{dataDelivery}{A structure that contains information about where Evidently is to store
evaluation events for longer term storage, if you choose to do so. If
you choose not to store these events, Evidently deletes them after using
them to produce metrics and other experiment results that you can view.}

\item{description}{An optional description of the project.}

\item{name}{[required] The name for the project.}

\item{tags}{Assigns one or more tags (key-value pairs) to the project.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

Tags don't have any semantic meaning to Amazon Web Services and are
interpreted strictly as strings of characters.

You can associate as many as 50 tags with a project.

For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}.}
}
\description{
Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_project/} for full documentation.
}
\keyword{internal}
