% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_delivery_source}
\alias{cloudwatchlogs_put_delivery_source}
\title{Creates or updates a logical delivery source}
\usage{
cloudwatchlogs_put_delivery_source(name, resourceArn, logType, tags = NULL)
}
\arguments{
\item{name}{[required] A name for this delivery source. This name must be unique for all
delivery sources in your account.}

\item{resourceArn}{[required] The ARN of the Amazon Web Services resource that is generating and
sending logs. For example,
\verb{arn:aws:workmail:us-east-1:123456789012:organization/m-1234EXAMPLEabcd1234abcd1234abcd1234}}

\item{logType}{[required] Defines the type of log that the source is sending.
\itemize{
\item For Amazon Bedrock, the valid value is \code{APPLICATION_LOGS}.
\item For CloudFront, the valid value is \code{ACCESS_LOGS}.
\item For Amazon CodeWhisperer, the valid value is \code{EVENT_LOGS}.
\item For Elemental MediaPackage, the valid values are
\code{EGRESS_ACCESS_LOGS} and \code{INGRESS_ACCESS_LOGS}.
\item For Elemental MediaTailor, the valid values are
\code{AD_DECISION_SERVER_LOGS}, \code{MANIFEST_SERVICE_LOGS}, and
\code{TRANSCODE_LOGS}.
\item For IAM Identity Center, the valid value is \code{ERROR_LOGS}.
\item For Amazon Q, the valid value is \code{EVENT_LOGS}.
\item For Amazon SES mail manager, the valid value is \code{APPLICATION_LOG}.
\item For Amazon WorkMail, the valid values are \code{ACCESS_CONTROL_LOGS},
\code{AUTHENTICATION_LOGS}, \code{WORKMAIL_AVAILABILITY_PROVIDER_LOGS},
\code{WORKMAIL_MAILBOX_ACCESS_LOGS}, and
\code{WORKMAIL_PERSONAL_ACCESS_TOKEN_LOGS}.
}}

\item{tags}{An optional list of key-value pairs to associate with the resource.

For more information about tagging, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}}
}
\description{
Creates or updates a logical \emph{delivery source}. A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3, or Firehose.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_delivery_source/} for full documentation.
}
\keyword{internal}
