% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_service.R
\name{ssm}
\alias{ssm}
\title{Amazon Simple Systems Manager (SSM)}
\usage{
ssm(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Web Services Systems Manager is the operations hub for your
Amazon Web Services applications and resources and a secure end-to-end
management solution for hybrid cloud environments that enables safe and
secure operations at scale.

This reference is intended to be used with the \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/}{Amazon Web Services Systems Manager User Guide}.
To get started, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/}{Setting up Amazon Web Services Systems Manager}.

\strong{Related resources}
\itemize{
\item For information about each of the tools that comprise Systems
Manager, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-tools.html}{Using Systems Manager tools}
in the \emph{Amazon Web Services Systems Manager User Guide}.
\item For details about predefined runbooks for Automation, a tool in
Amazon Web Services Systems Manager, see the \emph{\href{https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-runbook-reference.html}{Systems Manager Automation runbook reference}} .
\item For information about AppConfig, a tool in Systems Manager, see the
\emph{\href{https://docs.aws.amazon.com/appconfig/latest/userguide/}{AppConfig User Guide}} and the *
\href{https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/}{AppConfig API Reference}* .
\item For information about Incident Manager, a tool in Systems Manager,
see the \emph{\href{https://docs.aws.amazon.com/incident-manager/latest/userguide/}{Systems Manager Incident Manager User Guide}} and the *
\href{https://docs.aws.amazon.com/incident-manager/latest/APIReference/}{Systems Manager Incident Manager API Reference}* .
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ssm(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=ssm_add_tags_to_resource]{add_tags_to_resource} \tab Adds or overwrites one or more tags for the specified resource\cr
\link[=ssm_associate_ops_item_related_item]{associate_ops_item_related_item} \tab Associates a related item to a Systems Manager OpsCenter OpsItem\cr
\link[=ssm_cancel_command]{cancel_command} \tab Attempts to cancel the command specified by the Command ID\cr
\link[=ssm_cancel_maintenance_window_execution]{cancel_maintenance_window_execution} \tab Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't already starting running\cr
\link[=ssm_create_activation]{create_activation} \tab Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager\cr
\link[=ssm_create_association]{create_association} \tab A State Manager association defines the state that you want to maintain on your managed nodes\cr
\link[=ssm_create_association_batch]{create_association_batch} \tab Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes or targets\cr
\link[=ssm_create_document]{create_document} \tab Creates a Amazon Web Services Systems Manager (SSM document)\cr
\link[=ssm_create_maintenance_window]{create_maintenance_window} \tab Creates a new maintenance window\cr
\link[=ssm_create_ops_item]{create_ops_item} \tab Creates a new OpsItem\cr
\link[=ssm_create_ops_metadata]{create_ops_metadata} \tab If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type\cr
\link[=ssm_create_patch_baseline]{create_patch_baseline} \tab Creates a patch baseline\cr
\link[=ssm_create_resource_data_sync]{create_resource_data_sync} \tab A resource data sync helps you view data from multiple sources in a single location\cr
\link[=ssm_delete_activation]{delete_activation} \tab Deletes an activation\cr
\link[=ssm_delete_association]{delete_association} \tab Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed node\cr
\link[=ssm_delete_document]{delete_document} \tab Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the document\cr
\link[=ssm_delete_inventory]{delete_inventory} \tab Delete a custom inventory type or the data associated with a custom Inventory type\cr
\link[=ssm_delete_maintenance_window]{delete_maintenance_window} \tab Deletes a maintenance window\cr
\link[=ssm_delete_ops_item]{delete_ops_item} \tab Delete an OpsItem\cr
\link[=ssm_delete_ops_metadata]{delete_ops_metadata} \tab Delete OpsMetadata related to an application\cr
\link[=ssm_delete_parameter]{delete_parameter} \tab Delete a parameter from the system\cr
\link[=ssm_delete_parameters]{delete_parameters} \tab Delete a list of parameters\cr
\link[=ssm_delete_patch_baseline]{delete_patch_baseline} \tab Deletes a patch baseline\cr
\link[=ssm_delete_resource_data_sync]{delete_resource_data_sync} \tab Deletes a resource data sync configuration\cr
\link[=ssm_delete_resource_policy]{delete_resource_policy} \tab Deletes a Systems Manager resource policy\cr
\link[=ssm_deregister_managed_instance]{deregister_managed_instance} \tab Removes the server or virtual machine from the list of registered servers\cr
\link[=ssm_deregister_patch_baseline_for_patch_group]{deregister_patch_baseline_for_patch_group} \tab Removes a patch group from a patch baseline\cr
\link[=ssm_deregister_target_from_maintenance_window]{deregister_target_from_maintenance_window} \tab Removes a target from a maintenance window\cr
\link[=ssm_deregister_task_from_maintenance_window]{deregister_task_from_maintenance_window} \tab Removes a task from a maintenance window\cr
\link[=ssm_describe_activations]{describe_activations} \tab Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the number of nodes registered by using this activation\cr
\link[=ssm_describe_association]{describe_association} \tab Describes the association for the specified target or managed node\cr
\link[=ssm_describe_association_executions]{describe_association_executions} \tab Views all executions for a specific association ID\cr
\link[=ssm_describe_association_execution_targets]{describe_association_execution_targets} \tab Views information about a specific execution of a specific association\cr
\link[=ssm_describe_automation_executions]{describe_automation_executions} \tab Provides details about all active and terminated Automation executions\cr
\link[=ssm_describe_automation_step_executions]{describe_automation_step_executions} \tab Information about all active and terminated step executions in an Automation workflow\cr
\link[=ssm_describe_available_patches]{describe_available_patches} \tab Lists all patches eligible to be included in a patch baseline\cr
\link[=ssm_describe_document]{describe_document} \tab Describes the specified Amazon Web Services Systems Manager document (SSM document)\cr
\link[=ssm_describe_document_permission]{describe_document_permission} \tab Describes the permissions for a Amazon Web Services Systems Manager document (SSM document)\cr
\link[=ssm_describe_effective_instance_associations]{describe_effective_instance_associations} \tab All associations for the managed nodes\cr
\link[=ssm_describe_effective_patches_for_patch_baseline]{describe_effective_patches_for_patch_baseline} \tab Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline\cr
\link[=ssm_describe_instance_associations_status]{describe_instance_associations_status} \tab The status of the associations for the managed nodes\cr
\link[=ssm_describe_instance_information]{describe_instance_information} \tab Provides information about one or more of your managed nodes, including the operating system platform, SSM Agent version, association status, and IP address\cr
\link[=ssm_describe_instance_patches]{describe_instance_patches} \tab Retrieves information about the patches on the specified managed node and their state relative to the patch baseline being used for the node\cr
\link[=ssm_describe_instance_patch_states]{describe_instance_patch_states} \tab Retrieves the high-level patch state of one or more managed nodes\cr
\link[=ssm_describe_instance_patch_states_for_patch_group]{describe_instance_patch_states_for_patch_group} \tab Retrieves the high-level patch state for the managed nodes in the specified patch group\cr
\link[=ssm_describe_instance_properties]{describe_instance_properties} \tab An API operation used by the Systems Manager console to display information about Systems Manager managed nodes\cr
\link[=ssm_describe_inventory_deletions]{describe_inventory_deletions} \tab Describes a specific delete inventory operation\cr
\link[=ssm_describe_maintenance_window_executions]{describe_maintenance_window_executions} \tab Lists the executions of a maintenance window\cr
\link[=ssm_describe_maintenance_window_execution_task_invocations]{describe_maintenance_window_execution_task_invocations} \tab Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution\cr
\link[=ssm_describe_maintenance_window_execution_tasks]{describe_maintenance_window_execution_tasks} \tab For a given maintenance window execution, lists the tasks that were run\cr
\link[=ssm_describe_maintenance_windows]{describe_maintenance_windows} \tab Retrieves the maintenance windows in an Amazon Web Services account\cr
\link[=ssm_describe_maintenance_window_schedule]{describe_maintenance_window_schedule} \tab Retrieves information about upcoming executions of a maintenance window\cr
\link[=ssm_describe_maintenance_windows_for_target]{describe_maintenance_windows_for_target} \tab Retrieves information about the maintenance window targets or tasks that a managed node is associated with\cr
\link[=ssm_describe_maintenance_window_targets]{describe_maintenance_window_targets} \tab Lists the targets registered with the maintenance window\cr
\link[=ssm_describe_maintenance_window_tasks]{describe_maintenance_window_tasks} \tab Lists the tasks in a maintenance window\cr
\link[=ssm_describe_ops_items]{describe_ops_items} \tab Query a set of OpsItems\cr
\link[=ssm_describe_parameters]{describe_parameters} \tab Lists the parameters in your Amazon Web Services account or the parameters shared with you when you enable the Shared option\cr
\link[=ssm_describe_patch_baselines]{describe_patch_baselines} \tab Lists the patch baselines in your Amazon Web Services account\cr
\link[=ssm_describe_patch_groups]{describe_patch_groups} \tab Lists all patch groups that have been registered with patch baselines\cr
\link[=ssm_describe_patch_group_state]{describe_patch_group_state} \tab Returns high-level aggregated patch compliance state information for a patch group\cr
\link[=ssm_describe_patch_properties]{describe_patch_properties} \tab Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches\cr
\link[=ssm_describe_sessions]{describe_sessions} \tab Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days\cr
\link[=ssm_disassociate_ops_item_related_item]{disassociate_ops_item_related_item} \tab Deletes the association between an OpsItem and a related item\cr
\link[=ssm_get_automation_execution]{get_automation_execution} \tab Get detailed information about a particular Automation execution\cr
\link[=ssm_get_calendar_state]{get_calendar_state} \tab Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time\cr
\link[=ssm_get_command_invocation]{get_command_invocation} \tab Returns detailed information about command execution for an invocation or plugin\cr
\link[=ssm_get_connection_status]{get_connection_status} \tab Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready to receive Session Manager connections\cr
\link[=ssm_get_default_patch_baseline]{get_default_patch_baseline} \tab Retrieves the default patch baseline\cr
\link[=ssm_get_deployable_patch_snapshot_for_instance]{get_deployable_patch_snapshot_for_instance} \tab Retrieves the current snapshot for the patch baseline the managed node uses\cr
\link[=ssm_get_document]{get_document} \tab Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document)\cr
\link[=ssm_get_execution_preview]{get_execution_preview} \tab Initiates the process of retrieving an existing preview that shows the effects that running a specified Automation runbook would have on the targeted resources\cr
\link[=ssm_get_inventory]{get_inventory} \tab Query inventory information\cr
\link[=ssm_get_inventory_schema]{get_inventory_schema} \tab Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type\cr
\link[=ssm_get_maintenance_window]{get_maintenance_window} \tab Retrieves a maintenance window\cr
\link[=ssm_get_maintenance_window_execution]{get_maintenance_window_execution} \tab Retrieves details about a specific a maintenance window execution\cr
\link[=ssm_get_maintenance_window_execution_task]{get_maintenance_window_execution_task} \tab Retrieves the details about a specific task run as part of a maintenance window execution\cr
\link[=ssm_get_maintenance_window_execution_task_invocation]{get_maintenance_window_execution_task_invocation} \tab Retrieves information about a specific task running on a specific target\cr
\link[=ssm_get_maintenance_window_task]{get_maintenance_window_task} \tab Retrieves the details of a maintenance window task\cr
\link[=ssm_get_ops_item]{get_ops_item} \tab Get information about an OpsItem by using the ID\cr
\link[=ssm_get_ops_metadata]{get_ops_metadata} \tab View operational metadata related to an application in Application Manager\cr
\link[=ssm_get_ops_summary]{get_ops_summary} \tab View a summary of operations metadata (OpsData) based on specified filters and aggregators\cr
\link[=ssm_get_parameter]{get_parameter} \tab Get information about a single parameter by specifying the parameter name\cr
\link[=ssm_get_parameter_history]{get_parameter_history} \tab Retrieves the history of all changes to a parameter\cr
\link[=ssm_get_parameters]{get_parameters} \tab Get information about one or more parameters by specifying multiple parameter names\cr
\link[=ssm_get_parameters_by_path]{get_parameters_by_path} \tab Retrieve information about one or more parameters under a specified level in a hierarchy\cr
\link[=ssm_get_patch_baseline]{get_patch_baseline} \tab Retrieves information about a patch baseline\cr
\link[=ssm_get_patch_baseline_for_patch_group]{get_patch_baseline_for_patch_group} \tab Retrieves the patch baseline that should be used for the specified patch group\cr
\link[=ssm_get_resource_policies]{get_resource_policies} \tab Returns an array of the Policy object\cr
\link[=ssm_get_service_setting]{get_service_setting} \tab ServiceSetting is an account-level setting for an Amazon Web Services service\cr
\link[=ssm_label_parameter_version]{label_parameter_version} \tab A parameter label is a user-defined alias to help you manage different versions of a parameter\cr
\link[=ssm_list_associations]{list_associations} \tab Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region\cr
\link[=ssm_list_association_versions]{list_association_versions} \tab Retrieves all versions of an association for a specific association ID\cr
\link[=ssm_list_command_invocations]{list_command_invocations} \tab An invocation is copy of a command sent to a specific managed node\cr
\link[=ssm_list_commands]{list_commands} \tab Lists the commands requested by users of the Amazon Web Services account\cr
\link[=ssm_list_compliance_items]{list_compliance_items} \tab For a specified resource ID, this API operation returns a list of compliance statuses for different resource types\cr
\link[=ssm_list_compliance_summaries]{list_compliance_summaries} \tab Returns a summary count of compliant and non-compliant resources for a compliance type\cr
\link[=ssm_list_document_metadata_history]{list_document_metadata_history} \tab Information about approval reviews for a version of a change template in Change Manager\cr
\link[=ssm_list_documents]{list_documents} \tab Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region\cr
\link[=ssm_list_document_versions]{list_document_versions} \tab List all versions for a document\cr
\link[=ssm_list_inventory_entries]{list_inventory_entries} \tab A list of inventory items returned by the request\cr
\link[=ssm_list_nodes]{list_nodes} \tab Takes in filters and returns a list of managed nodes matching the filter criteria\cr
\link[=ssm_list_nodes_summary]{list_nodes_summary} \tab Generates a summary of managed instance/node metadata based on the filters and aggregators you specify\cr
\link[=ssm_list_ops_item_events]{list_ops_item_events} \tab Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account\cr
\link[=ssm_list_ops_item_related_items]{list_ops_item_related_items} \tab Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem\cr
\link[=ssm_list_ops_metadata]{list_ops_metadata} \tab Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs\cr
\link[=ssm_list_resource_compliance_summaries]{list_resource_compliance_summaries} \tab Returns a resource-level summary count\cr
\link[=ssm_list_resource_data_sync]{list_resource_data_sync} \tab Lists your resource data sync configurations\cr
\link[=ssm_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of the tags assigned to the specified resource\cr
\link[=ssm_modify_document_permission]{modify_document_permission} \tab Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately\cr
\link[=ssm_put_compliance_items]{put_compliance_items} \tab Registers a compliance type and other compliance details on a designated resource\cr
\link[=ssm_put_inventory]{put_inventory} \tab Bulk update custom inventory items on one or more managed nodes\cr
\link[=ssm_put_parameter]{put_parameter} \tab Add a parameter to the system\cr
\link[=ssm_put_resource_policy]{put_resource_policy} \tab Creates or updates a Systems Manager resource policy\cr
\link[=ssm_register_default_patch_baseline]{register_default_patch_baseline} \tab Defines the default patch baseline for the relevant operating system\cr
\link[=ssm_register_patch_baseline_for_patch_group]{register_patch_baseline_for_patch_group} \tab Registers a patch baseline for a patch group\cr
\link[=ssm_register_target_with_maintenance_window]{register_target_with_maintenance_window} \tab Registers a target with a maintenance window\cr
\link[=ssm_register_task_with_maintenance_window]{register_task_with_maintenance_window} \tab Adds a new task to a maintenance window\cr
\link[=ssm_remove_tags_from_resource]{remove_tags_from_resource} \tab Removes tag keys from the specified resource\cr
\link[=ssm_reset_service_setting]{reset_service_setting} \tab ServiceSetting is an account-level setting for an Amazon Web Services service\cr
\link[=ssm_resume_session]{resume_session} \tab Reconnects a session to a managed node after it has been disconnected\cr
\link[=ssm_send_automation_signal]{send_automation_signal} \tab Sends a signal to an Automation execution to change the current behavior or status of the execution\cr
\link[=ssm_send_command]{send_command} \tab Runs commands on one or more managed nodes\cr
\link[=ssm_start_associations_once]{start_associations_once} \tab Runs an association immediately and only one time\cr
\link[=ssm_start_automation_execution]{start_automation_execution} \tab Initiates execution of an Automation runbook\cr
\link[=ssm_start_change_request_execution]{start_change_request_execution} \tab Creates a change request for Change Manager\cr
\link[=ssm_start_execution_preview]{start_execution_preview} \tab Initiates the process of creating a preview showing the effects that running a specified Automation runbook would have on the targeted resources\cr
\link[=ssm_start_session]{start_session} \tab Initiates a connection to a target (for example, a managed node) for a Session Manager session\cr
\link[=ssm_stop_automation_execution]{stop_automation_execution} \tab Stop an Automation that is currently running\cr
\link[=ssm_terminate_session]{terminate_session} \tab Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the managed node\cr
\link[=ssm_unlabel_parameter_version]{unlabel_parameter_version} \tab Remove a label or labels from a parameter\cr
\link[=ssm_update_association]{update_association} \tab Updates an association\cr
\link[=ssm_update_association_status]{update_association_status} \tab Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified managed node\cr
\link[=ssm_update_document]{update_document} \tab Updates one or more values for an SSM document\cr
\link[=ssm_update_document_default_version]{update_document_default_version} \tab Set the default version of a document\cr
\link[=ssm_update_document_metadata]{update_document_metadata} \tab Updates information related to approval reviews for a specific version of a change template in Change Manager\cr
\link[=ssm_update_maintenance_window]{update_maintenance_window} \tab Updates an existing maintenance window\cr
\link[=ssm_update_maintenance_window_target]{update_maintenance_window_target} \tab Modifies the target of an existing maintenance window\cr
\link[=ssm_update_maintenance_window_task]{update_maintenance_window_task} \tab Modifies a task assigned to a maintenance window\cr
\link[=ssm_update_managed_instance_role]{update_managed_instance_role} \tab Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or virtual machines (VM)\cr
\link[=ssm_update_ops_item]{update_ops_item} \tab Edit or change an OpsItem\cr
\link[=ssm_update_ops_metadata]{update_ops_metadata} \tab Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager\cr
\link[=ssm_update_patch_baseline]{update_patch_baseline} \tab Modifies an existing patch baseline\cr
\link[=ssm_update_resource_data_sync]{update_resource_data_sync} \tab Update a resource data sync\cr
\link[=ssm_update_service_setting]{update_service_setting} \tab ServiceSetting is an account-level setting for an Amazon Web Services service
}
}

\examples{
\dontrun{
svc <- ssm()
svc$add_tags_to_resource(
  Foo = 123
)
}

}
