% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_update_rotation}
\alias{ssmcontacts_update_rotation}
\title{Updates the information specified for an on-call rotation}
\usage{
ssmcontacts_update_rotation(
  RotationId,
  ContactIds = NULL,
  StartTime = NULL,
  TimeZoneId = NULL,
  Recurrence
)
}
\arguments{
\item{RotationId}{[required] The Amazon Resource Name (ARN) of the rotation to update.}

\item{ContactIds}{The Amazon Resource Names (ARNs) of the contacts to include in the
updated rotation.

The order in which you list the contacts is their shift order in the
rotation schedule.}

\item{StartTime}{The date and time the rotation goes into effect.}

\item{TimeZoneId}{The time zone to base the updated rotation’s activity on, in Internet
Assigned Numbers Authority (IANA) format. For example:
"America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
the \href{https://www.iana.org/time-zones}{Time Zone Database} on the IANA
website.

Designators for time zones that don’t support Daylight Savings Time
Rules, such as Pacific Standard Time (PST) and Pacific Daylight Time
(PDT), aren't supported.}

\item{Recurrence}{[required] Information about how long the updated rotation lasts before restarting
at the beginning of the shift order.}
}
\description{
Updates the information specified for an on-call rotation.

See \url{https://www.paws-r-sdk.com/docs/ssmcontacts_update_rotation/} for full documentation.
}
\keyword{internal}
