% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_malware_protection_plan}
\alias{guardduty_create_malware_protection_plan}
\title{Creates a new Malware Protection plan for the protected resource}
\usage{
guardduty_create_malware_protection_plan(
  ClientToken = NULL,
  Role,
  ProtectedResource,
  Actions = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{The idempotency token for the create request.}

\item{Role}{[required] Amazon Resource Name (ARN) of the IAM role that has the permissions to
scan and add tags to the associated protected resource.}

\item{ProtectedResource}{[required] Information about the protected resource that is associated with the
created Malware Protection plan. Presently, \code{S3Bucket} is the only
supported protected resource.}

\item{Actions}{Information about whether the tags will be added to the S3 object after
scanning.}

\item{Tags}{Tags added to the Malware Protection plan resource.}
}
\description{
Creates a new Malware Protection plan for the protected resource.

See \url{https://www.paws-r-sdk.com/docs/guardduty_create_malware_protection_plan/} for full documentation.
}
\keyword{internal}
