% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_rotate_key_on_demand}
\alias{kms_rotate_key_on_demand}
\title{Immediately initiates rotation of the key material of the specified
symmetric encryption KMS key}
\usage{
kms_rotate_key_on_demand(KeyId)
}
\arguments{
\item{KeyId}{[required] Identifies a symmetric encryption KMS key. You cannot perform on-demand
rotation of \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{asymmetric KMS keys},
\href{https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html}{HMAC KMS keys},
KMS keys with \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{imported key material},
or KMS keys in a \href{https://docs.aws.amazon.com/kms/latest/developerguide/}{custom key store}. To
perform on-demand rotation of a set of related \href{https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-update.html#multi-region-rotate}{multi-Region keys},
invoke the on-demand rotation on the primary key.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}
}
\description{
Immediately initiates rotation of the key material of the specified symmetric encryption KMS key.

See \url{https://www.paws-r-sdk.com/docs/kms_rotate_key_on_demand/} for full documentation.
}
\keyword{internal}
