% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_cors}
\alias{s3_put_bucket_cors}
\title{This operation is not supported for directory buckets}
\usage{
s3_put_bucket_cors(
  Bucket,
  CORSConfiguration,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] Specifies the bucket impacted by the \code{cors}configuration.}

\item{CORSConfiguration}{[required] Describes the cross-origin access configuration for objects in an Amazon
S3 bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/cors.html}{Enabling Cross-Origin Resource Sharing}
in the \emph{Amazon S3 User Guide}.}

\item{ContentMD5}{The Base64 encoded 128-bit \code{MD5} digest of the data. This header must be
used as a message integrity check to verify that the request body was
not corrupted in transit. For more information, go to \href{https://www.ietf.org/rfc/rfc1864.txt}{RFC 1864.}

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the request when
you use the SDK. This header will not provide any additional
functionality if you don't use the SDK. When you send this header, there
must be a corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}
}
\description{
This operation is not supported for directory buckets.

See \url{https://www.paws-r-sdk.com/docs/s3_put_bucket_cors/} for full documentation.
}
\keyword{internal}
