% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfactor_log_interpret_kr.R
\name{bfactor_log_interpret_kr}
\alias{bfactor_log_interpret_kr}
\title{Interpretation of the logarithms of Bayes factors}
\usage{
bfactor_log_interpret_kr(bf, base = exp(1))
}
\arguments{
\item{bf}{A numeric vector.}

\item{base}{A numeric vector of \code{\link[base]{length}} one. Must be a positive number.}
}
\value{
Returns a character vector with the same {\link[base]{length}} as \code{bf}.
}
\description{
Quantify the strength of the evidence provided by the data to a model/hypothesis according a Bayes factor interpretation scale suggested by \insertCite{kass1995;textual}{pcal}.
}
\details{
Bayes factors are a summary of the evidence provided by the data to a model/hypothesis, and are often reported on a logarithmic scale. Because it can be useful to consider twice the natural logarithm of the Bayes factor, which is in the same scale as the familiar deviance and likelihood ratio test statistics, \insertCite{kass1995;textual}{pcal} suggested the following Bayes factor interpretation scale:\tabular{lll}{
   \strong{2*log(Bayes factor)} \tab \strong{Bayes factor} \tab \strong{Evidence} \cr
   [-Inf, 0[ \tab [0, 1[ \tab Negative \cr
   [0, 2[ \tab [1, 3[ \tab Weak \cr
   [2, 6[ \tab [3, 20[ \tab Positive \cr
   [6, 10[ \tab [20, 150[ \tab Strong \cr
   [10, +Inf[ \tab [150, +Inf[ \tab Very strong \cr
}


\code{bfactor_log_interpret_kr} takes (base \code{base}) logarithms of Bayes factors as input and returns the strength of the evidence provided by the data in favor of the  model/hypothesis in the numerator of the Bayes factors (usually the null hypothesis) according to the aforementioned table.

When comparing results with those from standard likelihood ratio tests, it is convenient to put the null hypothesis in the denominator of the Bayes factor so that \code{bfactor_log_interpret_kr} returns the strength of the evidence against the null hypothesis. If \code{bf} was obtained with the null hypothesis on the numerator, one can use \code{bfactor_log_interpret_kr(1/bf)} to obtain the strength of the evidence against the null hypothesis.
}
\examples{
# Interpretation of one Bayes factor, natural log
bfactor_log_interpret_kr(1.5)

# Interpretation of many Bayes factors, natural log
bfactor_log_interpret_kr(c(0.1, 1.2, 3.5, 13.9, 150))

# Interpretation of many Bayes factors, base 10 log
bfactor_log_interpret_kr(log10(c(0.1, 1.2, 3.5, 13.9, 150)), base = 10)

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[pcal]{bfactor_log_interpret}} for the original interpretation scale suggested by Harold Jeffreys
\item \code{\link[pcal]{bfactor_interpret}} and \code{\link[pcal]{bfactor_interpret_kr}} for the interpretation of Bayes factors in levels.
\item \code{\link[pcal]{bfactor_to_prob}} to turn Bayes factors into posterior probabilities.
\item \code{\link[pcal]{bcal}} for a p-value calibration that returns lower bounds on Bayes factors in favor of point null hypotheses.
}
}
