% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{PEdom.num.nondeg}
\alias{PEdom.num.nondeg}
\title{The domination number of Proportional Edge Proximity Catch Digraph
(PE-PCD) with non-degeneracy centers - multiple triangle case}
\usage{
PEdom.num.nondeg(Xp, Yp, r)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} here.}
}
\value{
A \code{list} with three elements
\item{dom.num}{Domination number of the PE-PCD
whose vertices are \code{Xp} points. PE proximity regions are
constructed with respect to the Delaunay triangles
based on the \code{Yp} points with expansion parameter \eqn{r in (1,1.5]}.}
#\item{mds}{A minimum dominating set of the PE-PCD
whose vertices are \code{Xp} points.}
\item{ind.mds}{The data indices of the minimum dominating set of the PE-PCD
whose vertices are \code{Xp} points.}
\item{tri.dom.nums}{Domination numbers of the PE-PCD components
for the Delaunay triangles.}
}
\description{
Returns the domination number,
indices of a minimum dominating set of PE-PCD
whose vertices are the data
points in \code{Xp} in the multiple triangle case
and domination numbers for the Delaunay triangles based on \code{Yp} points
when PE-PCD is constructed with vertex regions
based on non-degeneracy centers.

PE proximity regions are defined
with respect to the Delaunay triangles based on \code{Yp} points
with expansion parameter \eqn{r \ge 1}
and vertex regions in each triangle are
based on the center \eqn{M}
which is one of the 3 centers
that renders the asymptotic distribution of domination number
to be non-degenerate for a given value of \code{r} in \eqn{(1,1.5)}
and \code{M} is center of mass for \eqn{r=1.5}.

Convex hull of \code{Yp} is partitioned
by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
Loops are allowed for the domination number.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds})
more on the domination number of PE-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and
the corresponding algorithm.
}
\examples{
\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

r<-1.5  #try also r<-2

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

PEdom.num.nondeg(Xp,Yp,r)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEdom.num.tri}}, \code{\link{PEdom.num.tetra}},
\code{\link{dom.num.exact}}, and \code{\link{dom.num.greedy}}
}
\author{
Elvan Ceyhan
}
