% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDomination.R
\name{dom.num.exact}
\alias{dom.num.exact}
\title{Exact domination number (i.e., domination number
by the exact algorithm)}
\usage{
dom.num.exact(Inc.Mat)
}
\arguments{
\item{Inc.Mat}{A square matrix consisting of 0's and 1's
which represents the incidence matrix of
a graph or digraph.}
}
\value{
A \code{list} with two elements
\item{dom.num}{The cardinality of the (exact) minimum dominating set,
i.e., (exact) domination number of the
graph or digraph whose incidence matrix \code{Inc.Mat} is given as input.}
\item{ind.mds}{The vector of indices of the rows
in the incidence matrix \code{Inc.Mat} for the (exact) minimum dominating set.
The row numbers in the incidence matrix
correspond to the indices of the vertices
(i.e., indices of the data points).}
}
\description{
Returns the (exact) domination number
based on the incidence matrix \code{Inc.Mat} of a graph
or a digraph
and the indices (i.e., row numbers of \code{Inc.Mat})
for the corresponding (exact) minimum dominating set.
Here the row number in the incidence matrix corresponds
to the index of the vertex (i.e., index of the data
point). The function works whether loops are allowed
or not (i.e., whether the first diagonal is all 1 or
all 0). It takes a rather long time for large number of vertices
(i.e., large number of row numbers).
}
\examples{
\donttest{
n<-10
M<-matrix(sample(c(0,1),n^2,replace=TRUE),nrow=n)
diag(M)<-1

dom.num.greedy(M)
Idom.num.up.bnd(M,2)
dom.num.exact(M)
}

}
\seealso{
\code{\link{dom.num.greedy}}, \code{\link{PEdom.num1D}},
\code{\link{PEdom.num.tri}}, \code{\link{PEdom.num.nondeg}},
and \code{\link{Idom.numCSup.bnd.tri}}
}
\author{
Elvan Ceyhan
}
