% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{fr2vertsCCvert.reg}
\alias{fr2vertsCCvert.reg}
\title{The furthest points in a data set from vertices
in each \eqn{CC}-vertex region in a triangle}
\usage{
fr2vertsCCvert.reg(Xp, tri, ch.all.intri = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points
representing the set of data points.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{ch.all.intri}{A logical argument (default=\code{FALSE})
to check whether all data points are inside
the triangle \code{tri}. So, if it is \code{TRUE},
the function checks if all data points are
inside the closure of the triangle (i.e., interior and boundary
combined) else it does not.}
}
\value{
A \code{list} with the elements
\item{txt1}{Vertex labels are \eqn{A=1}, \eqn{B=2},
and \eqn{C=3} (correspond to row number in Extremum Points).}
\item{txt2}{A short description of the distances
as \code{"Distances from furthest points to ..."}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here,
furthest points from vertices in each \eqn{CC}-vertex region in the
triangle \code{tri}.}
\item{X}{The input data, \code{Xp}, can be a \code{matrix}
or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points, here,
it is the triangle \code{tri} for this function.}
\item{cent}{The center point used for construction of edge regions.}
\item{ncent}{Name of the center, \code{cent},
it is circumcenter \code{"CC"} for this function}
\item{regions}{CC-Vertex regions inside the triangle, \code{tri},
provided as a \code{list}}
\item{region.names}{Names of the vertex regions
as \code{"vr=1"}, \code{"vr=2"}, and \code{"vr=3"}}
\item{region.centers}{Centers of mass of the vertex regions
inside \code{tri}}
\item{dist2ref}{Distances from furthest points
in each vertex region to the corresponding vertex}
}
\description{
An object of class \code{"Extrema"}.
Returns the furthest data points among the data set, \code{Xp},
in each \eqn{CC}-vertex region from the vertex in the
triangle, \code{tri}\eqn{=T(A,B,C)}.
Vertex region labels/numbers correspond
to the row number of the vertex in \code{tri}.
\code{ch.all.intri} is for checking
whether all data points are inside \code{tri} (default is \code{FALSE}).

If some of the data points are not
inside \code{tri} and \code{ch.all.intri=TRUE},
then the function yields
an error message.
If some of the data points are not inside \code{tri}
and \code{ch.all.intri=FALSE}, then the function yields
the closest points to edges among the data points
inside \code{tri} (yields \code{NA} if there are no data points
inside \code{tri}).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.tri(n,Tr)$g

Ext<-fr2vertsCCvert.reg(Xp,Tr)
Ext
summary(Ext)
plot(Ext)

f2v<-Ext

CC<-circumcenter.tri(Tr)  #the circumcenter
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,xlab="",asp=1,ylab="",pch=".",
main="Furthest Points in CC-Vertex Regions \n from the Vertices",
axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(Xp)
points(rbind(f2v$ext),pch=4,col=2)

txt<-rbind(Tr,CC,Ds)
xc<-txt[,1]+c(-.06,.08,.05,.12,-.1,-.1,-.09)
yc<-txt[,2]+c(.02,-.02,.05,.0,.02,.06,-.04)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)

Xp2<-rbind(Xp,c(.2,.4))
fr2vertsCCvert.reg(Xp2,Tr,ch.all.intri = FALSE)
#gives an error message if ch.all.intri = TRUE
#since not all points in the data set are in the triangle
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fr2vertsCCvert.reg.basic.tri}}, \code{\link{fr2edgesCMedge.reg.std.tri}},
\code{\link{kfr2vertsCCvert.reg.basic.tri}} and \code{\link{kfr2vertsCCvert.reg}}
}
\author{
Elvan Ceyhan
}
