% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{funsMuVarPE2D}
\alias{funsMuVarPE2D}
\alias{muPE2D}
\alias{asy.varPE2D}
\title{Returns the mean and (asymptotic) variance of arc density of
Proportional Edge Proximity Catch Digraph (PE-PCD)
for 2D uniform data in one triangle}
\usage{
muPE2D(r)

asy.varPE2D(r)
}
\arguments{
\item{r}{A positive real number which serves
as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}
}
\value{
\code{muPE2D} returns the mean
and \code{asy.varPE2D} returns the (asymptotic) variance of the
arc density of PE-PCD for uniform data in any triangle.
}
\description{
Two functions: \code{muPE2D} and \code{asy.varPE2D}.

\code{muPE2D} returns the mean of the (arc) density of PE-PCD
and \code{asy.varPE2D} returns the asymptotic variance
of the arc density of PE-PCD
for 2D uniform data in a triangle.

PE proximity regions are defined
with expansion parameter \eqn{r \ge 1}
with respect to the triangle
in which the points reside and
vertex regions are based on center of mass, \eqn{CM} of the triangle.

See also (\insertCite{ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
\donttest{
#Examples for muPE2D
muPE2D(1.2)

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

mu<-vector()
for (i in 1:lrseq)
{
  mu<-c(mu,muPE2D(rseq[i]))
}

plot(rseq, mu,type="l",xlab="r",ylab=expression(mu(r)),lty=1,
xlim=range(rseq),ylim=c(0,1))
}

\donttest{
#Examples for asy.varPE2D
asy.varPE2D(1.2)

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

avar<-vector()
for (i in 1:lrseq)
{
  avar<-c(avar,asy.varPE2D(rseq[i]))
}

oldpar <- par(mar=c(5,5,4,2))
plot(rseq, avar,type="l",xlab="r",
ylab=expression(paste(sigma^2,"(r)")),lty=1,xlim=range(rseq))
par(oldpar)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{muCS2D}} and \code{\link{asy.varCS2D}}
}
\author{
Elvan Ceyhan
}
