% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{intersect.line.plane}
\alias{intersect.line.plane}
\title{The point of intersection of a line and a plane}
\usage{
intersect.line.plane(p1, p2, p3, p4, p5)
}
\arguments{
\item{p1, p2}{3D points that determine the straight line
(i.e., through which the straight line passes).}

\item{p3, p4, p5}{3D points that determine the plane
(i.e., through which the plane passes).}
}
\value{
The coordinates of the point of intersection the line
determined by the 3D points \eqn{p_1} and \eqn{p_2} and the
plane determined by 3D points \code{p3}, \code{p4}, and \code{p5}.
}
\description{
Returns the point of the intersection of the line
determined by the 3D points \eqn{p_1} and \eqn{p_2}
and the plane spanned
by 3D points \code{p3}, \code{p4}, and \code{p5}.
}
\examples{
\donttest{
L1<-c(2,4,6); L2<-c(1,3,5);
A<-c(1,10,3); B<-c(1,1,3); C<-c(3,9,12)

Pint<-intersect.line.plane(L1,L2,A,B,C)
Pint
pts<-rbind(L1,L2,A,B,C,Pint)

tr<-max(Dist(L1,L2),Dist(L1,Pint),Dist(L2,Pint))
tf<-tr*1.1 #how far to go at the lower and upper ends in the x-coordinate
tsq<-seq(-tf,tf,l=5)  #try also l=10, 20, or 100

lnAB3D<-Line3D(L1,L2,tsq)
xl<-lnAB3D$x
yl<-lnAB3D$y
zl<-lnAB3D$z

xr<-range(pts[,1]); yr<-range(pts[,2])
xf<-(xr[2]-xr[1])*.1
#how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1
#how far to go at the lower and upper ends in the y-coordinate
xp<-seq(xr[1]-xf,xr[2]+xf,l=5)  #try also l=10, 20, or 100
yp<-seq(yr[1]-yf,yr[2]+yf,l=5)  #try also l=10, 20, or 100

plABC<-Plane(A,B,C,xp,yp)
z.grid<-plABC$z

res<-persp(xp,yp,z.grid, xlab="x",ylab="y",zlab="z",theta = -30,
phi = 30, expand = 0.5,
col = "lightblue", ltheta = 120, shade = 0.05, ticktype = "detailed")
lines (trans3d(xl, yl, zl, pmat = res), col = 3)

Xlim<-range(xl,pts[,1])
Ylim<-range(yl,pts[,2])
Zlim<-range(zl,pts[,3])

xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::persp3D(z = z.grid, x = xp, y = yp, theta =225, phi = 30,
ticktype = "detailed"
,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05),zlim=Zlim+zd*c(-.1,.1),
expand = 0.7, facets = FALSE, scale = TRUE)
        #plane spanned by points A, B, C
#add the defining points
plot3D::points3D(pts[,1],pts[,2],pts[,3], pch = ".", col = "black",
bty = "f", cex = 5,add=TRUE)
plot3D::points3D(Pint[1],Pint[2],Pint[3], pch = "*", col = "red",
bty = "f", cex = 5,add=TRUE)
plot3D::lines3D(xl, yl, zl, bty = "g", cex = 2,
ticktype = "detailed",add=TRUE)
}

}
\seealso{
\code{\link{intersect2lines}} and \code{\link{intersect.line.circle}}
}
\author{
Elvan Ceyhan
}
