% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_software.R
\name{pre_format_report}
\alias{pre_format_report}
\title{Preprocess MPA Species Abundance and Taxonomy Data}
\usage{
pre_format_report(dir = "", exclude = NULL, relative_threshold = 1e-04)
}
\arguments{
\item{dir}{Character. Path to the directory containing the input file
"mpa_profile_species.txt". Default is an empty string (current directory).}

\item{exclude}{Character. Pattern to exclude specific taxa (e.g., "g__Streptococcus").
Uses grepl() for pattern matching. Default is NULL (no exclusion).}

\item{relative_threshold}{Numeric. Relative abundance threshold for filtering
low-abundance taxa. Taxa with mean relative abundance below this threshold
will be removed. Default is 1e-4.}
}
\value{
A list with two components:
\item{species}{A matrix of filtered species abundance data}
\item{species_taxonomy}{A data.frame of taxonomy information for each species}
}
\description{
This function reads a species abundance profile from kraken2 format_report output,
performs filtering to remove low-abundance and unwanted taxa, and extracts
a clean taxonomy table for downstream analysis.
}
\details{
The function performs the following steps:
\enumerate{
\item Reads the Metaphlan species profile table
\item Removes "unclassified" entries and "cellular_organisms" category
\item Filters out taxa matching the \code{exclude} pattern (if provided)
\item Applies relative abundance filtering using \code{pcutils::rm_low}
\item Extracts and formats taxonomy information from the Metaphlan-style names
\item Cleans species names by removing the "s__" prefix
}
}
