% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cow_majors.R
\name{add_cow_majors}
\alias{add_cow_majors}
\title{Add Correlates of War major power information to a data frame}
\usage{
add_cow_majors(data, mry = TRUE)
}
\arguments{
\item{data}{a data frame with appropriate \pkg{peacesciencer} attributes}

\item{mry}{logical, defaults to \code{TRUE}. If \code{TRUE}, the data carry forward the
identity of the major powers to the most recently concluded calendar year. If
\code{FALSE}, the panel honors the right bound of the data's temporal domain and
creates NAs for observations past it.}
}
\value{
\code{add_cow_majors()} takes a data frame and adds information
about major power status for the given state or dyad in that year. If the
data are dyad-year (or leader dyad-year), the function returns two
columns for whether the first state (i.e. \code{ccode1}) or the second
state (i.e. \code{ccode2}) are major powers in the given year, according
to the Correlates of War. 1 = is a major power. 0 = is not a major
power. If the data are state-year (or leader-year), the functions
returns just one column (\code{cowmaj}) for whether the
state was a major power in a given state-year.
}
\description{
\code{add_cow_majors()} allows you to add Correlates of War major
power variables to a dyad-year, leader-year, leader dyad-year, or state-year
data frame.
}
\details{
Be mindful that the data are fundamentally state-year and that extensions to
leader-level data should be understood as approximations for leaders in a
given state-year.

The \code{mry} argument works on an informal assumption that the composition of
the major powers are unchanged since the most recent data update. It simply
carries forward the most recent observation from the end of the data and
assumes there are no new major powers to note. Perhaps this is one way of
thinking about the absence of yearly updates from Correlates of War for its
composition data sets (i.e. state system, major powers). If there was a need
to update it in light of current events (e.g. the elimination or creation of
a new state, or the arrival/elimination of great power status), there would be
an immediate update to acknowledge it. The absence of an update means you can
just carry forward the most recent observations.
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_cow_majors()


}
\references{
Correlates of War Project. 2017. "State System Membership List, v2016."
Online, \url{https://correlatesofwar.org/data-sets/state-system-membership/}
}
\author{
Steven V. Miller
}
