% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_democracy.R
\name{add_democracy}
\alias{add_democracy}
\title{Add democracy information to a data frame}
\usage{
add_democracy(data, keep)
}
\arguments{
\item{data}{a data frame with appropriate \pkg{peacesciencer} attributes}

\item{keep}{an optional parameter, specified as a character vector, about
what democracy estimates the user wants to return from this function. If not
specified, everything from the underlying democracy data is returned.}
}
\value{
\code{add_democracy()} takes a (dyad-year, leader-year, leader-dyad-year,
state-year) data frame and adds information about the level of democracy
for the state or two states in the dyad in a given year. If the data are
dyad-year or leader-dyad-year, the function adds six total columns for
the first state  (i.e. \code{ccode1} or \code{gwcode1}) and the second state (i.e.
\code{ccode2} or  \code{gwcode2}) about the level of democracy measured by the
Varieties of  Democracy project (\code{v2x_polyarchy}), the Polity project
(\code{polity2}), and Xavier Marquez' \code{QuickUDS} extensions/estimates. If the
data are state-year or leader-year, the function returns three additional
columns to the original data that contain that same information for a given
state in a given year.
}
\description{
\code{add_democracy()} allows you to add estimates of democracy to your data.
}
\details{
As of version 1.2, this function leans on the information made available in
the \pkg{isard} package. This is a spin-off package I maintain for data that
require periodic updates for the functionality in this package. As of writing,
\pkg{peacesciencer} only requires that you have the \pkg{isard} package
installed. It does not require you to have any particular version of the
package installed. Thus, what exactly this function returns may depend on the
particular version of \pkg{isard} you have installed. This will assuredly
concern the right-bound of the temporal domain of data you get.

You can read more about the data in the documentation for \pkg{isard}.
\itemize{
\item \url{https://svmiller.com/isard/reference/cw_democracy.html}
\item \url{https://svmiller.com/isard/reference/gw_democracy.html}
}

Be mindful that the data are fundamentally state-year and that extensions to
leader-level data should be understood as approximations for leaders in a
given state-year.

included in the \code{cw_democracy} or \code{gw_democracy} data in the \pkg{isard}
data. Otherwise, it will return an error that it cannot subset columns that
do not exist.

A vignette on the package's website talks about how these data are here
primarily to encourage you to maximize the number of observations in the
analysis to follow. Xavier Marquez' \code{QuickUDS} estimates have the best
coverage. If democracy is ultimately a control variable, or otherwise a
variable not of huge concern for the analysis (i.e. the user has no
particular stake on the best measurement of democracy or the best
conceptualization and operationalization of "democracy"), please
use Marquez' estimates instead of Polity or V-dem. If the user is
doing an analysis of inter-state conflict, and across the standard
post-1816 domain in conflict studies,  \emph{definitely} don't use
the Polity data because the extent of its missingness is both large and
unnecessary. Please read the vignette describing these issues
here: \url{http://svmiller.com/peacesciencer/articles/democracy.html}
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_democracy()

create_stateyears(system="gw") \%>\% add_democracy()
create_stateyears(system="cow") \%>\% add_democracy()

}
\references{
Please cite Miller (2022) for \pkg{peacesciencer}. Beyond that, consult the
documentation in \pkg{isard} for additional citations (contingent on which
democracy estimate you are using).
}
\author{
Steven V. Miller
}
