% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-gml.R
\docType{data}
\name{gml_mid_disps}
\alias{gml_mid_disps}
\title{Abbreviated GML MID Dispute-level Data (v. 2.2.1)}
\format{
A data frame with 2,174 observations on the following 11 variables.
\describe{
\item{\code{dispnum}}{a numeric vector for the CoW-MID dispute number}
\item{\code{styear}}{a numeric vector for the start year of the MID}
\item{\code{stmon}}{a numeric vector for the start month of the MID}
\item{\code{outcome}}{a numeric vector for the outcome of the MID}
\item{\code{settle}}{a numeric vector for the how dispute was settled}
\item{\code{fatality}}{a numeric vector for the fatality level of the dispute}
\item{\code{mindur}}{a numeric vector for the minimum duration of the MID}
\item{\code{maxdur}}{a numeric vector for the maximum duration of the MID}
\item{\code{hiact}}{a numeric vector for the highest action of the MID}
\item{\code{hostlev}}{a numeric vector for the hostility level of the MID}
\item{\code{recip}}{a numeric vector for whether a MID was reciprocated}
}
}
\usage{
gml_mid_disps
}
\description{
This is an abbreviated version of the dispute-level Gibler-Miller-Little (GML) MID data.
}
\details{
These data are purposely light on information; they're not intended to be
used for dispute-level analyses, per se. They're intended to augment the
directed dyadic dispute-year data by adding in variables that serve as
exclusion rules to whittle the data from dyadic dispute-year to just dyad-year
data.
}
\references{
Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis
of the Militarized Interstate Dispute (MID) Dataset, 1816-2001.”
\emph{International Studies Quarterly} 60(4): 719-730.
}
\keyword{datasets}
