% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPeds.R
\name{buildPeds}
\alias{buildPeds}
\title{Build a list of pedigrees}
\usage{
buildPeds(
  labs,
  sex = 1,
  extra = "parents",
  age = NULL,
  knownPO = NULL,
  knownSub = NULL,
  allKnown = FALSE,
  notPO = NULL,
  noChildren = NULL,
  connected = TRUE,
  maxInbreeding = 1/16,
  linearInb = FALSE,
  sexSymmetry = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{labs}{A character vector of ID labels.}

\item{sex}{A vector of the same length as \code{labs}, with entries 1 (male) or 2
(female).}

\item{extra}{Either the word "parents" (default), or a non-negative integer.
See Details.}

\item{age}{A numeric or character vector. If numeric, and \code{age[i] < age[j]},
then individual \code{i} will not be an ancestor of individual \code{j}. The numbers
themselves are irrelevant, only the partial ordering. (No inference is made
about individuals of equal age.) Alternatively, for finer control, \code{age}
may be a character vector of inequalities, e.g., \code{age = c("1>2", "1>3")}.}

\item{knownPO}{A list of vectors of length 2, containing the ID labels of
pairs known to be parent-offspring. By default, both directions are
considered; use \code{age} to force a specific direction.}

\item{knownSub}{A \code{ped} object involving a subset of the \code{labs} individuals.}

\item{allKnown}{A logical. If TRUE, no other pairs than \code{knownPO} will be
assigned as parent-offspring. If FALSE (default), all pairs except those in
\code{notPO} are treated as potential parent-offspring.}

\item{notPO}{A list of vectors of length 2, containing the ID labels of pairs
known \emph{not} to be parent-offspring.}

\item{noChildren}{A vector of ID labels, indicating individuals without
children of their own.}

\item{connected}{A logical. If TRUE (default), only connected pedigrees are
returned.}

\item{maxInbreeding}{A single numeric indicating the highest permitted
inbreeding coefficient. Default: 1/16 (as with first-cousin parents.)}

\item{linearInb}{A parameter controlling the maximum separation of linearly
related spouses. Either TRUE (allow all linear inbreeding), FALSE (disallow
all) or a non-negative integer. For example, \code{linearInb = 1} allows
parent/child mating, but not grandparent/grandchild or more distant linear
relatives. Default: FALSE.}

\item{sexSymmetry}{A logical. If TRUE (default), pedigrees which are equal
except for the gender distribution of the \emph{added} parents, are regarded as
equivalent, and only one of each equivalence class is returned. Example:
paternal vs. maternal half sibs.}

\item{verbose}{A logical.}
}
\value{
A list of (possibly disconnected) pedigrees.
}
\description{
Build all pedigrees between a set of individuals, subject to given
restrictions.
}
\details{
The parameter \code{extra} controls which of two algorithms are used to create the
pedigree list.

If \code{extra} is a nonnegative integer, it determines the number of extra
individuals allowed in the iterative pedigree construction. These extras
start off with undetermined sex, meaning that both males and females are
used. It should be noted that the final pedigrees may contain additional
extras, since missing parents are added at the end.

If \code{extra} is the word "parents", the algorithm is not iterative. It first
generates all directed acyclic graphs between the original individuals. Then
their parents are added and merged in all possible ways. This option has the
advantage of not requiring an explicit/ad hoc number of "extras", but works
best in smaller cases.
}
\examples{
# Two individuals + 1 extra
plist = buildPeds(1:2, extra = 1, age = "1>2")
plot(plist)

# Allow disconnected
plist2 = buildPeds(1:2, extra = 1, age = "1>2", connected = FALSE)
plot(plist2, frames = TRUE)

# Note that full sibs require 2 extras
plist3 = buildPeds(1:2, extra = 2, age = "1>2")
plot(plist3)

# With 2 extras, allowing any inbreeding
plist4 = buildPeds(1:2, extra = 2, age = "1>2", maxInbreeding = 1)
plot(plist4)

# Full sibs are also included when `extra = "parents"`
plist5 = buildPeds(1:2, extra = "parents", age = "1>2")
plot(plist5)


}
