% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumpMutSpecial.R
\name{lumpMutSpecial}
\alias{lumpMutSpecial}
\title{Special lumping of mutation models}
\usage{
lumpMutSpecial(mut, lump, uSign, afreq = NULL, verbose = TRUE)
}
\arguments{
\item{mut}{A square mutation matrix; typically a \code{\link[=mutationMatrix]{mutationMatrix()}} or
\code{\link[=mutationModel]{mutationModel()}}.}

\item{lump}{A vector containing the alleles to be lumped together.}

\item{uSign}{The U-signature of the pedigree for which lumping is attempted.
See Details.}

\item{afreq}{A vector with allele frequencies, of the same length as the size
of \code{mut}. Extracted from the model if not given.}

\item{verbose}{A logical.}
}
\value{
A reduced mutation model, if lumping was possible, otherwise the
original model is returned unchanged.
}
\description{
This function implements methods for special, or pedigree-aware, allele
lumping. This is typically attempted if the model is not generally lumpable
as determined by \code{\link[=alwaysLumpable]{alwaysLumpable()}}. Note that the resulting lumped model is
tailor-made for a specific likelihood calculation, and may violate the
properties of a well-defined mutation model.
}
\details{
The lumping procedure depends on the location of untyped individuals in the
pedigree, summarised by the so-called U-signature:
\itemize{
\item F-depth: The length of the longest chain of untyped, starting with a founder
\item F-width: The maximum number of children of an untyped founder
\item N-depth: The length of the longest chain of untyped, starting with a nonfounder
\item N-width: The maximum number of children of an untyped nonfounder
}
}
\examples{

af = rep(0.05, 20)
names(af) = 1:20
m = mutationMatrix("random", afreq = af, rate = 0.1, seed = 1)

# Degree 1 lumping
mL = lumpMutSpecial(m, lump = 3:20, uSign = c(1,1,0,0))
mL

# Check
afL = attr(mL, "afreq")
stopifnot(sum(af * m[, 1]) == sum(afL * mL[, 1]))

# Degree 2
mL2 = lumpMutSpecial(m, lump = 3:20, uSign = c(1,2,0,0))
mL2
afL2 = attr(mL2, "afreq")

stopifnot(all.equal(af \%*\% m[, 1]^2, afL2 \%*\% mL2[, 1]^2),
          all.equal(af \%*\% m[, 2]^2, afL2 \%*\% mL2[, 2]^2),
          all.equal(af \%*\% ( m[, 1]*m[, 2]),
                    afL2 \%*\% (mL2[, 1]*mL2[, 2])))

}
\seealso{
\code{\link[=lumpedModel]{lumpedModel()}}.
}
