% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_stats.R
\name{sameGenotype}
\alias{sameGenotype}
\title{Find markers for which two individuals have the same genotype}
\usage{
sameGenotype(x, ids = typedMembers(x), count = FALSE)
}
\arguments{
\item{x}{A \code{ped} object or a list of such. An error is raised if \code{x} has no
marker data.}

\item{ids}{A vector of two individual ID labels.}

\item{count}{A logical. If TRUE, return the number of markers with shared
genotype.}
}
\value{
A logical vector with one entry per marker (\code{NA} if either genotype
is missing). If \code{count = TRUE}, the number of \code{TRUE} entries.
}
\description{
Identifies markers for which two individuals have the same (non-missing)
genotype. The comparison is done after sorting the genotypes internally.
}
\examples{
x = nuclearPed() |>
  addMarker(name = "m1", geno = c(NA, "1/1", "1/2")) |>
  addMarker(name = "m2", geno = c(NA, "1/2", "2/1"))

sameGenotype(x, 2:3)
sameGenotype(x, 2:3, count = TRUE)

}
\seealso{
\code{\link[=isHomozygous]{isHomozygous()}}, \code{\link[=sortGenotypes]{sortGenotypes()}}
}
