% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{conditional_mle}
\alias{conditional_mle}
\title{Compute MLE based on the full information R1, R2, R3 and R4.}
\usage{
conditional_mle(
  R1 = NULL,
  R2 = NULL,
  R3 = NULL,
  R4 = NULL,
  n = R1 + R2 + R3 + R4,
  pi0,
  gamma = 0.05,
  alpha0 = 0,
  alpha = 0,
  beta = 0,
  V = NULL,
  ...
)
}
\arguments{
\item{R1}{A \code{numeric} that provides the number of participants in the survey sample that were tested positive with both (medical) testing devices (and are, thus, members of the sub-population).}

\item{R2}{A \code{numeric} that provides the number of participants in the survey sample that are tested positive only with the first testing device (and are, thus,  members of the sub-population).}

\item{R3}{A \code{numeric} that provides the number of participants in the survey sample that are tested positive only with the second testing device.}

\item{R4}{A \code{numeric} that provides the number of participants that are tested negative with the second testing device (and are either members of the sub-population and have tested negative with the first testing device or are not members of the sub-population).}

\item{n}{A \code{numeric} that provides the sample size. Default value R1 + R2 + R3 + R4. If this value is provided it is used to verify that R1 + R2 + R3 + R4 = n.}

\item{pi0}{A \code{numeric} that provides the prevalence or proportion of people (in the whole population) who are positive, as measured through a non-random,
but systematic sampling (e.g. based on medical selection).}

\item{gamma}{A \code{numeric} that is used to compute a (1 - gamma) confidence region for the proportion. Default value is \code{0.05}.}

\item{alpha0}{A \code{numeric} that corresponds to the probability that a random participant
has been incorrectly declared positive through the nontransparent procedure. In most applications,
this probability is likely very close to zero. Default value is \code{0}.}

\item{alpha}{A \code{numeric} that provides the False Negative (FN) rate for the sample R. Default value is \code{0}.}

\item{beta}{A \code{numeric} that provides the False Positive (FP) rate for the sample R. Default value is \code{0}.}

\item{V}{A \code{numeric} that corresponds to the average of squared sampling weights. Default value is \code{NULL}.}

\item{...}{Additional arguments.}
}
\value{
A \code{cpreval} object with the structure:
\itemize{
 \item estimate:    Estimated proportion.
 \item sd:          Estimated standard error of the estimator.
 \item ci_asym:     Asymptotic confidence interval at the 1 - gamma confidence level.
 \item gamma:       Confidence level (i.e. 1 - gamma) for confidence intervals.
 \item method:      Estimation method (in this case mle).
 \item measurement: A vector with (alpha0, alpha, beta).
 \item beta0:       Estimated false negative rate of the official procedure.
 \item ci_beta0:    Asymptotic confidence interval (1 - gamma confidence level) for beta0.
 \item boundary:    A boolean variable indicating if the estimates falls at the boundary of the parameter space.
 \item pi0:         Value of pi0 (input value).
 \item sampling:    Type of sampling considered ("random" or "weighted").
 \item V:           Average sum of squared sampling weights if weighted/stratified is used (otherwise NULL).
 \item n:           Sample size.
 \item avar_beta0:  Estimated asymptotic variance of beta0
 \item ...:         Additional parameters.
}
}
\description{
Proportion estimated using the MLE and confidence intervals based the asymptotic distribution of the estimator.
}
\examples{
# Samples without measurement error
X = sim_Rs(theta = 3/100, pi0 = 1/100, n = 1500, seed = 18)
conditional_mle(R1 = X$R1, R2 = X$R2, R3 = X$R3, R4 = X$R4, pi0 = X$pi0)

# With measurement error
X = sim_Rs(theta = 30/1000, pi0 = 10/1000, n = 1500, alpha0 = 0.001,
alpha = 0.01, beta0 = 0.05, beta = 0.05, seed = 18)
conditional_mle(R1 = X$R1, R2 = X$R2, R3 = X$R3, R4 = X$R4, pi0 = X$pi0)
conditional_mle(R1 = X$R1, R2 = X$R2, R3 = X$R3, R4 = X$R4, pi0 = X$pi0,
alpha0 = 0.001, alpha = 0.01, beta = 0.05)
}
\author{
Stephane Guerrier, Maria-Pia Victoria-Feser, Christoph Kuzmics
}
