% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_best_vs_worst.R
\name{select_best_vs_worst}
\alias{select_best_vs_worst}
\title{Select Best vs Worst Peptides}
\usage{
select_best_vs_worst(appearance_best, appearance_worst)
}
\arguments{
\item{appearance_best}{A matrix with transformed counts for the 'best' group.}

\item{appearance_worst}{A matrix with transformed counts for the 'worst' group.}
}
\value{
A data frame with combinations of 'best' peptides.
}
\description{
This function identifies the peptides from the function *appearance_to_binary*
that are 1 in one group and 0 or -1 in another group, and expands the grid
to all possible combinations.
}
\examples{
# Generate some mock data
appearance_best <- matrix(c(1, -1, 0, 1, -1), nrow = 5, ncol = 4)
appearance_worst <- matrix(c(-1, 1, 0, -1, 1), nrow = 5, ncol = 4)
# Call the function
select_best_vs_worst(appearance_best, appearance_worst)
}
