% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_testing.R
\name{npc}
\alias{npc}
\title{Run NPC}
\usage{
npc(
  df,
  group_col,
  outcome_cols,
  strata_col = NULL,
  test_stat = "diff_in_means",
  perm_func = permute_group,
  combn = "fisher",
  shift = 0,
  reps = 10000,
  perm_set = NULL,
  complete_enum = FALSE,
  seed = NULL
)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{outcome_cols}{The names of the columns in df that corresponds to the outcome variable}

\item{strata_col}{The name of the column in df that corresponds to the strata}

\item{test_stat}{Test statistic function}

\item{perm_func}{Function to permute group, default is permute_group which randomly permutes group assignment}

\item{combn}{Combining function method to use, takes values 'fisher', 'tippett', or 'liptak', or a user defined function}

\item{shift}{Value of shift to apply in one- or two-sample problem}

\item{reps}{Number of iterations to use when calculating permutation p-value}

\item{perm_set}{Matrix of permutations to use instead of reps iterations of perm_func}

\item{complete_enum}{Boolean, whether to calculate P-value under complete enumeration of permutations}

\item{seed}{An integer seed value}
}
\value{
The omnibus p-value
}
\description{
This function takes a data frame and group and outcome column names as input
and returns the nonparametric combination of tests (NPC) omnibus p-value
}
\examples{
data <- data.frame(group = c(rep(1, 4), rep(2, 4)),
out1 = c(0, 1, 0, 0, 1, 1, 1, 0),
out2 = rep(1, 8))
output <- npc(df = data, group_col = "group",
              outcome_cols = c("out1", "out2"), perm_func = permute_group,
              combn = "fisher", reps = 10^4, seed=42)

}
