% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone.R
\name{clone}
\alias{clone}
\title{clone}
\usage{
clone(iter, ...)
}
\arguments{
\item{iter}{an \code{Iterator} object}

\item{...}{optionally override the \verb{$initial} parameters in \code{iter}}
}
\value{
a copy of the \code{Iterator} passed as a parameter
}
\description{
Clone an Iterator, making an exact copy that can then be modified separately.
This is a simple wrapper around \code{\link[rlang:env_clone]{rlang::env_clone()}}. Optionally,
override old initial parameters.
}
\examples{
it <- Iterator({m <- m + n}, list(m = 0, n = 1), m)
other <- clone(it)
yield_next(it)
current(other) == current(it) # false

it2 <- clone(other, n = 5)
yield_next(it2)
it2$initial$n  # 5
}
