% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential_monitor.R
\name{BB.aniplot}
\alias{BB.aniplot}
\title{Sequentially monitor patients using Beta-Binomial posterior probability}
\usage{
BB.aniplot(a, b, r, N=1, alpha=0.05, seed=1234, time.interval=1, output=TRUE)
}
\arguments{
\item{a}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{b}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{r}{vector of number of response in each cohort, the value of each element should not exceed N}

\item{N}{the number of patients treated by the experimental drug at a certain stage of the trial.}

\item{alpha}{the siginificant level to determine the credible interval, set 0.05 by default.}

\item{seed}{a single integer value, random number generator (RNG) state for random number generation.}

\item{time.interval}{a positive number to set the time interval of the animation (unit in seconds); default to be 1.}

\item{output}{a logical value, whether to output the inference results of posterior distribution and mean, observed data and credible interval.}
}
\value{
animation plot of updating posterior as prior, and output the inference information of prior and posterior distribution if \code{output=TRUE}.
}
\description{
Make animation plots to present sequential monitor the patients using Beta-Binomial Bayesian model
}
\examples{
# Using APL data
r=rep(0,6)
BB.aniplot(a=1,b=1,r=r, alpha=0.05, seed=1234)
# Simulate binomial data
B <- 10; N=1; p=0.3
r <- rbinom(n = B,size = N,prob = p)
BB.aniplot(a=1,b=1,r=r,time.interval = 0.2,output = FALSE)
}
\references{
Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}

