% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapTrend.R
\name{mapTrend}
\alias{mapTrend}
\title{Convert a series of phenology terra::raster files to a single long-term trend terra::raster.}
\usage{
mapTrend(
  File_List,
  Year_List,
  parallel = FALSE,
  n.cores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{File_List}{List of phenology terra::raster files (i.e. those produced in `mapPheno`)}

\item{Year_List}{Vector of Integer Year (YYYY) with length > 5}

\item{parallel}{TRUE or FALSE (Default = FALSE) if TRUE, use parallel backend through plyr::aaply}

\item{n.cores}{Integer number of cores to be used for parallel processing (only use if parallel = TRUE)}

\item{verbose}{TRUE or FALSE (Default = FALSE)}
}
\value{
terra::raster object with extent=ext(rast(File_List)[1]) and CRS = crs(rast(File_List)[1]).  Layer 1 is the slope estimate of the linear model relating green-up timing (Day of Year) to time (Year).  Layer 2 is the p-value of the slope estimate.  Layer 3 is the standard error of the slope estimate.  Layer 4 is the r-squared value for the linear model.
}
\description{
Convert a series of phenology terra::raster files to a single long-term trend terra::raster.
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="phenomap")
File_List.Trend <- paste(fpath, list.files(path = fpath, pattern=c("Sample_Greenup_")), sep="/")[5:6]

Year_List <- 2015:2016 # Tell it what years you're using
n.cores <- NA

phenotrend <- mapTrend(File_List = File_List.Trend,
                             Year_List = Year_List,
                             parallel = FALSE,
                             n.cores = n.cores,
                             verbose=FALSE)

}
\dontrun{

fpath <- system.file("extdata", package="phenomap")
File_List.Trend <- paste(fpath, list.files(path = fpath, pattern=c("Sample_Greenup_")), sep="/")

Year_List <- 2011:2016 # Tell it what years you're using
n.cores <- 4 # Set up parallel computing

phenotrend <- mapTrend(File_List = File_List.Trend,
                             Year_List = Year_List,
                             parallel = TRUE,
                             n.cores = n.cores,
                             verbose=TRUE)

}
}
