% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.r
\docType{data}
\name{band_pass_filters}
\alias{band_pass_filters}
\alias{'filter}
\alias{types'}
\alias{long_pass_filters}
\alias{short_pass_filters}
\title{Indexing of filters of different curve types}
\format{
A vector of character strings.

An object of class \code{character} of length 60.

An object of class \code{character} of length 17.
}
\usage{
band_pass_filters

long_pass_filters

short_pass_filters
}
\description{
Vectors of names of member objects grouped according to their type or optical
properties. Band-pass filters transmit a range of wavelengths, but block
shorter and longer ones. Long-pass filters absorb wavelengths shorter than
their cut-off and short-pass filters absorb wavelengths longer than their
cut-off. Multi-band and single-band pass filters are listed together.
}
\note{
These vectors include only optical-glass filters with well defined
characteristics.
}
\examples{
band_pass_filters

# select band-pass filters
filters.mspct[band_pass_filters]

}
\seealso{
\code{\link{filters.mspct}}
}
\keyword{datasets}
