test_that("read_licor() works with li6800_example", {
  expected_colnames = c("obs", "time", "elapsed", "date", "hhmmss", "averaging", "replicate", "WUE", "TIME", "E", "Emm", "A", "Ca", "Ci", "Pci", "Pca", "gsw", "gbw", "gtw", "gtc", "Rabs", "TleafEB", "TleafCnd", "SVPleaf", "RHcham", "VPcham", "SVPcham", "VPDleaf", "LatHFlux", "SenHFlux", "NetTherm", "EBSum", "Asty", "Esty", "Adyn", "Crd", "Csd", "dCsd/dt", "αVc", "Edyn", "Hr", "Hs", "dHs/dt", "αVh", "Leak", "LeakPct", "CorrFact", "CorrFactPct", "Fan", "DarkAdaptedID", "Qmax_d", "Fo", "Fm", "Fv/Fm", "A_dark", "LightAdaptedID", "Qmax", "Fs", "Fm'", "PhiPS2", "PS2/1", "Qabs_fs", "A_fs", "ETR", "PhiCO2", "NPQ", "alt._Fo'", "DarkPulseID", "Fmin", "Fo'", "Fv'/Fm'", "qP", "qN", "qP_Fo", "qN_Fo", "qL", "1-qL", "ID", "P1_dur", "P1_Fmax", "T@P1_Fmax", "Q@P1_Fmax", "P1_PredF", "P1_ΔF", "P2_dur", "P2_ramp", "P2_int", "P2_int_se", "P2_slp", "P2_slp_se", "P2_R2", "P2_dQdt", "P3_dur", "P3_Fmax", "T@P3_Fmax", "Q@P3_Fmax", "P3_PredF", "P3_ΔF", "ID", "Dur", "DCo", "InitSlope", "Fo", "F1", "T@F1", "T@HIR", "F2", "T@F2", "DCmax", "T@DCmax", "PhiPS2_dc", "Qin", "Qabs", "alpha", "convert", "TIME", "CO2_s", "CO2_r", "H2O_s", "H2O_r", "CO2_a", "H2O_a", "Flow", "Pa", "ΔPcham", "Tair", "Tleaf", "Tleaf2", "Offset", "Offset2", "Fan_speed", "Qamb_in", "Qamb_out", "ΔCO2", "CO2_s_d", "CO2_r_d", "ΔH2O", "CO2_b", "H2O_b", "e_s", "e_r", "Td_s", "Td_r", "Q", "f_red", "f_blue", "f_farred", "F", "Q_modavg", "F_dc", "Pc", "Tled", "TDigital", "TPreamp", "TPwrSpy", "TDrive", "Q_red", "Q_blue", "Q_farred", "TSPF", "state", "F_avg", "dF/dt", "dF_dc/dt", "F_dc_avg", "period", "time", "hhmmss", "co2_t", "h2o_t", "count", "co2_adj", "h2o_adj", "co2_match", "h2o_match", "co2_at", "h2o_at", "co2_cv", "h2o_cv", "ΔCO2:MN", "ΔCO2:SLP", "ΔCO2:SD", "ΔCO2:OK", "ΔH2O:MN", "ΔH2O:SLP", "ΔH2O:SD", "ΔH2O:OK", "Stable", "Total", "State", "Vflow", "VPchamber", "abs_c_a", "abs_c_b", "abs_h_a", "abs_h_b", "Wc_s", "Wc_r", "Wco_s", "Wco_r", "Ww_s", "Ww_r", "Wwo_s", "Wwo_r", "Flow_s_v", "Flow_r_v", "Tleaf_mv", "Tleaf2_mv", "Tleaf_j", "Tleaf2_j", "Console_RH", "Console_T", "Console_H2O", "Fan_%", "Flow_%", "Pump", "Tchp_pwm", "Txchg_pwm", "diag_20v", "diag_5_4v", "diag_12v", "diag_5va", "diag_3_3vf", "AccCO2_soda", "AccH2O_des", "AccH2O_hum", "CO2_hrs", "ADC_CH1", "ADC_CH2", "ADC_CH3", "ADC_CH4", "ADC_CH5", "ADC_CH6", "ADC_CH7", "ADC_CH8", "DAC_1", "DAC_2", "DAC_3", "DAC_4", "GPIO", "GPIO_dir", "excit_5v", "power_12v", "power_5v", "ch1_pullup", "AuxPower", "MatchValveR", "MatchValveS", "MatchCO2", "MatchH2O", "cf_co2_a", "cf_co2_b", "cf_co2_c", "cf_co2_d", "cf_h2o_a", "cf_h2o_b", "cf_h2o_c", "cf_h2o_d", "co2_fit_low", "co2_fit_high", "h2o_fit_low", "h2o_fit_high", "co2_elapsed", "h2o_elapsed", "CO2_f", "CO2_f_s", "Pump_f", "Pump_f_s", "Pump_p", "Pump_p_s", "Tboard", "V_system", "DIAG", "Flow_s", "Flow_r", "Txchg", "Tirga", "Tchopper", "Ts", "Tr", "CO2_%", "Desiccant_%", "Humidifier_%", "Txchg_sp", "CO2_r_sp", "H2O_r_sp", "SS_s", "SS_r", "")
  
  expected_A = c(33.13403, 32.227907, 30.797732, 29.704917, 29.08634, 28.392171, 27.306593, 25.393904, 24.263535, 22.448714, 19.973583, 16.943276, 12.96815, 8.694753, 6.228032, 4.865344, 3.612377, 2.190692, 0.620133, -0.825942, -2.460769, 22.251224)
  expected_SS_r = c(100.669, 100.662, 100.661, 100.655, 100.649, 100.646, 100.644, 100.639, 100.638, 100.635, 100.635, 100.629, 100.625, 100.619, 100.617, 100.618, 100.613, 100.613, 100.61, 100.612, 100.611, 100.608)
  
  li6800_example_path = system.file("extdata", "li6800_example",
                                   package = "photosynthesis")
  li6800_example = read_licor(li6800_example_path)
  expect_true(all(dim(li6800_example) == c(22, 289)))
  expect_true(all(colnames(li6800_example) == expected_colnames))
  expect_true(all(round(li6800_example$A, 6) == expected_A))
  expect_true(all(round(li6800_example$SS_r, 3) == expected_SS_r))
  
  # expect_equal(2 * 2, 4)
})
