% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_traits.R
\name{map_trait}
\alias{map_trait}
\title{Map species' trait values in geographic space}
\usage{
map_trait(x, trait, FUN = sum, pol = NULL, ...)
}
\arguments{
\item{x}{A community data object - a vector (with names matching trait data)
or a data.frame or matrix (with column names matching names in trait data)}

\item{trait}{A data.frame of species traits with a column of species names
matching species names in the community data, and another column with
the trait values.}

\item{FUN}{The function used to aggregate species trait values
in geographic space. By default, if \code{FUN = sum}, the sum of
all species traits per area  or grid cell is calculated.}

\item{pol}{a vector polygon of grid cells.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A data frame of species traits by site.
}
\description{
\code{map_trait} add species trait values to species distribution
in geographic space.
}
\examples{
data(africa)
library(terra)
p <- vect(system.file("ex/sa.json", package = "phyloregion"))
x <- EDGE(africa$IUCN, africa$phylo, Redlist = "IUCN",
          species = "Species")
y <- map_trait(africa$comm, x, FUN = sd, pol = p)

plot(y, "traits", col = hcl.colors(n=20, palette = "Blue-Red 3", rev=FALSE))
}
\author{
Barnabas H. Daru \email{darunabas@gmail.com}
}
\keyword{phyloregion}
