% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/true_pairs.R
\name{true_pairs}
\alias{true_pairs}
\title{Calculate expected number of true transmission pairs}
\usage{
true_pairs(eta, rho, M, R = NULL, assumption = "mtml")
}
\arguments{
\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen (default=NULL)}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
\item \code{'stsl'} for the single-transmission single-linkage assumption (\code{\link[=prob_trans_stsl]{prob_trans_stsl()}}).
\item \code{'mtsl'} for the multiple-transmission single-linkage assumption (\code{\link[=prob_trans_mtsl]{prob_trans_mtsl()}}).
\item \code{'mtml'} for the multiple-transmission multiple-linkage assumption (\code{\link[=prob_trans_mtml]{prob_trans_mtml()}}).
}}
}
\value{
scalar or vector giving the expected number of true transmission pairs in the sample
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function calculates the expected number true transmission pairs in a sample of size \code{M}.
Assumptions about transmission and linkage (single or multiple) can be specified.
}
\examples{
true_pairs(eta=0.99, rho=0.75, M=100, R=1)

}
\seealso{
Other true_pairs: 
\code{\link{true_pairs_mtml}()},
\code{\link{true_pairs_mtsl}()},
\code{\link{true_pairs_stsl}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{true_pairs}
