% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{USA_Election_2016}
\alias{USA_Election_2016}
\title{USA_Election_2016}
\format{A data.frame with 5 variables:
\describe{
\item{\code{EnteredDateTime}}{Time of the wager line in UTC}
\item{\code{TeamName1}}{Team name of the Away Team}
\item{\code{TeamName2}}{Team name of the Home Team}
\item{\code{MoneyUS1}}{Moneyline US odds for Away Team}
\item{\code{MoneyUS2}}{Moneyline US odds for Home Team}
}}
\usage{
USA_Election_2016
}
\description{
US Presidential Election data 2016.
}
\details{
All lines from Pinnacle for the 2016 US Presidential Election
}
\examples{
if (require("odds.converter")) {
library(tidyverse)
# What is Hilary Clinton's the highest implied winning probability at Pinnacle?

USA_Election_2016[which.min(USA_Election_2016$MoneyUS1),"EnteredDateTime"]
odds.converter::odds.us2prob(min(USA_Election_2016$MoneyUS1))
}

# What time on election night that Trump's implied winning probability surpassed Clinton's?
if (require("tidyverse")) {
library(tidyverse)
USA_Election_2016 \%>\% 
 filter(MoneyUS1>MoneyUS2) \%>\%
 slice(1)
}
}
\keyword{datasets}
